/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.util.validation.ValidationResult;
import com.aol.cyclops.util.validation.ValidationResults;
import java.beans.ConstructorProperties;
import java.util.function.Predicate;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple3;

public class Validator<T, R, E> {
    private final Tuple3<Predicate<? super T>, R, E> validation;
    private final Validator<T, R, E> next;

    public Validator<T, R, E> isValid(Predicate<? super T> valid, E error, R result) {
        return this.add(Tuple.tuple(valid, result, error));
    }

    public ValidationResults<R, E> accumulate() {
        return this.accumulate(null);
    }

    public ValidationResults<R, E> accumulate(T input) {
        ListX results = ListX.empty();
        ValidationResult<Object, Object> result = this.isValid(input) ? ValidationResult.SuccessfulResult.success(this.validation.v2) : ValidationResult.FailedResult.fail(this.validation.v3);
        results.add(result);
        if (this.next != null) {
            results.addAll(this.next.accumulate(input).getResults());
        }
        return new ValidationResults(results);
    }

    private boolean isValid(T input) {
        return ((Predicate)this.validation.v1).test(input);
    }

    public ValidationResults<R, E> accumulateUntilFail(T input) {
        ListX results = ListX.empty();
        if (!this.isValid(input)) {
            ValidationResult result = ValidationResult.FailedResult.fail(this.validation.v3);
            results.add(result);
            return new ValidationResults(results);
        }
        ValidationResult result = ValidationResult.SuccessfulResult.success(this.validation.v2);
        results.add(result);
        if (this.next != null) {
            results.addAll(this.next.accumulate(input).getResults());
        }
        return new ValidationResults(results);
    }

    public Validator<T, R, E> add(Xor<E, R> validation) {
        if (this.next == null) {
            return this.withNext(new Validator<T, R, E>(Validator.convert(validation), null));
        }
        return super.add(Validator.convert(validation));
    }

    public Validator<T, R, E> add(Validator<T, R, E> validator) {
        if (this.next == null) {
            return this.withNext(validator);
        }
        return super.add(this.validation);
    }

    private Validator<T, R, E> add(Tuple3<Predicate<? super T>, R, E> validation) {
        if (this.next == null) {
            return this.withNext(new Validator<T, R, E>(validation, null));
        }
        return super.add(validation);
    }

    public static <T, R, E> Validator<T, R, E> of(Predicate<? super T> valid, E error, R result) {
        return new Validator<T, R, E>(Tuple.tuple(valid, result, error), null);
    }

    public static <T, R, E> Validator<T, R, E> of(Xor<E, R> validation) {
        return new Validator<T, R, E>(Validator.convert(validation), null);
    }

    private static <T, R, E> Tuple3<Predicate<? super T>, R, E> convert(Xor<E, R> validation) {
        if (validation.isPrimary()) {
            return Tuple.tuple(t -> true, validation.get(), null);
        }
        return Tuple.tuple(t -> false, null, validation.swap().get());
    }

    @ConstructorProperties(value={"validation", "next"})
    public Validator(Tuple3<Predicate<? super T>, R, E> validation, Validator<T, R, E> next) {
        this.validation = validation;
        this.next = next;
    }

    public Validator<T, R, E> withValidation(Tuple3<Predicate<? super T>, R, E> validation) {
        return this.validation == validation ? this : new Validator<T, R, E>(validation, this.next);
    }

    public Validator<T, R, E> withNext(Validator<T, R, E> next) {
        return this.next == next ? this : new Validator<T, R, E>(this.validation, next);
    }
}

