/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Semigroup;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.MonadicValue1;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.types.applicative.ApplicativeFunctor;
import com.aol.cyclops.types.stream.reactive.ValueSubscriber;
import com.aol.cyclops.util.function.Curry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jooq.lambda.tuple.Tuple;
import org.reactivestreams.Publisher;

public interface Maybe<T>
extends MonadicValue1<T>,
Supplier<T>,
ConvertableFunctor<T>,
Filterable<T>,
ApplicativeFunctor<T>,
Matchable.ValueAndOptionalMatcher<T> {
    public static final Maybe EMPTY = new Nothing();

    public static <T> Maybe<T> none() {
        return EMPTY;
    }

    public static <T> Maybe<T> fromPublisher(Publisher<T> pub) {
        ValueSubscriber sub = ValueSubscriber.subscriber();
        pub.subscribe(sub);
        return sub.toMaybe();
    }

    public static <T> Maybe<T> fromIterable(Iterable<T> iterable) {
        return Maybe.fromEvalOf(Eval.fromIterable(iterable));
    }

    public static <T> Maybe<T> fromOptional(Optional<T> opt) {
        if (opt.isPresent()) {
            return Maybe.of(opt.get());
        }
        return Maybe.none();
    }

    public static <T> Maybe<T> fromEvalOf(Eval<T> eval) {
        return new Just(eval);
    }

    public static <T> Maybe<T> just(T value) {
        return Maybe.of(value);
    }

    public static <T> Maybe<T> of(T value) {
        Objects.requireNonNull(value);
        return new Just(Eval.later(() -> value));
    }

    public static <T> Maybe<T> ofNullable(T value) {
        if (value != null) {
            return Maybe.of(value);
        }
        return Maybe.none();
    }

    public static <T> Maybe<T> narrow(Maybe<? extends T> broad) {
        return broad;
    }

    public static <T> Maybe<ListX<T>> sequenceJust(CollectionX<Maybe<T>> opts) {
        Maybe unwrapped = (Maybe)AnyM.sequence(opts.map((T o) -> AnyM.fromMaybe(o))).unwrap();
        return unwrapped;
    }

    public static <T> Maybe<ListX<T>> sequence(CollectionX<Maybe<T>> maybes) {
        return Maybe.sequence(maybes.stream()).map((T s) -> s.toListX());
    }

    public static <T> Maybe<ReactiveSeq<T>> sequence(Stream<Maybe<T>> maybes) {
        return (Maybe)AnyM.sequence(maybes.map((? super T f) -> AnyM.fromMaybe(f)), () -> AnyM.fromMaybe(Maybe.just(Stream.empty()))).map((T s) -> ReactiveSeq.fromStream(s)).unwrap();
    }

    public static <T, R> Maybe<R> accumulateJust(CollectionX<Maybe<T>> maybes, Reducer<R> reducer) {
        return Maybe.sequenceJust(maybes).map((T s) -> s.mapReduce(reducer));
    }

    public static <T, R> Maybe<R> accumulateJust(CollectionX<Maybe<T>> maybes, Function<? super T, R> mapper, Semigroup<R> reducer) {
        return Maybe.sequenceJust(maybes).map((T s) -> s.map(mapper).reduce(reducer.reducer()).get());
    }

    public static <T> Maybe<T> accumulateJust(CollectionX<Maybe<T>> maybes, Semigroup<T> reducer) {
        return Maybe.sequenceJust(maybes).map((T s) -> s.reduce(reducer.reducer()).get());
    }

    @Override
    default public <T2, R> Maybe<R> ap(Value<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return this.map((T v) -> Tuple.tuple((Object)v, Curry.curry2(fn).apply(v))).flatMap((T tuple) -> app.visit(i -> Maybe.just(((Function)tuple.v2).apply(i)), () -> Maybe.none()));
    }

    @Override
    default public <T2, R> Maybe<R> zip(Iterable<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return this.map((T v) -> Tuple.tuple((Object)v, Curry.curry2(fn).apply(v))).flatMap((T tuple) -> Maybe.fromIterable(app).visit(i -> Maybe.just(((Function)tuple.v2).apply(i)), () -> Maybe.none()));
    }

    @Override
    default public <T2, R> Maybe<R> zip(BiFunction<? super T, ? super T2, ? extends R> fn, Publisher<? extends T2> app) {
        return this.map((T v) -> Tuple.tuple((Object)v, Curry.curry2(fn).apply(v))).flatMap((T tuple) -> Maybe.fromPublisher(app).visit(i -> Maybe.just(((Function)tuple.v2).apply(i)), () -> Maybe.none()));
    }

    @Override
    default public <T> Maybe<T> unit(T unit) {
        return Maybe.of(unit);
    }

    @Override
    default public <R> Maybe<R> coflatMap(Function<? super MonadicValue<T>, R> mapper) {
        return (Maybe)MonadicValue1.super.coflatMap(mapper);
    }

    @Override
    default public Maybe<MonadicValue<T>> nest() {
        return (Maybe)MonadicValue1.super.nest();
    }

    @Override
    default public Maybe<T> combine(Monoid<T> monoid, MonadicValue<? extends T> v2) {
        return (Maybe)MonadicValue1.super.combine(monoid, v2);
    }

    @Override
    default public Maybe<T> toMaybe() {
        return this;
    }

    @Override
    public boolean isPresent();

    public Maybe<T> recover(Supplier<T> var1);

    public Maybe<T> recover(T var1);

    @Override
    public <R> Maybe<R> map(Function<? super T, ? extends R> var1);

    @Override
    public <R> Maybe<R> flatMap(Function<? super T, ? extends MonadicValue<? extends R>> var1);

    @Override
    public <R> R visit(Function<? super T, ? extends R> var1, Supplier<? extends R> var2);

    @Override
    public Maybe<T> filter(Predicate<? super T> var1);

    @Override
    default public <U> Maybe<U> ofType(Class<? extends U> type) {
        return (Maybe)Filterable.super.ofType(type);
    }

    @Override
    default public Maybe<T> filterNot(Predicate<? super T> fn) {
        return (Maybe)Filterable.super.filterNot(fn);
    }

    @Override
    default public Maybe<T> notNull() {
        return (Maybe)Filterable.super.notNull();
    }

    @Override
    default public <U> Maybe<U> cast(Class<? extends U> type) {
        return (Maybe)ApplicativeFunctor.super.cast(type);
    }

    @Override
    default public Maybe<T> peek(Consumer<? super T> c) {
        return (Maybe)ApplicativeFunctor.super.peek(c);
    }

    @Override
    default public <R> Maybe<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (Maybe)ApplicativeFunctor.super.trampoline(mapper);
    }

    @Override
    default public <R> Maybe<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (Maybe)ApplicativeFunctor.super.patternMatch(case1, otherwise);
    }

    public static class Nothing<T>
    implements Maybe<T> {
        @Override
        public <R> Maybe<R> map(Function<? super T, ? extends R> mapper) {
            return EMPTY;
        }

        @Override
        public <R> Maybe<R> flatMap(Function<? super T, ? extends MonadicValue<? extends R>> mapper) {
            return EMPTY;
        }

        @Override
        public Maybe<T> filter(Predicate<? super T> test) {
            return EMPTY;
        }

        @Override
        public T get() {
            return Optional.ofNullable(null).get();
        }

        @Override
        public Maybe<T> recover(T value) {
            return Maybe.of(value);
        }

        @Override
        public Maybe<T> recover(Supplier<T> value) {
            return new Just(Eval.later(value));
        }

        @Override
        public <R> R visit(Function<? super T, ? extends R> some, Supplier<? extends R> none) {
            return none.get();
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.ofNullable(null);
        }

        public String toString() {
            return this.mkString();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Nothing) {
                return true;
            }
            if (obj instanceof Lazy) {
                return !((Lazy)obj).isPresent();
            }
            return false;
        }

        @Override
        public T orElse(T value) {
            return value;
        }

        @Override
        public T orElseGet(Supplier<? extends T> value) {
            return value.get();
        }
    }

    public static final class Lazy<T>
    implements Maybe<T> {
        private final Eval<Maybe<T>> lazy;

        @Override
        public <R> Maybe<R> map(Function<? super T, ? extends R> mapper) {
            return this.flatMap((T t) -> Maybe.just(mapper.apply(t)));
        }

        @Override
        public <R> Maybe<R> flatMap(Function<? super T, ? extends MonadicValue<? extends R>> mapper) {
            Supplier<Eval> s = () -> Eval.later(() -> Maybe.none());
            Eval eval = this.lazy.get().visit(some -> Eval.later(() -> Maybe.narrow(((MonadicValue)mapper.apply(some)).toMaybe())), s);
            return new Lazy<T>(eval);
        }

        @Override
        public Maybe<T> filter(Predicate<? super T> test) {
            return this.flatMap((T t) -> test.test(t) ? this : Maybe.none());
        }

        @Override
        public <R> R visit(Function<? super T, ? extends R> some, Supplier<? extends R> none) {
            MonadicValue mapped = this.map((Function)some);
            if (this.isPresent()) {
                return (R)mapped.get();
            }
            return none.get();
        }

        @Override
        public Maybe<T> recover(T value) {
            return new Lazy<T>(this.lazy.map((T m) -> m.recover(value)));
        }

        @Override
        public Maybe<T> recover(Supplier<T> value) {
            return new Lazy<T>(this.lazy.map((T m) -> m.recover(value)));
        }

        public String toString() {
            Maybe<T> maybe = this.lazy.get();
            while (maybe instanceof Lazy) {
                maybe = ((Lazy)maybe).lazy.get();
            }
            return maybe.mkString();
        }

        @Override
        public T get() {
            Maybe<T> maybe = this.lazy.get();
            while (maybe instanceof Lazy) {
                maybe = ((Lazy)maybe).lazy.get();
            }
            return maybe.get();
        }

        @Override
        public boolean isPresent() {
            Maybe<T> maybe = this.lazy.get();
            while (maybe instanceof Lazy) {
                maybe = ((Lazy)maybe).lazy.get();
            }
            return maybe.isPresent();
        }

        @Override
        public T orElse(T value) {
            Maybe<T> maybe = this.lazy.get();
            while (maybe instanceof Lazy) {
                maybe = ((Lazy)maybe).lazy.get();
            }
            return maybe.orElse(value);
        }

        @Override
        public T orElseGet(Supplier<? extends T> value) {
            Maybe<? extends T> maybe = this.lazy.get();
            while (maybe instanceof Lazy) {
                maybe = ((Lazy)maybe).lazy.get();
            }
            return maybe.orElseGet(value);
        }

        public int hashCode() {
            Maybe<T> maybe = this.lazy.get();
            while (maybe instanceof Lazy) {
                maybe = ((Lazy)maybe).lazy.get();
            }
            return Objects.hashCode(maybe.get());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Just) {
                return Objects.equals(this.get(), ((Just)obj).get());
            }
            if (obj instanceof Nothing) {
                return !this.isPresent();
            }
            if (obj instanceof Lazy) {
                if (this.isPresent()) {
                    return Objects.equals(this.get(), ((Lazy)obj).get());
                }
                return !((Lazy)obj).isPresent();
            }
            return false;
        }

        private Lazy(Eval<Maybe<T>> lazy) {
            this.lazy = lazy;
        }
    }

    public static final class Just<T>
    implements Maybe<T> {
        private final Eval<T> lazy;

        @Override
        public <R> Maybe<R> map(Function<? super T, ? extends R> mapper) {
            return new Just<T>(this.lazy.map(t -> mapper.apply(t)));
        }

        @Override
        public <R> Maybe<R> flatMap(Function<? super T, ? extends MonadicValue<? extends R>> mapper) {
            return new Lazy(Eval.later(() -> this)).flatMap((Function)mapper);
        }

        @Override
        public Maybe<T> filter(Predicate<? super T> test) {
            if (test.test(this.lazy.get())) {
                return this;
            }
            return EMPTY;
        }

        @Override
        public <R> R visit(Function<? super T, ? extends R> some, Supplier<? extends R> none) {
            return (R)this.map((Function)some).get();
        }

        @Override
        public Maybe<T> recover(T value) {
            return this;
        }

        @Override
        public Maybe<T> recover(Supplier<T> value) {
            return this;
        }

        public String toString() {
            return this.mkString();
        }

        @Override
        public T get() {
            return this.lazy.get();
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(this.lazy.get());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Just) {
                return Objects.equals(this.lazy.get(), ((Just)obj).get());
            }
            if (obj instanceof Lazy) {
                return Objects.equals(this.get(), ((Lazy)obj).get());
            }
            return false;
        }

        @Override
        public T orElse(T value) {
            return this.lazy.get();
        }

        @Override
        public T orElseGet(Supplier<? extends T> value) {
            return this.lazy.get();
        }

        private Just(Eval<T> lazy) {
            this.lazy = lazy;
        }
    }
}

