/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.async.Adapter;
import com.aol.cyclops.internal.react.LazyFutureStreamImpl;
import com.aol.cyclops.internal.react.stream.InfiniteClosingSpliteratorFromSupplier;
import com.aol.cyclops.internal.react.stream.ReactBuilder;
import com.aol.cyclops.react.RetryBuilder;
import com.aol.cyclops.react.ThreadPools;
import com.aol.cyclops.react.async.subscription.Subscription;
import com.aol.cyclops.react.collectors.lazy.MaxActive;
import com.aol.cyclops.types.futurestream.LazyFutureStream;
import com.aol.cyclops.types.stream.reactive.SeqSubscriber;
import com.aol.cyclops.util.function.Cacheable;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryExecutor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyReact
implements ReactBuilder {
    private static final Logger log = LoggerFactory.getLogger(LazyReact.class);
    private final Executor executor;
    private final RetryExecutor retrier;
    private final Boolean async;
    private final MaxActive maxActive;
    private final boolean streamOfFutures;
    private final boolean poolingActive;
    private final boolean autoOptimize;
    private final boolean autoMemoize;
    private final Cacheable memoizeCache;
    private static final Object NONE = new Object();

    public LazyReact autoMemoizeOn(Cacheable memoizeCache) {
        return this.withAutoMemoize(true).withMemoizeCache(memoizeCache);
    }

    public boolean isAsync() {
        return this.async;
    }

    public LazyReact() {
        this(ThreadPools.getStandard());
    }

    public LazyReact(Executor executor) {
        this.executor = executor;
        this.retrier = null;
        this.async = true;
        this.maxActive = MaxActive.IO;
        this.streamOfFutures = false;
        this.poolingActive = false;
        this.autoOptimize = true;
        this.autoMemoize = false;
        this.memoizeCache = null;
    }

    public LazyReact(int maxActive, Executor executor) {
        this.executor = executor;
        this.retrier = null;
        this.async = true;
        this.maxActive = MaxActive.IO;
        this.streamOfFutures = false;
        this.poolingActive = false;
        this.autoOptimize = true;
        this.autoMemoize = false;
        this.memoizeCache = null;
    }

    public LazyReact(int threadPoolSize, int maxActiveTasks) {
        this.executor = Executors.newFixedThreadPool(threadPoolSize);
        this.retrier = new RetryBuilder().parallelism(threadPoolSize);
        this.async = true;
        this.maxActive = new MaxActive(maxActiveTasks, threadPoolSize);
        this.streamOfFutures = false;
        this.poolingActive = false;
        this.autoOptimize = true;
        this.autoMemoize = false;
        this.memoizeCache = null;
    }

    public <U> LazyFutureStream<U> from(CompletableFuture<U> cf) {
        return this.constructFutures(Stream.of(cf));
    }

    public <U> LazyFutureStream<U> from(CompletableFuture<U> ... cf) {
        return this.constructFutures(Stream.of(cf));
    }

    public <U> LazyFutureStream<U> construct(Stream<U> s) {
        log.debug("Constructing Stream with {}", (Object)this);
        return new LazyFutureStreamImpl<U>(this, s);
    }

    public <U> LazyFutureStream<U> constructFutures(Stream<CompletableFuture<U>> s) {
        LazyReact toUse = this.withStreamOfFutures(true);
        log.debug("Constructing Stream with {}", (Object)toUse);
        return toUse.construct(s);
    }

    public LazyReact objectPoolingOn() {
        return this.withPoolingActive(true);
    }

    public LazyReact objectPoolingOff() {
        return this.withPoolingActive(false);
    }

    public LazyReact autoOptimizeOn() {
        return this.withAutoOptimize(true);
    }

    public LazyReact autoOptimizeOff() {
        return this.withAutoOptimize(false);
    }

    public LazyReact async() {
        return this.withAsync(true);
    }

    public LazyReact sync() {
        return this.withAsync(false);
    }

    public <T> LazyFutureStream<T> fromPublisher(Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher);
        SeqSubscriber sub = SeqSubscriber.subscriber();
        publisher.subscribe(sub);
        return sub.toFutureStream(this);
    }

    public LazyFutureStream<Integer> range(int startInclusive, int endExclusive) {
        return this.fromStream(ReactiveSeq.range(startInclusive, endExclusive));
    }

    public <U> LazyFutureStream<U> fromStreamFutures(Stream<CompletableFuture<U>> stream) {
        return this.constructFutures(stream);
    }

    @SafeVarargs
    public final <U> LazyFutureStream<U> ofAsync(Supplier<U> ... actions) {
        return this.reactI(actions);
    }

    public <U> LazyFutureStream<U> fromStream(Stream<U> stream) {
        return this.construct(stream);
    }

    public <U> LazyFutureStream<U> react(Collection<Supplier<U>> actions) {
        ReactiveSeq<Supplier<Object>> seq = actions instanceof List ? ReactiveSeq.fromList((List)actions) : ReactiveSeq.fromIterable(actions);
        return this.fromStreamAsync(seq);
    }

    @SafeVarargs
    private final <U> LazyFutureStream<U> reactI(Supplier<U> ... actions) {
        return this.constructFutures(Stream.of(actions).map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public LazyReact(Executor executor, RetryExecutor retrier, Boolean async, MaxActive maxActive, boolean streamOfFutures, boolean objectPoolingActive, boolean autoOptimize, boolean autoMemoize, Cacheable memoizeCache) {
        this.executor = executor;
        this.retrier = retrier;
        this.async = Optional.ofNullable(async).orElse(true);
        this.maxActive = Optional.ofNullable(maxActive).orElse(MaxActive.IO);
        this.streamOfFutures = streamOfFutures;
        this.poolingActive = objectPoolingActive;
        this.autoOptimize = autoOptimize;
        this.autoMemoize = autoMemoize;
        this.memoizeCache = memoizeCache;
    }

    public LazyReact(Executor currentThreadExecutor, AsyncRetryExecutor withScheduler, boolean async, MaxActive maxActive2) {
        this(currentThreadExecutor, (RetryExecutor)withScheduler, async, maxActive2, false, false, async, false, null);
    }

    public <U> LazyFutureStream<U> fromIterable(Iterable<U> iter) {
        ReactiveSeq<Object> seq = iter instanceof List ? ReactiveSeq.fromList((List)iter) : ReactiveSeq.fromIterable(iter);
        return this.fromStream(seq);
    }

    public <U> LazyFutureStream<U> fromStreamAsync(Stream<Supplier<U>> actions) {
        return this.constructFutures(actions.map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public <U> LazyFutureStream<U> fromIteratorAsync(Iterator<Supplier<U>> actions) {
        return this.constructFutures(StreamSupport.stream(Spliterators.spliteratorUnknownSize(actions, 16), false).map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public <U> LazyFutureStream<U> fromIterableAsync(Iterable<Supplier<U>> actions) {
        ReactiveSeq<Supplier<Object>> seq = actions instanceof List ? ReactiveSeq.fromList((List)actions) : ReactiveSeq.fromIterable(actions);
        return this.constructFutures(seq.map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public static LazyReact parallelBuilder() {
        return new LazyReact();
    }

    public static LazyReact parallelBuilder(int parallelism) {
        return LazyReact.builder().executor(Executors.newFixedThreadPool(parallelism)).retrier((RetryExecutor)new RetryBuilder().parallelism(parallelism)).build();
    }

    public static LazyReact parallelCommonBuilder() {
        return LazyReact.builder().executor(ThreadPools.getStandard()).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getCommonFreeThreadRetry())).build();
    }

    public static LazyReact sequentialBuilder() {
        return LazyReact.builder().maxActive(MaxActive.CPU).async(false).executor(Executors.newFixedThreadPool(1)).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(Executors.newScheduledThreadPool(2))).build();
    }

    public static LazyReact sequentialCommonBuilder() {
        return LazyReact.builder().async(false).executor(ThreadPools.getCommonFreeThread()).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getCommonFreeThreadRetry())).build();
    }

    public static LazyReact sequentialCurrentBuilder() {
        return LazyReact.builder().async(false).executor(ThreadPools.getCurrentThreadExecutor()).retrier((RetryExecutor)RetryBuilder.getDefaultInstance().withScheduler(ThreadPools.getCommonFreeThreadRetry())).build();
    }

    public <U> LazyFutureStream<U> iterate(final U seed, final UnaryOperator<U> f) {
        Subscription sub = new Subscription();
        Supplier supplier = new Supplier<U>(){
            U t = LazyReact.access$000();

            @Override
            public U get() {
                this.t = this.t == NONE ? seed : f.apply(this.t);
                return this.t;
            }
        };
        return this.construct(StreamSupport.stream(new InfiniteClosingSpliteratorFromSupplier(Long.MAX_VALUE, supplier, sub), false));
    }

    public <U> LazyFutureStream<U> fromAdapter(Adapter<U> adapter) {
        Subscription sub = new Subscription();
        return this.construct(adapter.stream(sub));
    }

    public <U> LazyFutureStream<U> generate(Supplier<U> generate) {
        return this.construct(StreamSupport.stream(new InfiniteClosingSpliteratorFromSupplier<U>(Long.MAX_VALUE, generate, new Subscription()), false));
    }

    public <U> LazyFutureStream<U> generateAsync(Supplier<U> s) {
        return this.constructFutures(ReactiveSeq.generate(() -> 1).map(n -> CompletableFuture.supplyAsync(s, this.getExecutor())));
    }

    public <U> LazyFutureStream<U> from(Iterator<U> iterator) {
        return this.fromStream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    public <R> LazyFutureStream<R> from(Collection<R> collection) {
        return this.fromStream(collection.stream());
    }

    public LazyFutureStream<Integer> from(IntStream stream) {
        return this.fromStream(stream.boxed());
    }

    public LazyFutureStream<Double> from(DoubleStream stream) {
        return this.fromStream(stream.boxed());
    }

    public LazyFutureStream<Long> from(LongStream stream) {
        return this.fromStream(stream.boxed());
    }

    @SafeVarargs
    public final <U> LazyFutureStream<U> of(U ... array) {
        return this.fromStream(Stream.of(array));
    }

    public static LazyReactBuilder builder() {
        return new LazyReactBuilder();
    }

    public LazyReact withExecutor(Executor executor) {
        return this.executor == executor ? this : new LazyReact(executor, this.retrier, this.async, this.maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withRetrier(RetryExecutor retrier) {
        return this.retrier == retrier ? this : new LazyReact(this.executor, retrier, this.async, this.maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withAsync(Boolean async) {
        return this.async == async ? this : new LazyReact(this.executor, this.retrier, async, this.maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withMaxActive(MaxActive maxActive) {
        return this.maxActive == maxActive ? this : new LazyReact(this.executor, this.retrier, this.async, maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withStreamOfFutures(boolean streamOfFutures) {
        return this.streamOfFutures == streamOfFutures ? this : new LazyReact(this.executor, this.retrier, this.async, this.maxActive, streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withPoolingActive(boolean poolingActive) {
        return this.poolingActive == poolingActive ? this : new LazyReact(this.executor, this.retrier, this.async, this.maxActive, this.streamOfFutures, poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withAutoOptimize(boolean autoOptimize) {
        return this.autoOptimize == autoOptimize ? this : new LazyReact(this.executor, this.retrier, this.async, this.maxActive, this.streamOfFutures, this.poolingActive, autoOptimize, this.autoMemoize, this.memoizeCache);
    }

    public LazyReact withAutoMemoize(boolean autoMemoize) {
        return this.autoMemoize == autoMemoize ? this : new LazyReact(this.executor, this.retrier, this.async, this.maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, autoMemoize, this.memoizeCache);
    }

    public LazyReact withMemoizeCache(Cacheable memoizeCache) {
        return this.memoizeCache == memoizeCache ? this : new LazyReact(this.executor, this.retrier, this.async, this.maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, memoizeCache);
    }

    public String toString() {
        return "LazyReact(executor=" + this.getExecutor() + ", retrier=" + this.getRetrier() + ", async=" + this.async + ", maxActive=" + this.getMaxActive() + ", streamOfFutures=" + this.isStreamOfFutures() + ", poolingActive=" + this.isPoolingActive() + ", autoOptimize=" + this.isAutoOptimize() + ", autoMemoize=" + this.isAutoMemoize() + ", memoizeCache=" + this.getMemoizeCache() + ")";
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public RetryExecutor getRetrier() {
        return this.retrier;
    }

    public MaxActive getMaxActive() {
        return this.maxActive;
    }

    public boolean isStreamOfFutures() {
        return this.streamOfFutures;
    }

    public boolean isPoolingActive() {
        return this.poolingActive;
    }

    public boolean isAutoOptimize() {
        return this.autoOptimize;
    }

    public boolean isAutoMemoize() {
        return this.autoMemoize;
    }

    public Cacheable getMemoizeCache() {
        return this.memoizeCache;
    }

    public static class LazyReactBuilder {
        private Executor executor;
        private RetryExecutor retrier;
        private Boolean async;
        private MaxActive maxActive;
        private boolean streamOfFutures;
        private boolean poolingActive;
        private boolean autoOptimize;
        private boolean autoMemoize;
        private Cacheable memoizeCache;

        LazyReactBuilder() {
        }

        public LazyReactBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public LazyReactBuilder retrier(RetryExecutor retrier) {
            this.retrier = retrier;
            return this;
        }

        public LazyReactBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public LazyReactBuilder maxActive(MaxActive maxActive) {
            this.maxActive = maxActive;
            return this;
        }

        public LazyReactBuilder streamOfFutures(boolean streamOfFutures) {
            this.streamOfFutures = streamOfFutures;
            return this;
        }

        public LazyReactBuilder poolingActive(boolean poolingActive) {
            this.poolingActive = poolingActive;
            return this;
        }

        public LazyReactBuilder autoOptimize(boolean autoOptimize) {
            this.autoOptimize = autoOptimize;
            return this;
        }

        public LazyReactBuilder autoMemoize(boolean autoMemoize) {
            this.autoMemoize = autoMemoize;
            return this;
        }

        public LazyReactBuilder memoizeCache(Cacheable memoizeCache) {
            this.memoizeCache = memoizeCache;
            return this;
        }

        public LazyReact build() {
            return new LazyReact(this.executor, this.retrier, this.async, this.maxActive, this.streamOfFutures, this.poolingActive, this.autoOptimize, this.autoMemoize, this.memoizeCache);
        }

        public String toString() {
            return "LazyReact.LazyReactBuilder(executor=" + this.executor + ", retrier=" + this.retrier + ", async=" + this.async + ", maxActive=" + this.maxActive + ", streamOfFutures=" + this.streamOfFutures + ", poolingActive=" + this.poolingActive + ", autoOptimize=" + this.autoOptimize + ", autoMemoize=" + this.autoMemoize + ", memoizeCache=" + this.memoizeCache + ")";
        }
    }
}

