/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Semigroup;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Convertable;
import com.aol.cyclops.types.ConvertableFunctor;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.FlatMap;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.MonadicValue1;
import com.aol.cyclops.types.Value;
import com.aol.cyclops.types.applicative.ApplicativeFunctor;
import com.aol.cyclops.types.stream.reactive.ValueSubscriber;
import com.aol.cyclops.util.ExceptionSoftener;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public class FutureW<T>
implements ConvertableFunctor<T>,
ApplicativeFunctor<T>,
MonadicValue1<T>,
FlatMap<T>,
Filterable<T> {
    private final CompletableFuture<T> future;

    public static <T> FutureW<T> empty() {
        return new FutureW<Object>(CompletableFuture.completedFuture(null));
    }

    public static <T> FutureW<T> fromPublisher(Publisher<T> pub, Executor ex) {
        ValueSubscriber sub = ValueSubscriber.subscriber();
        pub.subscribe(sub);
        return sub.toFutureWAsync(ex);
    }

    public static <T> FutureW<T> fromIterable(Iterable<T> iterable, Executor ex) {
        return FutureW.ofSupplier(() -> Eval.fromIterable(iterable)).map((T e) -> e.get());
    }

    public static <T> FutureW<T> fromPublisher(Publisher<T> pub) {
        ValueSubscriber sub = ValueSubscriber.subscriber();
        pub.subscribe(sub);
        return sub.toFutureW();
    }

    public static <T> FutureW<T> fromIterable(Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        return FutureW.ofResult(Eval.fromIterable(iterable)).map((T e) -> e.get());
    }

    public static <T> FutureW<T> of(CompletableFuture<T> f) {
        return new FutureW<T>(f);
    }

    public static <T, X extends Throwable> FutureW<T> fromTry(Try<T, X> value, Executor ex) {
        return FutureW.ofSupplier(value, ex);
    }

    public static <T> FutureW<T> schedule(String cron, ScheduledExecutorService ex, Supplier<T> t) {
        CompletableFuture future = new CompletableFuture();
        FutureW wrapped = FutureW.of(future);
        ReactiveSeq.generate(() -> {
            try {
                future.complete(t.get());
            }
            catch (Throwable t1) {
                future.completeExceptionally(t1);
            }
            return 1;
        }).limit(1L).schedule(cron, ex);
        return wrapped;
    }

    public static <T> FutureW<T> schedule(long delay, ScheduledExecutorService ex, Supplier<T> t) {
        CompletableFuture future = new CompletableFuture();
        FutureW wrapped = FutureW.of(future);
        ReactiveSeq.generate(() -> {
            try {
                future.complete(t.get());
            }
            catch (Throwable t1) {
                future.completeExceptionally(t1);
            }
            return 1;
        }).limit(1L).scheduleFixedDelay(delay, ex);
        return wrapped;
    }

    public static <T> FutureW<ListX<T>> sequence(CollectionX<FutureW<T>> fts) {
        return FutureW.sequence(fts.stream()).map((T s) -> s.toListX());
    }

    public static <T> FutureW<ReactiveSeq<T>> sequence(Stream<FutureW<T>> fts) {
        return (FutureW)AnyM.sequence(fts.map((? super T f) -> AnyM.fromFutureW(f)), () -> AnyM.fromFutureW(FutureW.ofResult(Stream.empty()))).map((T s) -> ReactiveSeq.fromStream(s)).unwrap();
    }

    public static <T, R> FutureW<R> accumulateSuccess(CollectionX<FutureW<T>> fts, Reducer<R> reducer) {
        FutureW sequenced = (FutureW)AnyM.sequence(fts.map((T f) -> AnyM.fromFutureW(f))).unwrap();
        return sequenced.map((T s) -> s.mapReduce(reducer));
    }

    public static <T, R> FutureW<R> accumulate(CollectionX<FutureW<T>> fts, Reducer<R> reducer) {
        return FutureW.sequence(fts).map((T s) -> s.mapReduce(reducer));
    }

    public static <T, R> FutureW<R> accumulate(CollectionX<FutureW<T>> fts, Function<? super T, R> mapper, Semigroup<R> reducer) {
        return FutureW.sequence(fts).map((T s) -> s.map(mapper).reduce(reducer.reducer()).get());
    }

    public static <T> FutureW<T> accumulate(CollectionX<FutureW<T>> fts, Semigroup<T> reducer) {
        return FutureW.sequence(fts).map((T s) -> s.reduce(reducer.reducer()).get());
    }

    public <R> Eval<R> matches(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> secondary, Function<Matchable.CheckValue1<Throwable, R>, Matchable.CheckValue1<Throwable, R>> primary, Supplier<? extends R> otherwise) {
        return this.toXor().swap().matches(secondary, primary, otherwise);
    }

    @Override
    public <R> FutureW<R> coflatMap(Function<? super MonadicValue<T>, R> mapper) {
        return (FutureW)MonadicValue1.super.coflatMap(mapper);
    }

    @Override
    public FutureW<MonadicValue<T>> nest() {
        return (FutureW)MonadicValue1.super.nest();
    }

    @Override
    public FutureW<T> combine(Monoid<T> monoid, MonadicValue<? extends T> v2) {
        return (FutureW)MonadicValue1.super.combine(monoid, v2);
    }

    @Override
    public <R> FutureW<R> map(Function<? super T, ? extends R> fn) {
        return new FutureW<T>(this.future.thenApply(fn));
    }

    @Override
    public <R> FutureW<R> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (FutureW)ApplicativeFunctor.super.patternMatch(case1, otherwise);
    }

    @Override
    public T get() {
        try {
            return this.future.join();
        }
        catch (Throwable t) {
            throw ExceptionSoftener.throwSoftenedException(t.getCause());
        }
    }

    public boolean isSuccess() {
        return this.future.isDone() && !this.future.isCompletedExceptionally();
    }

    public boolean isFailed() {
        return this.future.isCompletedExceptionally();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toStream().iterator();
    }

    @Override
    public <T> FutureW<T> unit(T unit) {
        return new FutureW<T>(CompletableFuture.completedFuture(unit));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return ReactiveSeq.generate(() -> Try.withCatch(() -> this.get(), new Class[0])).limit(1L).filter((T t) -> t.isSuccess()).map(Convertable::get);
    }

    @Override
    public <R> FutureW<R> flatten() {
        return FutureW.of((CompletableFuture)AnyM.fromCompletableFuture(this.future).flatten().unwrap());
    }

    @Override
    public <R> FutureW<R> flatMap(Function<? super T, ? extends MonadicValue<? extends R>> mapper) {
        return FutureW.of(this.future.thenCompose(t -> ((MonadicValue)mapper.apply(t)).toFutureW().getFuture()));
    }

    public <R> FutureW<R> flatMapCf(Function<? super T, ? extends CompletionStage<? extends R>> mapper) {
        return FutureW.of(this.future.thenCompose(t -> (CompletionStage)mapper.apply(t)));
    }

    @Override
    public Xor<Throwable, T> toXor() {
        try {
            return Xor.primary(this.future.join());
        }
        catch (Throwable t) {
            return Xor.secondary(t.getCause());
        }
    }

    @Override
    public Ior<Throwable, T> toIor() {
        try {
            return Ior.primary(this.future.join());
        }
        catch (Throwable t) {
            return Ior.secondary(t.getCause());
        }
    }

    @Override
    public FutureW<T> toFutureW() {
        return this;
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.future;
    }

    @Override
    public CompletableFuture<T> toCompletableFutureAsync() {
        return this.future;
    }

    @Override
    public CompletableFuture<T> toCompletableFutureAsync(Executor exec) {
        return this.future;
    }

    public <R> FutureW<R> visit(Function<? super T, R> success, Function<Throwable, R> failure) {
        return FutureW.of(((CompletableFuture)this.future.thenApply(success)).exceptionally(failure));
    }

    @Override
    public <U> FutureW<U> cast(Class<? extends U> type) {
        return (FutureW)ApplicativeFunctor.super.cast(type);
    }

    @Override
    public FutureW<T> peek(Consumer<? super T> c) {
        return (FutureW)ApplicativeFunctor.super.peek(c);
    }

    @Override
    public <R> FutureW<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (FutureW)ApplicativeFunctor.super.trampoline(mapper);
    }

    public String toString() {
        return this.mkString();
    }

    public static <T> FutureW<T> ofResult(T result) {
        return FutureW.of(CompletableFuture.completedFuture(result));
    }

    public static <T> FutureW<T> ofError(Throwable error) {
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(error);
        return FutureW.of(cf);
    }

    @Override
    public boolean isPresent() {
        return !this.future.isCompletedExceptionally();
    }

    @Override
    public String mkString() {
        return "FutureW[" + this.future.toString() + "]";
    }

    @Override
    public Maybe<T> filter(Predicate<? super T> fn) {
        return this.toMaybe().filter((Predicate)fn);
    }

    @Override
    public <U> Maybe<U> ofType(Class<? extends U> type) {
        return (Maybe)Filterable.super.ofType(type);
    }

    @Override
    public Maybe<T> filterNot(Predicate<? super T> fn) {
        return (Maybe)Filterable.super.filterNot(fn);
    }

    @Override
    public Maybe<T> notNull() {
        return (Maybe)Filterable.super.notNull();
    }

    @Override
    public Optional<T> toOptional() {
        if (this.future.isDone() && this.future.isCompletedExceptionally()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.get());
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    @Override
    public FutureW<T> toFutureWAsync() {
        return this;
    }

    @Override
    public FutureW<T> toFutureWAsync(Executor ex) {
        return this;
    }

    @Override
    public <T2, R> FutureW<R> ap(Value<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        if (app instanceof FutureW) {
            return FutureW.of(this.future.thenCombine(((FutureW)app).getFuture(), fn));
        }
        return (FutureW)ApplicativeFunctor.super.zip(app, fn);
    }

    @Override
    public <T2, R> FutureW<R> zip(Iterable<? extends T2> app, BiFunction<? super T, ? super T2, ? extends R> fn) {
        return (FutureW)ApplicativeFunctor.super.zip(app, fn);
    }

    @Override
    public <T2, R> FutureW<R> zip(BiFunction<? super T, ? super T2, ? extends R> fn, Publisher<? extends T2> app) {
        return (FutureW)ApplicativeFunctor.super.zip(fn, app);
    }

    public static <T> FutureW<T> ofSupplier(Supplier<T> s) {
        return FutureW.of(CompletableFuture.supplyAsync(s));
    }

    public static <T> FutureW<T> ofSupplier(Supplier<T> s, Executor ex) {
        return FutureW.of(CompletableFuture.supplyAsync(s, ex));
    }

    @ConstructorProperties(value={"future"})
    public FutureW(CompletableFuture<T> future) {
        this.future = future;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FutureW)) {
            return false;
        }
        FutureW other = (FutureW)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompletableFuture<T> this$future = this.getFuture();
        CompletableFuture<T> other$future = other.getFuture();
        return !(this$future == null ? other$future != null : !this$future.equals(other$future));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FutureW;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompletableFuture<T> $future = this.getFuture();
        result = result * 59 + ($future == null ? 0 : $future.hashCode());
        return result;
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }
}

