/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops;

import com.aol.cyclops.Monoid;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Reducer<T>
extends Monoid<T> {
    default public Stream<T> mapToType(Stream stream) {
        return stream;
    }

    default public T mapReduce(Stream toReduce) {
        return this.reduce(this.mapToType(toReduce));
    }

    public static <T> Reducer<T> fromMonoid(Monoid<T> monoid, Function<?, ? extends T> mapper) {
        return Reducer.of(monoid.zero(), monoid.combiner(), mapper);
    }

    public static <T> Reducer<T> of(final T zero, final BiFunction<T, T, T> combiner, final Function<?, ? extends T> mapToType) {
        return new Reducer<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return combiner;
            }

            @Override
            public Stream<T> mapToType(Stream stream) {
                return stream.map(mapToType);
            }
        };
    }

    public static <T> Reducer<T> of(final T zero, final Function<T, Function<T, T>> combiner, final Function<?, T> mapToType) {
        return new Reducer<T>(){

            @Override
            public T zero() {
                return zero;
            }

            @Override
            public BiFunction<T, T, T> combiner() {
                return (a, b) -> ((Function)combiner.apply(a)).apply(b);
            }

            @Override
            public Stream<T> mapToType(Stream stream) {
                return stream.map(mapToType);
            }
        };
    }
}

