/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.lazy;

import com.aol.cyclops.control.Eval;
import com.aol.cyclops.types.stream.HasStream;
import com.aol.cyclops.types.stream.lazy.LongOperators;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.ToLongFunction;
import java.util.stream.LongStream;

public interface LongOperatorsMixin<T>
extends LongOperators<T>,
HasStream<T> {
    @Override
    default public Eval<Long> sumLong(ToLongFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).sum());
    }

    @Override
    default public Eval<OptionalLong> maxLong(ToLongFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).max());
    }

    @Override
    default public Eval<OptionalLong> minLong(ToLongFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).min());
    }

    @Override
    default public Eval<OptionalDouble> averageLong(ToLongFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).average());
    }

    @Override
    default public Eval<LongSummaryStatistics> summaryStatisticsLong(ToLongFunction<? super T> fn) {
        return Eval.later(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).summaryStatistics());
    }
}

