/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.future;

import com.aol.cyclops.types.stream.HasExec;
import com.aol.cyclops.types.stream.HasStream;
import com.aol.cyclops.types.stream.future.IntOperators;
import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public interface IntOperatorsMixin<T>
extends IntOperators<T>,
HasStream<T>,
HasExec {
    @Override
    default public CompletableFuture<Integer> sumInt(ToIntFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).sum(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalInt> maxInt(ToIntFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).max(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalInt> minInt(ToIntFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).min(), this.getExec());
    }

    @Override
    default public CompletableFuture<OptionalDouble> averageInt(ToIntFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).average(), this.getExec());
    }

    @Override
    default public CompletableFuture<IntSummaryStatistics> summaryStatisticsInt(ToIntFunction<? super T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToInt(t -> IntStream.of(fn.applyAsInt(t))).summaryStatistics(), this.getExec());
    }
}

