/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.control.SimpleReact;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.exceptions.SimpleReactProcessingException;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.internal.react.stream.MissingValue;
import com.aol.cyclops.internal.react.stream.Runner;
import com.aol.cyclops.react.collectors.lazy.EmptyCollector;
import com.aol.cyclops.react.collectors.lazy.IncrementalReducer;
import com.aol.cyclops.react.collectors.lazy.LazyResultConsumer;
import com.aol.cyclops.react.collectors.lazy.MaxActive;
import com.aol.cyclops.react.threads.SequentialElasticPools;
import com.aol.cyclops.types.futurestream.BlockingStream;
import com.aol.cyclops.types.futurestream.BlockingStreamHelper;
import com.aol.cyclops.types.futurestream.Continuation;
import com.aol.cyclops.types.futurestream.NonCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface LazyStream<U>
extends BlockingStream<U> {
    @Override
    public LazyStreamWrapper<U> getLastActive();

    public Supplier<LazyResultConsumer<U>> getLazyCollector();

    @Override
    public Optional<Consumer<Throwable>> getErrorHandler();

    public MaxActive getMaxActive();

    public Iterator<U> iterator();

    default public void run() {
        SimpleReact reactor = SequentialElasticPools.simpleReact.nextReactor();
        reactor.ofAsync(() -> this.run(new NonCollector())).peek(n -> SequentialElasticPools.simpleReact.populate(reactor)).onFail(n -> {
            SequentialElasticPools.simpleReact.populate(reactor);
            return 1;
        });
    }

    default public void runThread(Runnable r) {
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        new Thread(() -> new Runner(r).run(this.getLastActive(), new EmptyCollector(this.getMaxActive(), safeJoin))).start();
    }

    default public Continuation runContinuation(Runnable r) {
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        return new Runner(r).runContinuations((LazyStreamWrapper)this.getLastActive(), new EmptyCollector<Object>(this.getMaxActive(), safeJoin));
    }

    default public void runOnCurrent() {
        this.run(new NonCollector());
    }

    default public <A, R> R run(Collector<U, A, R> collector) {
        if (((LazyStreamWrapper)this.getLastActive()).isSequential()) {
            if (collector.supplier().get() == null) {
                this.forEach(r -> {});
                return null;
            }
            Object col = collector.supplier().get();
            this.forEach(r -> collector.accumulator().accept(col, r));
            return collector.finisher().apply(col);
        }
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        EmptyCollector<Object> batcher = collector.supplier().get() != null ? this.getLazyCollector().get().withResults(new ArrayList()) : new EmptyCollector<Object>(this.getMaxActive(), safeJoin);
        try {
            ((LazyStreamWrapper)this.getLastActive()).injectFutures().forEach((? super T n) -> batcher.accept(n));
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
            // empty catch block
        }
        if (collector.supplier().get() == null) {
            batcher.block(safeJoin);
            return null;
        }
        return batcher.getAllResults().stream().map(cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler())).filter(v -> v != MissingValue.MISSING_VALUE).collect(collector);
    }

    default public void forEach(Consumer<? super U> c) {
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        if (((LazyStreamWrapper)this.getLastActive()).isSequential()) {
            try {
                ((LazyStreamWrapper)this.getLastActive()).operation(f -> f.peek(c)).injectFutures().forEach((? super T next) -> safeJoin.apply((FastFuture)next));
            }
            catch (SimpleReactProcessingException simpleReactProcessingException) {
                // empty catch block
            }
            return;
        }
        IncrementalReducer collector = new IncrementalReducer(this.getLazyCollector().get().withResults(new ArrayList()), this);
        try {
            ((LazyStreamWrapper)this.getLastActive()).operation(f -> f.peek(c)).injectFutures().forEach((? super T next) -> collector.getConsumer().accept((FastFuture)next));
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
            // empty catch block
        }
        collector.getConsumer().block(safeJoin);
    }

    default public Optional<U> reduce(BinaryOperator<U> accumulator) {
        if (((LazyStreamWrapper)this.getLastActive()).isSequential()) {
            Object[] result = new Object[]{null};
            this.forEach(r -> {
                result[0] = result[0] == null ? r : accumulator.apply(result[0], r);
            });
            return Optional.ofNullable(result[0]);
        }
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        IncrementalReducer collector = new IncrementalReducer(this.getLazyCollector().get().withResults(new ArrayList()), this);
        Optional[] result = new Optional[]{Optional.empty()};
        try {
            ((LazyStreamWrapper)this.getLastActive()).injectFutures().forEach((? super T next) -> {
                collector.getConsumer().accept((FastFuture)next);
                result[0] = !result[0].isPresent() ? collector.reduce(safeJoin, accumulator) : result[0].map(v -> collector.reduce(safeJoin, v, accumulator));
            });
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
            // empty catch block
        }
        if (result[0].isPresent()) {
            return result[0].map(v -> collector.reduceResults(collector.getConsumer().getAllResults(), safeJoin, v, accumulator));
        }
        return collector.reduceResults(collector.getConsumer().getAllResults(), safeJoin, accumulator);
    }

    default public U reduce(U identity, BinaryOperator<U> accumulator) {
        if (((LazyStreamWrapper)this.getLastActive()).isSequential()) {
            Object[] result = new Object[]{identity};
            this.forEach(r -> {
                result[0] = result[0] == null ? r : accumulator.apply(result[0], r);
            });
            return (U)result[0];
        }
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        IncrementalReducer collector = new IncrementalReducer(this.getLazyCollector().get().withResults(new ArrayList()), this);
        Object[] result = new Object[]{identity};
        try {
            ((LazyStreamWrapper)this.getLastActive()).injectFutures().forEach((? super T next) -> {
                collector.getConsumer().accept((FastFuture)next);
                result[0] = collector.reduce(safeJoin, result[0], accumulator);
            });
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
            // empty catch block
        }
        return (U)collector.reduceResults(collector.getConsumer().getAllResults(), safeJoin, result[0], accumulator);
    }

    default public <T> T reduce(T identity, BiFunction<T, ? super U, T> accumulator, BinaryOperator<T> combiner) {
        if (((LazyStreamWrapper)this.getLastActive()).isSequential()) {
            Object[] result = new Object[]{identity};
            this.forEach(r -> {
                result[0] = result[0] == null ? r : accumulator.apply(result[0], r);
            });
            return (T)result[0];
        }
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        IncrementalReducer<Object> collector = new IncrementalReducer<Object>(this.getLazyCollector().get().withResults(new ArrayList()), this);
        Object[] result = new Object[]{identity};
        try {
            ((LazyStreamWrapper)this.getLastActive()).injectFutures().forEach((? super T next) -> {
                collector.getConsumer().accept((FastFuture)next);
                result[0] = collector.reduce(safeJoin, result[0], accumulator, combiner);
            });
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
            // empty catch block
        }
        return (T)collector.reduceResults(collector.getConsumer().getAllResults(), safeJoin, result[0], accumulator, combiner);
    }

    default public <T> T reduce(T identity, BiFunction<T, ? super U, T> accumulator) {
        if (((LazyStreamWrapper)this.getLastActive()).isSequential()) {
            Object[] result = new Object[]{identity};
            this.forEach(r -> {
                result[0] = result[0] == null ? r : accumulator.apply(result[0], r);
            });
            return (T)result[0];
        }
        Function<FastFuture, Object> safeJoin = cf -> BlockingStreamHelper.getSafe(cf, this.getErrorHandler());
        IncrementalReducer<Object> collector = new IncrementalReducer<Object>(this.getLazyCollector().get().withResults(new ArrayList()), this);
        Object[] result = new Object[]{identity};
        try {
            ((LazyStreamWrapper)this.getLastActive()).injectFutures().forEach((? super T next) -> {
                collector.getConsumer().accept((FastFuture)next);
                result[0] = collector.reduce(safeJoin, result[0], accumulator);
            });
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
            // empty catch block
        }
        return (T)collector.reduceResults(collector.getConsumer().getAllResults(), safeJoin, result[0], accumulator);
    }

    default public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super U> accumulator, BiConsumer<R, R> combiner) {
        return this.run(Collector.of(supplier, accumulator, (a, b) -> {
            combiner.accept(a, b);
            return a;
        }, new Collector.Characteristics[0]));
    }
}

