/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.futurestream;

import com.aol.cyclops.CyclopsCollectors;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.internal.react.stream.EagerStreamWrapper;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.types.futurestream.BlockingStreamHelper;
import com.aol.cyclops.util.ThrowsSoftened;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collector;

public interface BlockingStream<U> {
    public Optional<Consumer<Throwable>> getErrorHandler();

    @ThrowsSoftened(value={InterruptedException.class, ExecutionException.class})
    default public ListX<U> block() {
        Object lastActive = this.getLastActive();
        if (lastActive instanceof EagerStreamWrapper) {
            EagerStreamWrapper last = (EagerStreamWrapper)lastActive;
            return (ListX)BlockingStreamHelper.block(this, CyclopsCollectors.toListX(), last);
        }
        LazyStreamWrapper last = (LazyStreamWrapper)lastActive;
        return (ListX)BlockingStreamHelper.block(this, CyclopsCollectors.toListX(), last);
    }

    public Object getLastActive();

    @ThrowsSoftened(value={InterruptedException.class, ExecutionException.class})
    default public <R, A> R block(Collector<? super U, A, R> collector) {
        Object lastActive = this.getLastActive();
        if (lastActive instanceof EagerStreamWrapper) {
            EagerStreamWrapper last = (EagerStreamWrapper)lastActive;
            return BlockingStreamHelper.block(this, collector, last);
        }
        LazyStreamWrapper last = (LazyStreamWrapper)lastActive;
        return BlockingStreamHelper.block(this, collector, last);
    }
}

