/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.stream.future.FutureOperations;
import com.aol.cyclops.types.stream.lazy.LazyOperations;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface Traversable<T>
extends Iterable<T>,
Publisher<T> {
    default public ReactiveSeq<T> stream() {
        return ReactiveSeq.fromIterable(this);
    }

    default public void subscribe(Subscriber<? super T> s) {
        this.traversable().subscribe(s);
    }

    default public Traversable<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return this.traversable().combine(predicate, op);
    }

    default public Traversable<T> cycle(int times) {
        return this.traversable().cycle(times);
    }

    default public Traversable<T> cycle(Monoid<T> m, int times) {
        return this.traversable().cycle(m, times);
    }

    default public Traversable<T> cycleWhile(Predicate<? super T> predicate) {
        return this.traversable().cycleWhile(predicate);
    }

    default public Traversable<T> cycleUntil(Predicate<? super T> predicate) {
        return this.traversable().cycleUntil(predicate);
    }

    default public <U, R> Traversable<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return this.traversable().zip(other, zipper);
    }

    default public <U> Traversable<Tuple2<T, U>> zipStream(Stream<? extends U> other) {
        return this.traversable().zipStream(other);
    }

    default public <U> Traversable<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return this.traversable().zip(other);
    }

    default public <S, U> Traversable<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return this.traversable().zip3(second, third);
    }

    default public <T2, T3, T4> Traversable<Tuple4<T, T2, T3, T4>> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return this.traversable().zip4(second, third, fourth);
    }

    default public Traversable<Tuple2<T, Long>> zipWithIndex() {
        return this.traversable().zipWithIndex();
    }

    default public Traversable<ListX<T>> sliding(int windowSize) {
        return this.traversable().sliding(windowSize);
    }

    default public Traversable<ListX<T>> sliding(int windowSize, int increment) {
        return this.traversable().sliding(windowSize, increment);
    }

    default public <C extends Collection<? super T>> Traversable<C> grouped(int size, Supplier<C> supplier) {
        return this.traversable().grouped(size, supplier);
    }

    default public Traversable<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return this.traversable().groupedUntil(predicate);
    }

    default public Traversable<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return this.traversable().groupedStatefullyWhile(predicate);
    }

    default public Traversable<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return this.traversable().groupedWhile(predicate);
    }

    default public <C extends Collection<? super T>> Traversable<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return this.traversable().groupedWhile(predicate, factory2);
    }

    default public <C extends Collection<? super T>> Traversable<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return this.traversable().groupedUntil(predicate, factory2);
    }

    default public Traversable<ListX<T>> grouped(int groupSize) {
        return this.traversable().grouped(groupSize);
    }

    default public <K, A, D> Traversable<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.traversable().grouped(classifier, downstream);
    }

    default public <K> Traversable<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return this.traversable().grouped(classifier);
    }

    default public Traversable<T> distinct() {
        return this.traversable().distinct();
    }

    default public Traversable<T> scanLeft(Monoid<T> monoid) {
        return this.traversable().scanLeft(monoid);
    }

    default public <U> Traversable<U> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return this.traversable().scanLeft(seed, function);
    }

    default public Traversable<T> scanRight(Monoid<T> monoid) {
        return this.traversable().scanRight(monoid);
    }

    default public <U> Traversable<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return this.traversable().scanRight(identity, combiner);
    }

    default public Traversable<T> sorted() {
        return this.traversable().sorted();
    }

    default public Traversable<T> sorted(Comparator<? super T> c) {
        return this.traversable().sorted(c);
    }

    default public Traversable<T> takeWhile(Predicate<? super T> p) {
        return this.limitWhile(p);
    }

    default public Traversable<T> dropWhile(Predicate<? super T> p) {
        return this.skipWhile(p);
    }

    default public Traversable<T> takeUntil(Predicate<? super T> p) {
        return this.limitUntil(p);
    }

    default public Traversable<T> dropUntil(Predicate<? super T> p) {
        return this.skipUntil(p);
    }

    default public Traversable<T> dropRight(int num) {
        return this.skipLast(num);
    }

    default public Traversable<T> takeRight(int num) {
        return this.limitLast(num);
    }

    default public Traversable<T> skip(long num) {
        return this.traversable().skip(num);
    }

    default public Traversable<T> skipWhile(Predicate<? super T> p) {
        return this.traversable().skipWhile(p);
    }

    default public Traversable<T> skipUntil(Predicate<? super T> p) {
        return this.traversable().skipUntil(p);
    }

    default public Traversable<T> limit(long num) {
        return this.traversable().limit(num);
    }

    default public Traversable<T> limitWhile(Predicate<? super T> p) {
        return this.traversable().limitWhile(p);
    }

    default public Traversable<T> limitUntil(Predicate<? super T> p) {
        return this.traversable().limitUntil(p);
    }

    default public Traversable<T> intersperse(T value) {
        return this.traversable().intersperse(value);
    }

    default public Traversable<T> reverse() {
        return this.traversable().reverse();
    }

    default public Traversable<T> shuffle() {
        return this.traversable().shuffle();
    }

    default public FutureOperations<T> futureOperations(Executor exec) {
        return this.traversable().futureOperations(exec);
    }

    default public LazyOperations<T> lazyOperations() {
        return new LazyOperations<T>(ReactiveSeq.fromIterable(this.traversable()));
    }

    default public Traversable<T> skipLast(int num) {
        return this.traversable().skipLast(num);
    }

    default public Traversable<T> limitLast(int num) {
        return this.traversable().limitLast(num);
    }

    default public Traversable<T> onEmpty(T value) {
        return this.traversable().onEmpty(value);
    }

    default public Traversable<T> onEmptyGet(Supplier<? extends T> supplier) {
        return this.traversable().onEmptyGet(supplier);
    }

    default public <X extends Throwable> Traversable<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return this.traversable().onEmptyThrow(supplier);
    }

    default public Traversable<T> shuffle(Random random) {
        return this.traversable().shuffle(random);
    }

    default public Traversable<T> slice(long from, long to) {
        return this.traversable().slice(from, to);
    }

    default public <U extends Comparable<? super U>> Traversable<T> sorted(Function<? super T, ? extends U> function) {
        return this.traversable().sorted(function);
    }

    default public Traversable<T> traversable() {
        return this.stream();
    }
}

