/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface IterableFilterable<T>
extends Filterable<T> {
    default public Filterable<T> removeAll(Stream<? extends T> stream) {
        Set set = stream.collect(Collectors.toSet());
        return this.filterNot(i -> set.contains(i));
    }

    default public Filterable<T> removeAll(Iterable<? extends T> it) {
        return this.removeAll(StreamUtils.stream(it));
    }

    default public Filterable<T> removeAll(T ... values) {
        return this.removeAll(Stream.of(values));
    }

    default public Filterable<T> retainAll(Iterable<? extends T> it) {
        return this.retainAll(StreamUtils.stream(it));
    }

    default public Filterable<T> retainAll(Stream<? extends T> stream) {
        Set set = stream.collect(Collectors.toSet());
        return this.filter(i -> set.contains(i));
    }

    default public Filterable<T> retainAll(T ... values) {
        return this.retainAll(Stream.of(values));
    }
}

