/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types;

import com.aol.cyclops.control.Trampoline;
import java.util.function.Consumer;
import java.util.function.Function;

public interface BiFunctor<T1, T2> {
    public <R1, R2> BiFunctor<R1, R2> bimap(Function<? super T1, ? extends R1> var1, Function<? super T2, ? extends R2> var2);

    default public BiFunctor<T1, T2> bipeek(Consumer<? super T1> c1, Consumer<? super T2> c2) {
        return this.bimap(input -> {
            c1.accept((Object)input);
            return input;
        }, input -> {
            c2.accept((Object)input);
            return input;
        });
    }

    default public <U1, U2> BiFunctor<U1, U2> bicast(Class<U1> type1, Class<U2> type2) {
        return this.bimap(type1::cast, type2::cast);
    }

    default public <R1, R2> BiFunctor<R1, R2> bitrampoline(Function<? super T1, ? extends Trampoline<? extends R1>> mapper1, Function<? super T2, ? extends Trampoline<? extends R2>> mapper2) {
        return this.bimap(in -> ((Trampoline)mapper1.apply((Object)in)).result(), in -> ((Trampoline)mapper2.apply((Object)in)).result());
    }
}

