/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react.collectors.lazy;

import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.stream.MissingValue;
import com.aol.cyclops.react.collectors.lazy.LazyResultConsumer;
import com.aol.cyclops.types.futurestream.BlockingStream;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;

public class IncrementalReducer<T> {
    private final LazyResultConsumer<T> consumer;
    private final BlockingStream<T> blocking;

    public void forEach(Consumer<? super T> c, Function<FastFuture, T> safeJoin) {
        this.forEachResults(this.consumer.getResults(), c, safeJoin);
    }

    public void forEachResults(Collection<FastFuture<T>> results, Consumer<? super T> c, Function<FastFuture, T> safeJoin) {
        Stream<FastFuture<FastFuture>> streamToUse = results.stream();
        streamToUse.map(safeJoin).filter(v -> v != MissingValue.MISSING_VALUE).forEach(c);
        this.consumer.getResults().clear();
    }

    public T reduce(Function<FastFuture, T> safeJoin, T identity, BinaryOperator<T> accumulator) {
        return this.reduceResults(this.consumer.getResults(), safeJoin, identity, accumulator);
    }

    public T reduceResults(Collection<FastFuture<T>> results, Function<FastFuture, T> safeJoin, T identity, BinaryOperator<T> accumulator) {
        Stream<FastFuture<FastFuture>> streamToUse = results.stream();
        Object result = streamToUse.map(safeJoin).filter(v -> v != MissingValue.MISSING_VALUE).reduce(identity, accumulator);
        this.consumer.getResults().clear();
        return (T)result;
    }

    public Optional<T> reduce(Function<FastFuture, T> safeJoin, BinaryOperator<T> accumulator) {
        return this.reduceResults(this.consumer.getResults(), safeJoin, accumulator);
    }

    public Optional<T> reduceResults(Collection<FastFuture<T>> results, Function<FastFuture, T> safeJoin, BinaryOperator<T> accumulator) {
        Stream<FastFuture<FastFuture>> streamToUse = results.stream();
        Optional<Object> result = streamToUse.map(safeJoin).filter(v -> v != MissingValue.MISSING_VALUE).reduce(accumulator);
        this.consumer.getResults().clear();
        return result;
    }

    public <U> U reduce(Function<FastFuture, T> safeJoin, U identity, BiFunction<U, ? super T, U> accumulator) {
        return this.reduceResults(this.consumer.getResults(), safeJoin, identity, accumulator);
    }

    public <U> U reduce(Function<FastFuture, T> safeJoin, U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.reduceResults(this.consumer.getResults(), safeJoin, identity, accumulator, combiner);
    }

    public <U> U reduceResults(Collection<FastFuture<T>> results, Function<FastFuture, T> safeJoin, U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        Stream<FastFuture<FastFuture>> streamToUse = results.stream();
        U result = streamToUse.map(safeJoin).filter(v -> v != MissingValue.MISSING_VALUE).reduce(identity, accumulator, combiner);
        this.consumer.getResults().clear();
        return result;
    }

    public <U> U reduceResults(Collection<FastFuture<T>> results, Function<FastFuture, T> safeJoin, U identity, BiFunction<U, ? super T, U> accumulator) {
        Stream<FastFuture<T>> streamToUse = results.stream();
        Object result = Seq.seq(streamToUse).map(safeJoin).filter(v -> v != MissingValue.MISSING_VALUE).foldLeft(identity, accumulator);
        this.consumer.getResults().clear();
        return (U)result;
    }

    public LazyResultConsumer<T> getConsumer() {
        return this.consumer;
    }

    public BlockingStream<T> getBlocking() {
        return this.blocking;
    }

    @ConstructorProperties(value={"consumer", "blocking"})
    public IncrementalReducer(LazyResultConsumer<T> consumer, BlockingStream<T> blocking) {
        this.consumer = consumer;
        this.blocking = blocking;
    }
}

