/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.react;

import com.aol.cyclops.types.futurestream.ConfigurableStream;
import com.aol.cyclops.util.ExceptionSoftener;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageWithResults<RS, U> {
    private static final Logger log = LoggerFactory.getLogger(StageWithResults.class);
    private final Executor taskExecutor;
    private final ConfigurableStream<U, Object> stage;
    private final RS results;

    public StageWithResults(ConfigurableStream<U, Object> stage, RS results) {
        this.taskExecutor = stage.getTaskExecutor();
        this.stage = stage;
        this.results = results;
    }

    public <R> R submit(Function<RS, R> fn) {
        return (R)this.submit(() -> fn.apply(this.results));
    }

    public <T> T submit(Callable<T> callable) {
        if (this.taskExecutor instanceof ForkJoinPool) {
            log.debug("Submited callable to SimpleReact ForkJoinPool. JDK ParallelStreams will reuse SimpleReact ForkJoinPool.");
            try {
                return (T)((ForkJoinTask)((ForkJoinPool)this.taskExecutor).submit((Callable)callable)).get();
            }
            catch (ExecutionException e) {
                throw ExceptionSoftener.throwSoftenedException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ExceptionSoftener.throwSoftenedException(e);
            }
        }
        try {
            log.debug("Submited callable but do not have a ForkJoinPool. JDK ParallelStreams will use Common ForkJoinPool not SimpleReact Executor.");
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ConstructorProperties(value={"taskExecutor", "stage", "results"})
    public StageWithResults(Executor taskExecutor, ConfigurableStream<U, Object> stage, RS results) {
        this.taskExecutor = taskExecutor;
        this.stage = stage;
        this.results = results;
    }

    public RS getResults() {
        return this.results;
    }
}

