/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.stream.operators;

import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.cyclops.util.stream.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;

public class RecoverOperator<T> {
    private final Stream<T> stream;
    private final Class<Throwable> type;
    private static final Object UNSET = new Object();

    public Stream<T> recover(final Function<Throwable, ? extends T> fn) {
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){
            T result = RecoverOperator.access$000();

            @Override
            public boolean hasNext() {
                try {
                    return it.hasNext();
                }
                catch (Throwable t) {
                    if (RecoverOperator.this.type.isAssignableFrom(t.getClass())) {
                        this.result = fn.apply(t);
                        return true;
                    }
                    ExceptionSoftener.throwSoftenedException(t);
                    return false;
                }
            }

            @Override
            public T next() {
                if (this.result != UNSET) {
                    Object toReturn = this.result;
                    this.result = UNSET;
                    return toReturn;
                }
                return it.next();
            }
        });
    }

    @ConstructorProperties(value={"stream", "type"})
    public RecoverOperator(Stream<T> stream, Class<Throwable> type) {
        this.stream = stream;
        this.type = type;
    }
}

