/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.data.async.Queue;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.internal.react.exceptions.FilteredExecutionPathException;
import com.aol.cyclops.internal.react.exceptions.SimpleReactProcessingException;
import com.aol.cyclops.internal.react.stream.LazyStreamWrapper;
import com.aol.cyclops.react.collectors.lazy.EmptyCollector;
import com.aol.cyclops.types.futurestream.Continuation;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;

public class Runner<U> {
    private final Runnable runnable;

    public boolean run(LazyStreamWrapper<U> lastActive, EmptyCollector<U> collector) {
        try {
            lastActive.injectFutures().forEach(n -> collector.accept((FastFuture)n));
            collector.getResults();
        }
        catch (SimpleReactProcessingException simpleReactProcessingException) {
        }
        catch (CompletionException completionException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.runnable.run();
        return true;
    }

    public Continuation runContinuations(LazyStreamWrapper lastActive, EmptyCollector collector) {
        Iterator it = lastActive.injectFutures().iterator();
        Continuation[] cont = new Continuation[1];
        Continuation finish = new Continuation(() -> {
            collector.getResults();
            this.runnable.run();
            throw new Queue.ClosedQueueException();
        });
        Continuation finishNoCollect = new Continuation(() -> {
            this.runnable.run();
            throw new Queue.ClosedQueueException();
        });
        cont[0] = new Continuation(() -> {
            try {
                if (it.hasNext()) {
                    FastFuture f = (FastFuture)it.next();
                    this.handleFilter(cont, f);
                    collector.accept(f);
                }
                if (it.hasNext()) {
                    return cont[0];
                }
                return finish.proceed();
            }
            catch (SimpleReactProcessingException f) {
            }
            catch (CompletionException f) {
            }
            catch (Throwable e) {
                collector.getSafeJoin().apply(FastFuture.failedFuture(e));
            }
            return finishNoCollect;
        });
        return cont[0];
    }

    private <T> void handleFilter(Continuation[] cont, FastFuture<T> f) {
        AtomicInteger called = new AtomicInteger(0);
        f.essential(event -> {
            if (event.exception != null && event.exception.getCause() instanceof FilteredExecutionPathException && called.compareAndSet(0, 1)) {
                cont[0].proceed();
            }
        });
    }

    @ConstructorProperties(value={"runnable"})
    public Runner(Runnable runnable) {
        this.runnable = runnable;
    }
}

