/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.stream;

import com.aol.cyclops.internal.react.stream.ReactBuilder;
import com.aol.cyclops.types.futurestream.BaseSimpleReactStream;
import com.nurkiewicz.asyncretry.RetryExecutor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class BaseSimpleReact
implements ReactBuilder {
    private final Executor queueService;

    protected abstract Executor getExecutor();

    protected abstract RetryExecutor getRetrier();

    protected abstract boolean isAsync();

    public abstract <U> BaseSimpleReactStream<U> construct(Stream var1);

    protected BaseSimpleReact() {
        this.queueService = null;
    }

    protected BaseSimpleReact(Executor queueService) {
        this.queueService = queueService;
    }

    public BaseSimpleReactStream<Integer> range(int startInclusive, int endExclusive) {
        return this.from(IntStream.range(startInclusive, endExclusive));
    }

    public <U> BaseSimpleReactStream<U> from(Iterator<U> iterator) {
        return this.from(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false));
    }

    public <R> BaseSimpleReactStream<R> from(Collection<R> collection) {
        return this.from(collection.stream());
    }

    public <U> BaseSimpleReactStream<U> fromIterable(Iterable<U> iter) {
        return this.from(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter.iterator(), 16), false));
    }

    public <U> BaseSimpleReactStream<U> fromStream(Stream<CompletableFuture<U>> stream) {
        Stream<CompletableFuture<U>> s = stream;
        return this.construct(s);
    }

    public <U> BaseSimpleReactStream<U> from(Stream<U> stream) {
        Stream<CompletableFuture> s = stream.map(it -> CompletableFuture.completedFuture(it));
        return this.construct(s);
    }

    public <U> BaseSimpleReactStream<U> from(IntStream stream) {
        return this.from(stream.boxed());
    }

    public <U> BaseSimpleReactStream<U> from(DoubleStream stream) {
        return this.from(stream.boxed());
    }

    public <U> BaseSimpleReactStream<U> from(LongStream stream) {
        return this.from(stream.boxed());
    }

    public <U> BaseSimpleReactStream<U> of(U ... array) {
        return this.from(Stream.of(array));
    }

    public <U> BaseSimpleReactStream<U> from(CompletableFuture<U> cf) {
        return this.construct(Stream.of(cf));
    }

    public <U> BaseSimpleReactStream<U> from(CompletableFuture<U> ... cf) {
        return this.construct(Stream.of(cf));
    }

    public <U> BaseSimpleReactStream<U> react(Collection<Supplier<U>> actions) {
        return this.react(actions.toArray(new Supplier[0]));
    }

    public <U> BaseSimpleReactStream<U> react(Stream<Supplier<U>> actions) {
        return this.construct(actions.map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public <U> BaseSimpleReactStream<U> react(Iterator<Supplier<U>> actions) {
        return this.construct(StreamSupport.stream(Spliterators.spliteratorUnknownSize(actions, 16), false).map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public <U> BaseSimpleReactStream<U> reactIterable(Iterable<Supplier<U>> actions) {
        return this.construct(StreamSupport.stream(Spliterators.spliteratorUnknownSize(actions.iterator(), 16), false).map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public <U> BaseSimpleReactStream<U> react(Supplier<U> ... actions) {
        return this.reactI(actions);
    }

    protected <U> BaseSimpleReactStream<U> reactI(Supplier<U> ... actions) {
        return this.construct(Stream.of(actions).map(next -> CompletableFuture.supplyAsync(next, this.getExecutor())));
    }

    public Executor getQueueService() {
        return this.queueService;
    }
}

