/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.async.future;

import com.aol.cyclops.internal.react.async.future.ExecutionPipeline;
import com.aol.cyclops.internal.react.async.future.FastFuture;
import com.aol.cyclops.util.function.Cacheable;
import com.aol.cyclops.util.function.Memoize;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class PipelineBuilder {
    private final ExecutionPipeline builder;
    private final boolean autoOptimise;
    private final Executor optimisingExec;
    private final boolean autoMemoize;
    private final Cacheable memoizeFactory;

    public PipelineBuilder() {
        this.builder = new ExecutionPipeline();
        this.autoOptimise = false;
        this.optimisingExec = null;
        this.autoMemoize = false;
        this.memoizeFactory = null;
    }

    private <T, R> Function<T, R> memoize(Function<T, R> fn) {
        if (!this.autoMemoize) {
            return fn;
        }
        if (this.memoizeFactory == null) {
            return Memoize.memoizeFunction(fn);
        }
        return Memoize.memoizeFunction(fn, this.memoizeFactory);
    }

    public PipelineBuilder(boolean autoOptimise, Executor optimisingExec, boolean autoMemoize, Cacheable memoizeFactory) {
        this.builder = new ExecutionPipeline();
        this.autoOptimise = autoOptimise;
        this.optimisingExec = optimisingExec;
        this.autoMemoize = autoMemoize;
        this.memoizeFactory = memoizeFactory;
    }

    public <T, R> PipelineBuilder thenCompose(Function<? super T, CompletableFuture<? extends R>> fn) {
        if (this.autoOptimise && this.builder.functionListSize() == 0) {
            return this.thenComposeAsync(fn, this.optimisingExec);
        }
        return this.withBuilder(this.builder.thenCompose(this.memoize(fn)));
    }

    public <T, R> PipelineBuilder thenComposeAsync(Function<? super T, CompletableFuture<? extends R>> fn, Executor exec) {
        if (this.autoOptimise && this.builder.functionListSize() > 0) {
            return this.thenCompose(fn);
        }
        return this.withBuilder(this.builder.thenComposeAsync(this.memoize(fn), exec));
    }

    public <T, R> PipelineBuilder thenApplyAsync(Function<T, R> fn, Executor exec) {
        if (this.autoOptimise && this.builder.functionListSize() > 0) {
            return this.thenApply(fn);
        }
        return this.withBuilder(this.builder.thenApplyAsync(this.memoize(fn), exec));
    }

    public <T> PipelineBuilder peek(Consumer<? super T> c) {
        return this.withBuilder(this.builder.peek(c));
    }

    public <T, R> PipelineBuilder thenApply(Function<? super T, ? extends R> fn) {
        if (this.autoOptimise && this.builder.functionListSize() == 0) {
            return this.withBuilder(this.builder.thenApplyAsync(this.memoize(fn), this.optimisingExec));
        }
        return this.withBuilder(this.builder.thenApply(this.memoize(fn)));
    }

    public <X extends Throwable, T> PipelineBuilder exceptionally(Function<? super X, ? extends T> fn) {
        return this.withBuilder(this.builder.exceptionally(fn));
    }

    public <T, X extends Throwable> PipelineBuilder whenComplete(BiConsumer<? super T, ? super X> fn) {
        return this.withBuilder(this.builder.whenComplete(fn));
    }

    public <T> FastFuture<T> build() {
        return new FastFuture(this.builder.toFinalPipeline(), 0);
    }

    public PipelineBuilder onFail(Consumer<Throwable> onFail) {
        return this.withBuilder(this.builder.onFail(onFail));
    }

    public boolean isSequential() {
        return this.builder.isSequential();
    }

    @ConstructorProperties(value={"builder", "autoOptimise", "optimisingExec", "autoMemoize", "memoizeFactory"})
    public PipelineBuilder(ExecutionPipeline builder, boolean autoOptimise, Executor optimisingExec, boolean autoMemoize, Cacheable memoizeFactory) {
        this.builder = builder;
        this.autoOptimise = autoOptimise;
        this.optimisingExec = optimisingExec;
        this.autoMemoize = autoMemoize;
        this.memoizeFactory = memoizeFactory;
    }

    public PipelineBuilder withBuilder(ExecutionPipeline builder) {
        return this.builder == builder ? this : new PipelineBuilder(builder, this.autoOptimise, this.optimisingExec, this.autoMemoize, this.memoizeFactory);
    }

    public PipelineBuilder withAutoOptimise(boolean autoOptimise) {
        return this.autoOptimise == autoOptimise ? this : new PipelineBuilder(this.builder, autoOptimise, this.optimisingExec, this.autoMemoize, this.memoizeFactory);
    }

    public PipelineBuilder withOptimisingExec(Executor optimisingExec) {
        return this.optimisingExec == optimisingExec ? this : new PipelineBuilder(this.builder, this.autoOptimise, optimisingExec, this.autoMemoize, this.memoizeFactory);
    }

    public PipelineBuilder withAutoMemoize(boolean autoMemoize) {
        return this.autoMemoize == autoMemoize ? this : new PipelineBuilder(this.builder, this.autoOptimise, this.optimisingExec, autoMemoize, this.memoizeFactory);
    }

    public PipelineBuilder withMemoizeFactory(Cacheable memoizeFactory) {
        return this.memoizeFactory == memoizeFactory ? this : new PipelineBuilder(this.builder, this.autoOptimise, this.optimisingExec, this.autoMemoize, memoizeFactory);
    }
}

