/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.async.future;

import com.aol.cyclops.internal.react.async.future.CompletedException;
import com.aol.cyclops.internal.react.async.future.FinalPipeline;
import com.aol.cyclops.internal.react.exceptions.SimpleReactCompletionException;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FastFuture<T> {
    private volatile boolean done = false;
    private volatile Consumer<OnComplete> forXOf;
    private volatile Consumer<OnComplete> essential;
    private volatile boolean completedExceptionally = false;
    private final AtomicReference result = new AtomicReference<UnSet>(UNSET);
    private final AtomicReference exception = new AtomicReference<UnSet>(UNSET);
    private final Consumer<FastFuture<T>> doFinally;
    private static UnSet UNSET = new UnSet();
    private FinalPipeline pipeline;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger max = new AtomicInteger(0);

    public FastFuture() {
        this.max.set(0);
        this.doFinally = null;
        this.pipeline = null;
    }

    private T result() {
        UnSet res = UNSET;
        while ((res = this.result.get()) == UNSET) {
            Thread.yield();
        }
        return (T)res;
    }

    private Throwable exception() {
        UnSet result = UNSET;
        while ((result = this.exception.get()) == UNSET) {
            Thread.yield();
        }
        return (Throwable)((Object)result);
    }

    public FastFuture(FinalPipeline pipeline, Consumer<FastFuture<T>> doFinally) {
        this.max.set(0);
        this.pipeline = pipeline;
        this.doFinally = doFinally;
    }

    public FastFuture(FinalPipeline pipeline, int max) {
        this.max.set(max);
        this.pipeline = pipeline;
        this.doFinally = null;
    }

    public void await() {
        long spin = 1L;
        while (!this.done) {
            LockSupport.parkNanos(spin++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T join() {
        try {
            long spin = 1L;
            while (!this.done) {
                LockSupport.parkNanos(spin++);
            }
            if (this.completedExceptionally) {
                throw new SimpleReactCompletionException(this.exception());
            }
            T t = this.result();
            return t;
        }
        finally {
            this.markComplete();
        }
    }

    public void markComplete() {
        if (this.doFinally != null) {
            this.doFinally.accept(this);
        }
    }

    public static <T> FastFuture<T> completedFuture(T value) {
        FastFuture<T> f = new FastFuture<T>();
        f.result.lazySet(value);
        f.done = true;
        return f;
    }

    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture f = new CompletableFuture();
        AtomicInteger count = new AtomicInteger(0);
        this.onComplete(c -> {
            if (!count.compareAndSet(0, 1)) {
                return;
            }
            if (c.exceptionally) {
                f.completeExceptionally(c.exception);
            } else {
                f.complete(c.result);
            }
        });
        return f;
    }

    public FastFuture<T> populateFromCompletableFuture(CompletableFuture<T> cf) {
        cf.thenAccept(i -> this.set(i));
        cf.exceptionally(t -> {
            this.completedExceptionally((Throwable)t);
            return this.join();
        });
        return this;
    }

    private void completedExceptionally(Throwable t) {
        Throwable finalError = t;
        for (int i = 0; i < this.pipeline.firstRecover.length; ++i) {
            try {
                this.set(this.pipeline.firstRecover[i].apply(t));
                return;
            }
            catch (Throwable e) {
                finalError = e;
                this.exception.lazySet(e);
                continue;
            }
        }
        this.completeExceptionally(finalError);
        throw (RuntimeException)this.exception();
    }

    private FastFuture<T> completeExceptionally(Throwable t) {
        this.exception.lazySet(t);
        this.completedExceptionally = true;
        this.handleOnComplete(true);
        if (this.pipeline != null && this.pipeline.onFail != null) {
            this.pipeline.onFail.accept(t);
        }
        this.done = true;
        return this;
    }

    public static <T> FastFuture<T> failedFuture(Throwable t) {
        return super.completeExceptionally(t);
    }

    public static <T> FastFuture<T> fromCompletableFuture(CompletableFuture<T> cf) {
        FastFuture f = new FastFuture();
        cf.thenAccept(i -> f.set(i));
        cf.exceptionally(t -> {
            f.completedExceptionally((Throwable)t);
            return f.join();
        });
        return f;
    }

    public static <R> FastFuture<List<R>> allOf(Runnable onComplete, FastFuture ... futures) {
        FastFuture<List<R>> allOf = new FastFuture<List<R>>(FinalPipeline.empty(), futures.length);
        for (FastFuture next : futures) {
            AtomicInteger count = new AtomicInteger(0);
            next.onComplete(v -> {
                if (!count.compareAndSet(0, 1)) {
                    return;
                }
                if (allOf.count.incrementAndGet() == allOf.max.get()) {
                    onComplete.run();
                }
            });
        }
        return allOf;
    }

    public static <R> FastFuture<List<R>> xOf(int x, Runnable onComplete, FastFuture ... futures) {
        FastFuture<List<R>> xOf = new FastFuture<List<R>>(FinalPipeline.empty(), x);
        for (FastFuture next : futures) {
            AtomicInteger count = new AtomicInteger(0);
            next.onComplete(v -> {
                if (!count.compareAndSet(0, 1)) {
                    return;
                }
                if (xOf.count.incrementAndGet() >= xOf.max.get()) {
                    onComplete.run();
                }
            });
        }
        return xOf;
    }

    public static <R> FastFuture<List<R>> anyOf(FastFuture ... futures) {
        FastFuture anyOf = new FastFuture();
        for (FastFuture next : futures) {
            next.onComplete(v -> {
                anyOf.result.lazySet(true);
                anyOf.done();
            });
        }
        return anyOf;
    }

    public void set(T result) {
        try {
            Object use = result;
            if (this.pipeline == null || this.pipeline.functions.length == 0) {
                this.result.lazySet(use);
                this.done();
                return;
            }
            Function op = this.pipeline.functions[0];
            if (this.pipeline.executors[0] != null) {
                this.pipeline.executors[0].execute(() -> this.set(() -> op.apply(use), 1));
            } else {
                this.set(() -> op.apply(use), 1);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    private void set(Supplier<T> result, int index) {
        try {
            Object current;
            Object use = current = result.get();
            if (index < this.pipeline.functions.length) {
                Function op = this.pipeline.functions[index];
                this.pipeline.executors[index].execute(() -> this.set(() -> op.apply(use), index + 1));
                return;
            }
            this.result.lazySet(current);
            this.done();
        }
        catch (Throwable t) {
            if (t instanceof CompletedException && this.doFinally != null) {
                this.doFinally.accept(this);
            }
            this.completeExceptionally(t);
        }
    }

    private boolean done() {
        this.completedExceptionally = false;
        this.done = true;
        this.handleOnComplete(true);
        return true;
    }

    public void clearFast() {
        this.result.set(UNSET);
        this.exception.set(UNSET);
        this.forXOf = null;
        this.essential = null;
        this.count.set(0);
        this.max.set(0);
        this.completedExceptionally = false;
        this.done = false;
    }

    public void essential(Consumer<OnComplete> fn) {
        this.essential = fn;
        if (this.done) {
            fn.accept(this.buildOnComplete());
        }
    }

    public void onComplete(Consumer<OnComplete> fn) {
        this.forXOf = fn;
        if (this.done) {
            fn.accept(this.buildOnComplete());
        }
    }

    private void handleOnComplete(boolean force) {
        if (this.forXOf != null) {
            this.forXOf.accept(this.buildOnComplete());
        }
        if (this.essential != null) {
            this.essential.accept(this.buildOnComplete());
        }
    }

    private OnComplete buildOnComplete() {
        OnComplete c = new OnComplete(!this.completedExceptionally && this.done ? this.result() : null, this.completedExceptionally ? this.exception() : null, this.completedExceptionally);
        return c;
    }

    @ConstructorProperties(value={"done", "forXOf", "essential", "completedExceptionally", "doFinally", "pipeline"})
    public FastFuture(boolean done, Consumer<OnComplete> forXOf, Consumer<OnComplete> essential, boolean completedExceptionally, Consumer<FastFuture<T>> doFinally, FinalPipeline pipeline) {
        this.done = done;
        this.forXOf = forXOf;
        this.essential = essential;
        this.completedExceptionally = completedExceptionally;
        this.doFinally = doFinally;
        this.pipeline = pipeline;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isCompletedExceptionally() {
        return this.completedExceptionally;
    }

    public FinalPipeline getPipeline() {
        return this.pipeline;
    }

    public static class OnComplete {
        public final Object result;
        public final Throwable exception;
        public final boolean exceptionally;

        @ConstructorProperties(value={"result", "exception", "exceptionally"})
        public OnComplete(Object result, Throwable exception, boolean exceptionally) {
            this.result = result;
            this.exception = exception;
            this.exceptionally = exceptionally;
        }
    }

    static class UnSet {
        UnSet() {
        }
    }
}

