/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.react.async.future;

import com.aol.cyclops.internal.react.async.future.FinalPipeline;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public class ExecutionPipeline {
    private final PStack<Function> functionList;
    private final PStack<Executor> execList;
    private final PStack<Function> firstRecover;
    private final Consumer<Throwable> onFail;

    public ExecutionPipeline() {
        this.functionList = ConsPStack.empty();
        this.execList = ConsPStack.empty();
        this.firstRecover = ConsPStack.empty();
        this.onFail = null;
    }

    public boolean isSequential() {
        if (this.execList.size() == 0) {
            return true;
        }
        return this.execList.size() == 1 && this.execList.get(0) == null;
    }

    public <T> ExecutionPipeline peek(Consumer<? super T> c) {
        return this.thenApply(i -> {
            c.accept(i);
            return i;
        });
    }

    public <T, R> ExecutionPipeline thenApplyAsync(Function<? super T, ? extends R> fn, Executor exec) {
        return new ExecutionPipeline(this.addFn(fn), this.addExec(exec), this.firstRecover, this.onFail);
    }

    public <T, R> ExecutionPipeline thenComposeAsync(Function<Object, CompletableFuture<?>> fn, Executor exec) {
        return new ExecutionPipeline(this.addFn(t -> ((CompletableFuture)fn.apply(t)).join()), this.addExec(exec), this.firstRecover, this.onFail);
    }

    public <T, R> ExecutionPipeline thenCompose(Function<? super T, CompletableFuture<? extends R>> fn) {
        Function<Object, Object> unpacked = t -> ((CompletableFuture)fn.apply(t)).join();
        return new ExecutionPipeline(this.swapFn(unpacked), (PStack<Executor>)(this.execList.size() == 0 ? this.execList.plus(null) : this.execList), this.firstRecover, this.onFail);
    }

    public <T, R> ExecutionPipeline thenApply(Function<T, R> fn) {
        return new ExecutionPipeline(this.swapComposeFn(fn), (PStack<Executor>)(this.execList.size() == 0 ? this.execList.plus(null) : this.execList), this.firstRecover, this.onFail);
    }

    public <X extends Throwable, T> ExecutionPipeline exceptionally(Function<? super X, ? extends T> fn) {
        if (this.functionList.size() > 0) {
            Function before = (Function)this.functionList.get(this.functionList.size() - 1);
            Function<Object, Object> except = t -> {
                try {
                    return before.apply(t);
                }
                catch (Throwable e) {
                    return fn.apply((Object)e);
                }
            };
            return new ExecutionPipeline(this.swapFn(except), this.execList, this.firstRecover, this.onFail);
        }
        return new ExecutionPipeline(this.functionList, this.execList, this.addFirstRecovery(fn), this.onFail);
    }

    public <X extends Throwable, T> ExecutionPipeline whenComplete(BiConsumer<? super T, ? super X> fn) {
        Function before = (Function)this.functionList.get(this.functionList.size() - 1);
        Function<Object, Object> except = t -> {
            Object res = null;
            Throwable ex = null;
            try {
                res = before.apply(t);
            }
            catch (Throwable e) {
                ex = e;
            }
            fn.accept((Object)res, (Object)ex);
            if (ex != null) {
                throw (RuntimeException)ex;
            }
            return res;
        };
        return new ExecutionPipeline(this.swapFn(except), this.execList, this.firstRecover, this.onFail);
    }

    public FinalPipeline toFinalPipeline() {
        return new FinalPipeline((Function[])this.functionList.toArray((Object[])new Function[0]), (Executor[])this.execList.toArray((Object[])new Executor[0]), (Function[])this.firstRecover.toArray((Object[])new Function[0]), this.onFail);
    }

    public static ExecutionPipeline empty() {
        ExecutionPipeline pipeline = new ExecutionPipeline();
        return pipeline;
    }

    private PStack<Executor> addExec(Executor exec) {
        if (this.execList.size() == 0) {
            return this.execList.plus((Object)exec);
        }
        return this.execList.plus(this.execList.size(), (Object)exec);
    }

    private PStack<Function> addFirstRecovery(Function fn) {
        if (this.firstRecover.size() == 0) {
            return this.firstRecover.plus((Object)fn);
        }
        return this.firstRecover.plus(this.firstRecover.size(), (Object)fn);
    }

    private PStack<Function> addFn(Function fn) {
        if (this.functionList.size() == 0) {
            return this.functionList.plus((Object)fn);
        }
        return this.functionList.plus(this.functionList.size(), (Object)fn);
    }

    private PStack<Function> swapFn(Function fn) {
        if (this.functionList.size() == 0) {
            return this.functionList.plus((Object)fn);
        }
        Function before = (Function)this.functionList.get(this.functionList.size() - 1);
        PStack removed = this.functionList.minus(this.functionList.size() - 1);
        return removed.plus(removed.size(), (Object)fn);
    }

    private PStack<Function> swapComposeFn(Function fn) {
        if (this.functionList.size() == 0) {
            if (this.firstRecover.size() == 0) {
                return this.functionList.plus((Object)fn);
            }
            Function<Object, Object> except = t -> {
                try {
                    return fn.apply(t);
                }
                catch (Throwable e) {
                    return this.composeFirstRecovery().apply(e);
                }
            };
            return this.functionList.plus(except);
        }
        Function before = (Function)this.functionList.get(this.functionList.size() - 1);
        PStack removed = this.functionList.minus(this.functionList.size() - 1);
        return removed.plus(removed.size(), fn.compose(before));
    }

    private Function composeFirstRecovery() {
        return (Function)this.firstRecover.stream().reduce((fn1, fn2) -> {
            Function<Object, Object> except = t -> {
                try {
                    return fn1.apply(t);
                }
                catch (Throwable e) {
                    return fn2.apply(e);
                }
            };
            return except;
        }).get();
    }

    int functionListSize() {
        return this.functionList.size();
    }

    public ExecutionPipeline onFail(Consumer<Throwable> onFail) {
        return this.withOnFail(onFail);
    }

    public String toString() {
        return "ExecutionPipeline(functionList=" + this.functionList + ", execList=" + this.execList + ", firstRecover=" + this.firstRecover + ", onFail=" + this.onFail + ")";
    }

    @ConstructorProperties(value={"functionList", "execList", "firstRecover", "onFail"})
    public ExecutionPipeline(PStack<Function> functionList, PStack<Executor> execList, PStack<Function> firstRecover, Consumer<Throwable> onFail) {
        this.functionList = functionList;
        this.execList = execList;
        this.firstRecover = firstRecover;
        this.onFail = onFail;
    }

    public ExecutionPipeline withFunctionList(PStack<Function> functionList) {
        return this.functionList == functionList ? this : new ExecutionPipeline(functionList, this.execList, this.firstRecover, this.onFail);
    }

    public ExecutionPipeline withExecList(PStack<Executor> execList) {
        return this.execList == execList ? this : new ExecutionPipeline(this.functionList, execList, this.firstRecover, this.onFail);
    }

    public ExecutionPipeline withFirstRecover(PStack<Function> firstRecover) {
        return this.firstRecover == firstRecover ? this : new ExecutionPipeline(this.functionList, this.execList, firstRecover, this.onFail);
    }

    public ExecutionPipeline withOnFail(Consumer<Throwable> onFail) {
        return this.onFail == onFail ? this : new ExecutionPipeline(this.functionList, this.execList, this.firstRecover, onFail);
    }
}

