/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.internal.comprehensions.comprehenders;

import com.aol.cyclops.types.extensability.Comprehender;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SetComprehender
implements Comprehender<Object> {
    @Override
    public Class getTargetClass() {
        return Set.class;
    }

    @Override
    public Object filter(Object t, Predicate p) {
        if (t instanceof Set) {
            return ((Set)t).stream().filter(p);
        }
        return ((Stream)t).filter(p);
    }

    @Override
    public Object map(Object t, Function fn) {
        if (t instanceof Set) {
            return ((Set)t).stream().map(fn);
        }
        return ((Stream)t).map(fn);
    }

    @Override
    public Object executeflatMap(Object t, Function fn) {
        return this.flatMap(t, input -> SetComprehender.unwrapOtherMonadTypesLC(this, fn.apply(input)));
    }

    @Override
    public Object flatMap(Object t, Function fn) {
        if (t instanceof Set) {
            return ((Set)t).stream().flatMap(fn);
        }
        return ((Stream)t).flatMap(fn);
    }

    @Override
    public boolean instanceOfT(Object apply) {
        return apply instanceof Stream;
    }

    @Override
    public Set empty() {
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public Set of(Object o) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(o);
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set fromIterator(Iterator it) {
        HashSet set = new HashSet();
        for (Object next : () -> it) {
            set.add(next);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set unwrap(Object o) {
        if (o instanceof Set) {
            return (Set)o;
        }
        return ((Stream)o).collect(Collectors.toSet());
    }

    static Stream unwrapOtherMonadTypesLC(Comprehender comp, Object apply) {
        if (apply instanceof Collection) {
            return ((Collection)apply).stream();
        }
        if (apply instanceof Iterable) {
            return StreamSupport.stream(((Iterable)apply).spliterator(), false);
        }
        if (apply instanceof BaseStream) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((BaseStream)apply).iterator(), 16), false);
        }
        Object o = Comprehender.unwrapOtherMonadTypes(comp, apply);
        if (o instanceof Collection) {
            return ((Collection)o).stream();
        }
        if (o instanceof Iterable) {
            return StreamSupport.stream(((Iterable)o).spliterator(), false);
        }
        if (apply instanceof BaseStream) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(((BaseStream)apply).iterator(), 16), false);
        }
        return (Stream)o;
    }
}

