/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.data.collections.extensions.standard;

import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.FluentMapX;
import com.aol.cyclops.data.collections.extensions.standard.MapXImpl;
import com.aol.cyclops.types.BiFunctor;
import com.aol.cyclops.types.ExtendedTraversable;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.IterableFilterable;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.util.stream.StreamUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;

public interface MapX<K, V>
extends Map<K, V>,
FluentMapX<K, V>,
BiFunctor<K, V>,
Functor<V>,
IterableFilterable<Tuple2<K, V>>,
ExtendedTraversable<Tuple2<K, V>>,
Foldable<Tuple2<K, V>>,
CyclopsCollectable<Tuple2<K, V>> {
    public static <K, V> Collector<Tuple2<? extends K, ? extends V>, ?, Map<K, V>> defaultCollector() {
        return Collectors.toMap(t -> t.v1, t -> t.v2);
    }

    public static <K, V> Collector<Tuple2<? extends K, ? extends V>, ?, Map<K, V>> immutableCollector() {
        return Collectors.collectingAndThen(MapX.defaultCollector(), Collections::unmodifiableMap);
    }

    public static <K, V> Collector<Tuple2<? extends K, ? extends V>, ?, Map<K, V>> toMapX() {
        return Collectors.collectingAndThen(MapX.defaultCollector(), d -> new MapXImpl(d, MapX.defaultCollector()));
    }

    public <K, V> Collector<Tuple2<? extends K, ? extends V>, ?, Map<K, V>> getCollector();

    @Override
    default public ReactiveSeq<Tuple2<K, V>> stream() {
        return ReactiveSeq.fromIterable(this.entrySet()).map((T e) -> Tuple.tuple(e.getKey(), e.getValue()));
    }

    public static <K, V> MapX<K, V> fromMap(Map<? extends K, ? extends V> it) {
        return MapX.fromMap(MapX.defaultCollector(), it);
    }

    public static <K, V> MapX<K, V> fromMap(Collector<Tuple2<? extends K, ? extends V>, ?, Map<K, V>> collector, Map<? extends K, ? extends V> it) {
        if (it instanceof MapX) {
            return (MapX)it;
        }
        if (it instanceof Map) {
            return new MapXImpl<K, V>(it, collector);
        }
        return new MapXImpl<K, V>(StreamUtils.stream(it).map((? super T e) -> Tuple.tuple(e.getKey(), e.getValue())).collect(collector), collector);
    }

    default public MapX<K, V> fromStream(ReactiveSeq<Tuple2<K, V>> stream) {
        return new MapXImpl<Object, Object>(stream.toMap(t -> t.v1, t -> t.v2), this.getCollector());
    }

    @Override
    default public Iterator<Tuple2<K, V>> iterator() {
        return this.stream().iterator();
    }

    @Override
    default public Collectable<Tuple2<K, V>> collectable() {
        return this.stream();
    }

    default public <KR, VR> MapX<KR, VR> flatMap(BiFunction<? super K, ? super V, ? extends MapX<KR, VR>> fn) {
        Stream s = this.stream().flatMap((T t) -> ((MapX)fn.apply((Object)t.v1, (Object)t.v2)).stream());
        return new MapXImpl<Object, Object>(s.toMap(t -> t.v1, t -> t.v2), this.getCollector());
    }

    default public <R> MapX<K, R> map(Function<? super V, ? extends R> fn) {
        Stream s = this.stream().map((T t) -> t.map2(v -> fn.apply((Object)v)));
        return new MapXImpl<Object, Object>(s.toMap(t -> t.v1, t -> t.v2), this.getCollector());
    }

    @Override
    default public <R1, R2> BiFunctor<R1, R2> bimap(Function<? super K, ? extends R1> fn1, Function<? super V, ? extends R2> fn2) {
        Stream s1 = this.stream().map((T t) -> t.map1(v -> fn1.apply((Object)v)));
        Stream s2 = s1.map((T t) -> t.map2(v -> fn2.apply((Object)v)));
        return new MapXImpl<Object, Object>(s2.toMap(t -> t.v1, t -> t.v2), this.getCollector());
    }

    @Override
    public int size();

    @Override
    default public boolean allMatch(Predicate<? super Tuple2<K, V>> c) {
        return CyclopsCollectable.super.allMatch(c);
    }

    @Override
    default public boolean anyMatch(Predicate<? super Tuple2<K, V>> c) {
        return CyclopsCollectable.super.anyMatch(c);
    }

    @Override
    default public boolean noneMatch(Predicate<? super Tuple2<K, V>> c) {
        return CyclopsCollectable.super.noneMatch(c);
    }

    @Override
    default public Optional<Tuple2<K, V>> max(Comparator<? super Tuple2<K, V>> comparator) {
        return CyclopsCollectable.super.max(comparator);
    }

    @Override
    default public Optional<Tuple2<K, V>> min(Comparator<? super Tuple2<K, V>> comparator) {
        return CyclopsCollectable.super.min(comparator);
    }

    @Override
    default public MapX<K, V> plus(K key, V value) {
        return (MapX)FluentMapX.super.plus(key, value);
    }

    @Override
    default public MapX<K, V> plusAll(Map<? extends K, ? extends V> map) {
        return (MapX)FluentMapX.super.plusAll(map);
    }

    @Override
    default public MapX<K, V> minus(Object key) {
        return (MapX)FluentMapX.super.minus(key);
    }

    @Override
    default public MapX<K, V> minusAll(Collection<?> keys) {
        return (MapX)FluentMapX.super.minusAll(keys);
    }

    default public <U> MapX<K, U> cast(Class<? extends U> type) {
        return (MapX)Functor.super.cast(type);
    }

    default public MapX<K, V> peek(Consumer<? super V> c) {
        return (MapX)Functor.super.peek(c);
    }

    default public <R> MapX<K, R> trampoline(Function<? super V, ? extends Trampoline<? extends R>> mapper) {
        return (MapX)Functor.super.trampoline(mapper);
    }

    default public MapX<K, V> filter(Predicate<? super Tuple2<K, V>> fn) {
        return this.stream().filter(fn).toMapX(t -> t.v1, t -> t.v2);
    }

    default public MapX<K, V> filterNot(Predicate<? super Tuple2<K, V>> fn) {
        return (MapX)IterableFilterable.super.filterNot(fn);
    }

    default public MapX<K, V> notNull() {
        return (MapX)IterableFilterable.super.notNull();
    }

    default public MapX<K, V> removeAll(Stream<? extends Tuple2<K, V>> stream) {
        return (MapX)IterableFilterable.super.removeAll(stream);
    }

    default public MapX<K, V> removeAll(Iterable<? extends Tuple2<K, V>> it) {
        return (MapX)IterableFilterable.super.removeAll(it);
    }

    default public MapX<K, V> removeAll(Tuple2<K, V> ... values) {
        return (MapX)IterableFilterable.super.removeAll(values);
    }

    default public MapX<K, V> retainAll(Iterable<? extends Tuple2<K, V>> it) {
        return (MapX)IterableFilterable.super.retainAll(it);
    }

    default public MapX<K, V> retainAll(Stream<? extends Tuple2<K, V>> stream) {
        return (MapX)IterableFilterable.super.retainAll(stream);
    }

    default public MapX<K, V> retainAll(Tuple2<K, V> ... values) {
        return (MapX)IterableFilterable.super.retainAll(values);
    }
}

