/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control.monads.transformers.seq;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.control.monads.transformers.TryT;
import com.aol.cyclops.control.monads.transformers.seq.MaybeTSeq;
import com.aol.cyclops.control.monads.transformers.values.ValueTransformerSeq;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Foldable;
import com.aol.cyclops.types.Sequential;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.anyM.AnyMSeq;
import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;

public class TryTSeq<T, X extends Throwable>
implements TryT<T, X>,
ValueTransformerSeq<T>,
Foldable<T>,
ConvertableSequence<T>,
CyclopsCollectable<T>,
Sequential<T> {
    private final AnyMSeq<Try<T, X>> run;

    private TryTSeq(AnyMSeq<Try<T, X>> run) {
        this.run = run;
    }

    @Override
    public AnyMSeq<Try<T, X>> unwrap() {
        return this.run;
    }

    @Override
    public TryTSeq<T, X> peek(Consumer<? super T> peek) {
        return TryTSeq.of(this.run.peek((T opt) -> opt.map((T a) -> {
            peek.accept(a);
            return a;
        })));
    }

    @Override
    public MaybeTSeq<T> filter(Predicate<? super T> test) {
        return MaybeTSeq.of(this.run.map((T opt) -> opt.filter(test)));
    }

    @Override
    public <B> TryTSeq<B, X> map(Function<? super T, ? extends B> f) {
        return new TryTSeq<T, X>(this.run.map((T o) -> o.map(f)));
    }

    public <B> TryTSeq<B, X> flatMapT(Function<? super T, TryTSeq<B, X>> f) {
        return TryTSeq.of(this.run.bind((T opt) -> {
            if (opt.isSuccess()) {
                return ((TryTSeq)f.apply(opt.get())).run.unwrap();
            }
            Try ret = opt;
            return this.run.unit((Object)ret).unwrap();
        }));
    }

    @Override
    public <B> TryTSeq<B, X> flatMap(Function<? super T, ? extends Try<B, X>> f) {
        return new TryTSeq<T, X>(this.run.map((T o) -> o.flatMap(f)));
    }

    public <T> TryTSeq<T, X> unitStream(ReactiveSeq<T> traversable) {
        return TryT.fromStream(traversable.map(Try::success));
    }

    public <T> TryTSeq<T, X> unitAnyM(AnyM<Traversable<T>> traversable) {
        return TryTSeq.of((AnyMSeq)traversable.map((T t) -> Try.fromIterable(t)));
    }

    public AnyMSeq<? extends Traversable<T>> transformerStream() {
        return this.run.map((T t) -> t.toListX());
    }

    public static <U, R, X extends Throwable> Function<TryTSeq<U, X>, TryTSeq<R, X>> lift(Function<? super U, ? extends R> fn) {
        return optTu -> optTu.map((T input) -> fn.apply((Object)input));
    }

    public static <U1, U2, R, X extends Throwable> BiFunction<TryTSeq<U1, X>, TryTSeq<U2, X>, TryTSeq<R, X>> lift2(BiFunction<? super U1, ? super U2, ? extends R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMapT(input1 -> optTu2.map((T input2) -> fn.apply((Object)input1, (Object)input2)));
    }

    public static <A, X extends Throwable> TryTSeq<A, X> fromAnyM(AnyMSeq<A> anyM) {
        return TryTSeq.of(anyM.map(Try.Success::of));
    }

    public static <A, X extends Throwable> TryTSeq<A, X> of(AnyMSeq<Try<A, X>> monads) {
        return new TryTSeq(monads);
    }

    public static <A, X extends Throwable> TryTSeq<A, X> of(Try<A, X> monads) {
        return TryT.fromIterable(ListX.of(new Try[]{monads}));
    }

    public String toString() {
        return String.format("TryTSeq[%s]", this.run);
    }

    public boolean isSuccess() {
        return this.run.allMatch(t -> t.isSuccess());
    }

    public boolean isFailure() {
        return this.run.allMatch(t -> t.isFailure());
    }

    public <R> R visit(Function<? super T, ? extends R> success, Function<? super X, ? extends R> failure, Monoid<R> combiner) {
        return this.run.map((T t) -> t.visit(success, failure)).reduce(combiner);
    }

    @Override
    public <R> TryTSeq<R, X> unit(R value) {
        return TryTSeq.of(this.run.unit((Object)Try.success(value)));
    }

    @Override
    public <R> TryTSeq<R, X> empty() {
        return TryTSeq.of(this.run.unit((Object)Try.failure(null)));
    }

    @Override
    public ReactiveSeq<T> stream() {
        return this.run.stream().flatMapIterable(e -> e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    public <R> TryTSeq<R, X> unitIterator(Iterator<R> it) {
        return TryTSeq.of(this.run.unitIterator(it).map((T i) -> Try.success(i)));
    }

    @Override
    public Collectable<T> collectable() {
        return this.stream();
    }

    @Override
    public boolean isSeqPresent() {
        return !this.run.isEmpty();
    }

    public static <T, X extends Throwable> TryTSeq<T, X> emptyList() {
        return TryT.fromIterable(ListX.of(new Try[0]));
    }

    public TryTSeq<T, X> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return (TryTSeq)ValueTransformerSeq.super.combine(predicate, op);
    }

    public TryTSeq<T, X> cycle(int times) {
        return (TryTSeq)ValueTransformerSeq.super.cycle(times);
    }

    public TryTSeq<T, X> cycle(Monoid<T> m, int times) {
        return (TryTSeq)ValueTransformerSeq.super.cycle(m, times);
    }

    public TryTSeq<T, X> cycleWhile(Predicate<? super T> predicate) {
        return (TryTSeq)ValueTransformerSeq.super.cycleWhile(predicate);
    }

    public TryTSeq<T, X> cycleUntil(Predicate<? super T> predicate) {
        return (TryTSeq)ValueTransformerSeq.super.cycleUntil(predicate);
    }

    public <U, R> TryTSeq<R, X> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return (TryTSeq)ValueTransformerSeq.super.zip(other, zipper);
    }

    public <U> TryTSeq<Tuple2<T, U>, X> zipStream(Stream<? extends U> other) {
        return (TryTSeq)ValueTransformerSeq.super.zipStream(other);
    }

    public <U> TryTSeq<Tuple2<T, U>, X> zip(Seq<? extends U> other) {
        return (TryTSeq)ValueTransformerSeq.super.zip(other);
    }

    public <S, U> TryTSeq<Tuple3<T, S, U>, X> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return (TryTSeq)ValueTransformerSeq.super.zip3(second, third);
    }

    public <T2, T3, T4> TryTSeq<Tuple4<T, T2, T3, T4>, X> zip4(Stream<T2> second, Stream<T3> third, Stream<T4> fourth) {
        return (TryTSeq)ValueTransformerSeq.super.zip4(second, third, fourth);
    }

    public TryTSeq<Tuple2<T, Long>, X> zipWithIndex() {
        return (TryTSeq)ValueTransformerSeq.super.zipWithIndex();
    }

    public TryTSeq<ListX<T>, X> sliding(int windowSize) {
        return (TryTSeq)ValueTransformerSeq.super.sliding(windowSize);
    }

    public TryTSeq<ListX<T>, X> sliding(int windowSize, int increment) {
        return (TryTSeq)ValueTransformerSeq.super.sliding(windowSize, increment);
    }

    public <C extends Collection<? super T>> TryTSeq<C, X> grouped(int size, Supplier<C> supplier) {
        return (TryTSeq)ValueTransformerSeq.super.grouped(size, supplier);
    }

    public TryTSeq<ListX<T>, X> groupedUntil(Predicate<? super T> predicate) {
        return (TryTSeq)ValueTransformerSeq.super.groupedUntil(predicate);
    }

    public TryTSeq<ListX<T>, X> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return (TryTSeq)ValueTransformerSeq.super.groupedStatefullyWhile(predicate);
    }

    public TryTSeq<ListX<T>, X> groupedWhile(Predicate<? super T> predicate) {
        return (TryTSeq)ValueTransformerSeq.super.groupedWhile(predicate);
    }

    public <C extends Collection<? super T>> TryTSeq<C, X> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (TryTSeq)ValueTransformerSeq.super.groupedWhile(predicate, factory2);
    }

    public <C extends Collection<? super T>> TryTSeq<C, X> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return (TryTSeq)ValueTransformerSeq.super.groupedUntil(predicate, factory2);
    }

    public TryTSeq<ListX<T>, X> grouped(int groupSize) {
        return (TryTSeq)ValueTransformerSeq.super.grouped(groupSize);
    }

    public <K, A, D> TryTSeq<Tuple2<K, D>, X> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return (TryTSeq)ValueTransformerSeq.super.grouped(classifier, downstream);
    }

    public <K> TryTSeq<Tuple2<K, Seq<T>>, X> grouped(Function<? super T, ? extends K> classifier) {
        return (TryTSeq)ValueTransformerSeq.super.grouped(classifier);
    }

    public TryTSeq<T, X> distinct() {
        return (TryTSeq)ValueTransformerSeq.super.distinct();
    }

    public TryTSeq<T, X> scanLeft(Monoid<T> monoid) {
        return (TryTSeq)ValueTransformerSeq.super.scanLeft(monoid);
    }

    public <U> TryTSeq<U, X> scanLeft(U seed, BiFunction<? super U, ? super T, ? extends U> function) {
        return (TryTSeq)ValueTransformerSeq.super.scanLeft(seed, function);
    }

    public TryTSeq<T, X> scanRight(Monoid<T> monoid) {
        return (TryTSeq)ValueTransformerSeq.super.scanRight(monoid);
    }

    public <U> TryTSeq<U, X> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return (TryTSeq)ValueTransformerSeq.super.scanRight(identity, combiner);
    }

    public TryTSeq<T, X> sorted() {
        return (TryTSeq)ValueTransformerSeq.super.sorted();
    }

    public TryTSeq<T, X> sorted(Comparator<? super T> c) {
        return (TryTSeq)ValueTransformerSeq.super.sorted(c);
    }

    public TryTSeq<T, X> takeWhile(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.takeWhile(p);
    }

    public TryTSeq<T, X> dropWhile(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.dropWhile(p);
    }

    public TryTSeq<T, X> takeUntil(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.takeUntil(p);
    }

    public TryTSeq<T, X> dropUntil(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.dropUntil(p);
    }

    public TryTSeq<T, X> dropRight(int num) {
        return (TryTSeq)ValueTransformerSeq.super.dropRight(num);
    }

    public TryTSeq<T, X> takeRight(int num) {
        return (TryTSeq)ValueTransformerSeq.super.takeRight(num);
    }

    public TryTSeq<T, X> skip(long num) {
        return (TryTSeq)ValueTransformerSeq.super.skip(num);
    }

    public TryTSeq<T, X> skipWhile(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.skipWhile(p);
    }

    public TryTSeq<T, X> skipUntil(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.skipUntil(p);
    }

    public TryTSeq<T, X> limit(long num) {
        return (TryTSeq)ValueTransformerSeq.super.limit(num);
    }

    public TryTSeq<T, X> limitWhile(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.limitWhile(p);
    }

    public TryTSeq<T, X> limitUntil(Predicate<? super T> p) {
        return (TryTSeq)ValueTransformerSeq.super.limitUntil(p);
    }

    public TryTSeq<T, X> intersperse(T value) {
        return (TryTSeq)ValueTransformerSeq.super.intersperse(value);
    }

    public TryTSeq<T, X> reverse() {
        return (TryTSeq)ValueTransformerSeq.super.reverse();
    }

    public TryTSeq<T, X> shuffle() {
        return (TryTSeq)ValueTransformerSeq.super.shuffle();
    }

    public TryTSeq<T, X> skipLast(int num) {
        return (TryTSeq)ValueTransformerSeq.super.skipLast(num);
    }

    public TryTSeq<T, X> limitLast(int num) {
        return (TryTSeq)ValueTransformerSeq.super.limitLast(num);
    }

    public TryTSeq<T, X> onEmpty(T value) {
        return (TryTSeq)ValueTransformerSeq.super.onEmpty(value);
    }

    public TryTSeq<T, X> onEmptyGet(Supplier<? extends T> supplier) {
        return (TryTSeq)ValueTransformerSeq.super.onEmptyGet(supplier);
    }

    public <X extends Throwable> TryTSeq<T, X> onEmptyThrow(Supplier<? extends X> supplier) {
        return (TryTSeq)ValueTransformerSeq.super.onEmptyThrow(supplier);
    }

    public TryTSeq<T, X> shuffle(Random random) {
        return (TryTSeq)ValueTransformerSeq.super.shuffle(random);
    }

    public TryTSeq<T, X> slice(long from, long to) {
        return (TryTSeq)ValueTransformerSeq.super.slice(from, to);
    }

    public <U extends Comparable<? super U>> TryTSeq<T, X> sorted(Function<? super T, ? extends U> function) {
        return (TryTSeq)ValueTransformerSeq.super.sorted(function);
    }
}

