/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Eval;
import com.aol.cyclops.control.For;
import com.aol.cyclops.control.Ior;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.control.Xor;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.Applicativable;
import com.aol.cyclops.types.stream.ToStream;
import com.aol.cyclops.util.ExceptionSoftener;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Try<T, X extends Throwable>
extends Supplier<T>,
MonadicValue<T>,
ToStream<T>,
Filterable<T>,
Functor<T>,
Applicativable<T> {
    public static <T, X extends Throwable> Try<T, X> fromIterable(Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        return Try.success(it.hasNext() ? (T)it.next() : null);
    }

    @Override
    default public Try<T, Throwable> toTry() {
        return this;
    }

    default public <R> Eval<R> matches(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> secondary, Function<Matchable.CheckValue1<X, R>, Matchable.CheckValue1<X, R>> primary, Supplier<? extends R> otherwise) {
        return this.toXor().swap().matches(secondary, primary, otherwise);
    }

    public X failureGet();

    @Override
    public Xor<X, T> toXor();

    @Override
    public Ior<X, T> toIor();

    default public <R> Try<R, X> coflatMap(Function<? super MonadicValue<T>, R> mapper) {
        return mapper.andThen(r -> this.unit(r)).apply(this);
    }

    default public Try<MonadicValue<T>, X> nest() {
        return this.map((T t) -> this.unit(t));
    }

    default public Try<T, X> combine(Monoid<T> monoid, Try<? extends T, X> v2) {
        return this.unit(For.Values.each2(this, t1 -> v2, (t1, t2) -> monoid.combiner().apply(t1, t2)).orElseGet(() -> this.orElseGet(() -> monoid.zero())));
    }

    default public <U> Try<U, X> cast(Class<? extends U> type) {
        return (Try)Applicativable.super.cast(type);
    }

    default public <R> Try<R, X> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (Try)Applicativable.super.trampoline(mapper);
    }

    @Override
    default public <U> Maybe<U> ofType(Class<? extends U> type) {
        return (Maybe)Filterable.super.ofType(type);
    }

    @Override
    default public Maybe<T> filterNot(Predicate<? super T> fn) {
        return (Maybe)Filterable.super.filterNot(fn);
    }

    @Override
    default public Maybe<T> notNull() {
        return (Maybe)Filterable.super.notNull();
    }

    public static <T, X extends Throwable> Failure<T, X> failure(X error) {
        return new Failure(error);
    }

    public static <T, X extends Throwable> Success<T, X> success(T value) {
        return new Success(value, new Class[0]);
    }

    default public Xor<X, T> toXorWithError() {
        if (this.isSuccess()) {
            return Xor.primary(this.get());
        }
        return Xor.secondary(this.toFailedOptional().get());
    }

    default public <T> Try<T, X> unit(T value) {
        return Try.success(value);
    }

    default public <R> Try<R, X> patternMatch(Function<Matchable.CheckValue1<T, R>, Matchable.CheckValue1<T, R>> case1, Supplier<? extends R> otherwise) {
        return (Try)Applicativable.super.patternMatch(case1, otherwise);
    }

    public <R> R visit(Function<? super T, ? extends R> var1, Function<? super X, ? extends R> var2);

    @Override
    public AnyMValue<T> anyM();

    public AnyM<X> anyMFailure();

    public AnyM<T> anyMSuccess();

    @Override
    public T get();

    public void throwException();

    @Override
    public T orElse(T var1);

    @Override
    public T orElseGet(Supplier<? extends T> var1);

    public <R> Try<R, X> map(Function<? super T, ? extends R> var1);

    public <R> Try<R, X> flatMap(Function<? super T, ? extends Try<R, X>> var1);

    @Override
    public Maybe<T> filter(Predicate<? super T> var1);

    public Try<T, X> onFail(Consumer<? super X> var1);

    public Try<T, X> onFail(Class<? extends X> var1, Consumer<X> var2);

    public Success<T, X> recover(Function<? super X, ? extends T> var1);

    public Success<T, X> recoverWith(Function<? super X, ? extends Success<T, X>> var1);

    public Try<T, X> recoverFor(Class<? extends X> var1, Function<? super X, ? extends T> var2);

    public Try<T, X> recoverWithFor(Class<? extends X> var1, Function<? super X, ? extends Success<T, X>> var2);

    public Try<T, X> flatten();

    @Override
    public Optional<T> toOptional();

    @Override
    public ReactiveSeq<T> stream();

    public Optional<X> toFailedOptional();

    public Stream<X> toFailedStream();

    public boolean isSuccess();

    public boolean isFailure();

    @Override
    public void forEach(Consumer<? super T> var1);

    public void forEachFailed(Consumer<? super X> var1);

    default public Try<T, X> peek(Consumer<? super T> consumer) {
        this.forEach(consumer);
        return this;
    }

    default public Try<T, X> peekFailed(Consumer<? super X> consumer) {
        this.forEachFailed(consumer);
        return this;
    }

    @Override
    default public Iterator<T> iterator() {
        return Applicativable.super.iterator();
    }

    @SafeVarargs
    public static <T, X extends Throwable> Try<T, X> of(T value, Class<? extends Throwable> ... classes) {
        return new Success(value, classes);
    }

    @SafeVarargs
    public static <T, X extends Throwable> Try<T, X> withCatch(CheckedSupplier<T, X> cf, Class<? extends X> ... classes) {
        Objects.requireNonNull(cf);
        try {
            return Try.success(cf.get());
        }
        catch (Throwable t) {
            if (classes.length == 0) {
                return Failure.of(t);
            }
            Optional<Class> error = Stream.of(classes).filter((? super T c) -> c.isAssignableFrom(t.getClass())).findFirst();
            if (error.isPresent()) {
                return Failure.of(t);
            }
            throw ExceptionSoftener.throwSoftenedException(t);
        }
    }

    @SafeVarargs
    public static <X extends Throwable> Try<Void, X> runWithCatch(CheckedRunnable<X> cf, Class<? extends X> ... classes) {
        Objects.requireNonNull(cf);
        try {
            cf.run();
            return Success.of(null);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (classes.length == 0) {
                return Failure.of(t);
            }
            Optional<Class> error = Stream.of(classes).filter((? super T c) -> c.isAssignableFrom(t.getClass())).findFirst();
            if (error.isPresent()) {
                return Failure.of(t);
            }
            throw ExceptionSoftener.throwSoftenedException(t);
        }
    }

    @SafeVarargs
    public static <X extends Throwable> Init<X> catchExceptions(Class<? extends X> ... classes) {
        return new MyInit<X>(classes);
    }

    public static class Failure<T, X extends Throwable>
    implements Try<T, X> {
        private final X error;

        @Override
        public String mkString() {
            return "Failure[" + this.error + "]";
        }

        @Override
        public ListX<X> unapply() {
            return ListX.of(new Throwable[]{this.error});
        }

        @Override
        public Xor<X, T> toXor() {
            return Xor.secondary(this.error);
        }

        @Override
        public Ior<X, T> toIor() {
            return Ior.secondary(this.error);
        }

        @Override
        public AnyMValue<T> anyM() {
            return this.anyMSuccess();
        }

        @Override
        public AnyMValue<X> anyMFailure() {
            return AnyM.ofValue(this);
        }

        @Override
        public AnyMValue<T> anyMSuccess() {
            return AnyM.fromOptional(Optional.empty());
        }

        @Override
        public X failureGet() {
            return this.error;
        }

        @Deprecated
        public static <T, X extends Throwable> Failure<T, X> of(X error) {
            return new Failure<T, X>(error);
        }

        public static <T, X extends Throwable> AnyM<X> anyMOf(X error) {
            return new Failure<T, X>(error).anyMFailure();
        }

        @Override
        public T get() {
            throw ExceptionSoftener.throwSoftenedException(this.error);
        }

        @Override
        public <R> Try<R, X> map(Function<? super T, ? extends R> fn) {
            return this;
        }

        @Override
        public <R> Try<R, X> flatMap(Function<? super T, ? extends Try<R, X>> fn) {
            return this;
        }

        @Override
        public Maybe<T> filter(Predicate<? super T> p) {
            return Maybe.none();
        }

        @Override
        public Try<T, X> recoverWithFor(Class<? extends X> t, Function<? super X, ? extends Success<T, X>> fn) {
            if (t.isAssignableFrom(this.error.getClass())) {
                return this.recoverWith(fn);
            }
            return this;
        }

        @Override
        public Try<T, X> recoverFor(Class<? extends X> t, Function<? super X, ? extends T> fn) {
            if (t.isAssignableFrom(this.error.getClass())) {
                return this.recover(fn);
            }
            return this;
        }

        @Override
        public Success<T, X> recover(Function<? super X, ? extends T> fn) {
            return Success.of(fn.apply(this.error));
        }

        @Override
        public Success<T, X> recoverWith(Function<? super X, ? extends Success<T, X>> fn) {
            return fn.apply(this.error);
        }

        @Override
        public Try<T, X> flatten() {
            return this;
        }

        @Override
        public T orElse(T value) {
            return value;
        }

        @Override
        public T orElseGet(Supplier<? extends T> value) {
            return value.get();
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.empty();
        }

        @Override
        public ReactiveSeq<T> stream() {
            return ReactiveSeq.of(new Object[0]);
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
        }

        @Override
        public Try<T, X> onFail(Consumer<? super X> consumer) {
            consumer.accept(this.error);
            return this;
        }

        @Override
        public Try<T, X> onFail(Class<? extends X> t, Consumer<X> consumer) {
            if (t.isAssignableFrom(this.error.getClass())) {
                consumer.accept(this.error);
            }
            return this;
        }

        @Override
        public void throwException() {
            ExceptionSoftener.throwSoftenedException(this.error);
        }

        @Override
        public Optional<X> toFailedOptional() {
            return Optional.of(this.error);
        }

        @Override
        public Stream<X> toFailedStream() {
            return Stream.of(this.error);
        }

        @Override
        public void forEachFailed(Consumer<? super X> consumer) {
            consumer.accept(this.error);
        }

        @Override
        public <R> R visit(Function<? super T, ? extends R> success, Function<? super X, ? extends R> failure) {
            return failure.apply(this.error);
        }

        @ConstructorProperties(value={"error"})
        public Failure(X error) {
            this.error = error;
        }

        public String toString() {
            return "Try.Failure(error=" + this.error + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Failure)) {
                return false;
            }
            Failure other = (Failure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            X this$error = this.error;
            X other$error = other.error;
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Failure;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            X $error = this.error;
            result = result * 59 + ($error == null ? 0 : $error.hashCode());
            return result;
        }
    }

    public static class Success<T, X extends Throwable>
    implements Try<T, X> {
        private final T value;
        private final Class<? extends Throwable>[] classes;

        @Override
        public ListX<T> unapply() {
            return ListX.of(new Object[]{this.value});
        }

        @Override
        public Xor<X, T> toXor() {
            return Xor.primary(this.value);
        }

        @Override
        public Ior<X, T> toIor() {
            return Ior.primary(this.value);
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public AnyMValue<T> anyM() {
            return AnyM.fromTry(this);
        }

        @Override
        public AnyM<X> anyMFailure() {
            return AnyM.fromOptional(Optional.empty());
        }

        @Override
        public AnyM<T> anyMSuccess() {
            return this.anyM();
        }

        @Deprecated
        public static <T, X extends Throwable> Success<T, X> of(T value) {
            return new Success<T, X>(value, new Class[0]);
        }

        public static <T, X extends Throwable> AnyM<T> anyMOf(T value, Class<? extends Throwable>[] classes) {
            return new Success<T, X>(value, classes).anyM();
        }

        public static <T, X extends Throwable> AnyM<T> anyMOf(T value) {
            return new Success<T, X>(value, new Class[0]).anyM();
        }

        public static <T, X extends Throwable> Success<T, X> of(T value, Class<? extends Throwable>[] classes) {
            return new Success<T, X>(value, classes);
        }

        @Override
        public <R> Try<R, X> map(Function<? super T, ? extends R> fn) {
            return this.safeApply(() -> Success.of(fn.apply((T)this.get())));
        }

        private <R> R safeApply(Supplier<R> s) {
            try {
                return s.get();
            }
            catch (Throwable t) {
                return (R)Failure.of(this.orThrow(Stream.of(this.classes).filter((? super T c) -> c.isAssignableFrom(t.getClass())).map((? super T c) -> t).findFirst(), t));
            }
        }

        private Throwable orThrow(Optional<Throwable> findFirst, Throwable t) {
            if (findFirst.isPresent()) {
                return findFirst.get();
            }
            ExceptionSoftener.throwSoftenedException(t);
            return null;
        }

        @Override
        public <R> Try<R, X> flatMap(Function<? super T, ? extends Try<R, X>> fn) {
            return this.safeApply(() -> (Try)fn.apply((T)this.get()));
        }

        @Override
        public Maybe<T> filter(Predicate<? super T> p) {
            if (p.test(this.value)) {
                return Maybe.of(this.get());
            }
            return Maybe.none();
        }

        @Override
        public Success<T, X> recover(Function<? super X, ? extends T> fn) {
            return this;
        }

        @Override
        public Success<T, X> recoverWith(Function<? super X, ? extends Success<T, X>> fn) {
            return this;
        }

        @Override
        public Success<T, X> recoverFor(Class<? extends X> t, Function<? super X, ? extends T> fn) {
            return this;
        }

        @Override
        public Success<T, X> recoverWithFor(Class<? extends X> t, Function<? super X, ? extends Success<T, X>> fn) {
            return this;
        }

        @Override
        public Try<T, X> flatten() {
            if (this.value instanceof Try) {
                return ((Try)this.value).flatten();
            }
            return this;
        }

        @Override
        public T orElse(T value) {
            return this.get();
        }

        @Override
        public X failureGet() {
            throw new NoSuchElementException("Can't call failureGet() on an instance of Try.Success");
        }

        @Override
        public T orElseGet(Supplier<? extends T> value) {
            return this.get();
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.of(this.value);
        }

        @Override
        public ReactiveSeq<T> stream() {
            return ReactiveSeq.of(new Object[]{this.value});
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            consumer.accept(this.value);
        }

        @Override
        public Try<T, X> onFail(Consumer<? super X> consumer) {
            return this;
        }

        @Override
        public Try<T, X> onFail(Class<? extends X> t, Consumer<X> consumer) {
            return this;
        }

        @Override
        public void throwException() {
        }

        @Override
        public Optional<X> toFailedOptional() {
            return Optional.empty();
        }

        @Override
        public Stream<X> toFailedStream() {
            return Stream.of(new Throwable[0]);
        }

        @Override
        public void forEachFailed(Consumer<? super X> consumer) {
        }

        @Override
        public <R> R visit(Function<? super T, ? extends R> success, Function<? super X, ? extends R> failure) {
            return success.apply(this.get());
        }

        @ConstructorProperties(value={"value", "classes"})
        public Success(T value, Class<? extends Throwable>[] classes) {
            this.value = value;
            this.classes = classes;
        }

        public String toString() {
            return "Try.Success(value=" + this.value + ", classes=" + Arrays.deepToString(this.classes) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Success)) {
                return false;
            }
            Success other = (Success)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$value = this.value;
            T other$value = other.value;
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            return Arrays.deepEquals(this.classes, other.classes);
        }

        protected boolean canEqual(Object other) {
            return other instanceof Success;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $value = this.value;
            result = result * 59 + ($value == null ? 0 : $value.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.classes);
            return result;
        }
    }

    public static interface CheckedRunnable<X extends Throwable> {
        public void run() throws X;
    }

    public static interface CheckedConsumer<T, X extends Throwable> {
        public void accept(T var1) throws X;
    }

    public static interface CheckedSupplier<T, X extends Throwable> {
        public T get() throws X;
    }

    public static interface CheckedFunction<T, R, X extends Throwable> {
        public R apply(T var1) throws X;
    }

    public static interface AndFinally<T, V, X extends Throwable> {
        public Try<T, X> andFinally(CheckedConsumer<V, X> var1);

        public Try<T, X> close();
    }

    public static interface TryCatch<V, X extends Throwable> {
        public <T> Try<T, X> tryWithResources(CheckedFunction<V, T, X> var1);

        public <T> AndFinally<T, V, X> tryThis(CheckedFunction<V, T, X> var1);
    }

    public static interface Init<X extends Throwable> {
        public <V> TryCatch<V, X> init(CheckedSupplier<V, X> var1);

        public Try<Void, X> run(CheckedRunnable<X> var1);

        public <V> Try<V, X> tryThis(CheckedSupplier<V, X> var1);
    }

    public static class MyFinallyBlock<T, V, X extends Throwable>
    implements AndFinally<T, V, X> {
        private final Class<X>[] classes;
        private final CheckedSupplier<V, X> inputSupplier;
        private final CheckedFunction<V, T, X> catchBlock;

        private void invokeClose(Object in) {
            if (in instanceof Closeable) {
                this.invokeCloseableClose((Closeable)in);
            } else if (in instanceof AutoCloseable) {
                this.invokeAutocloseableClose((AutoCloseable)in);
            } else if (in instanceof Iterable) {
                this.invokeClose((Iterable)in);
            } else {
                this._invokeClose(in);
            }
        }

        private void invokeClose(Iterable in) {
            for (Object next : in) {
                this.invokeClose(next);
            }
        }

        private void invokeCloseableClose(Closeable in) {
            Try.runWithCatch(() -> in.close(), new Class[0]);
        }

        private void invokeAutocloseableClose(AutoCloseable in) {
            Try.runWithCatch(() -> in.close(), new Class[0]);
        }

        private void _invokeClose(Object in) {
            Try.withCatch(() -> in.getClass().getMethod("close", new Class[0]), new Class[0]).filter(m -> m != null).flatMap(m -> Try.withCatch(() -> m.invoke(in, new Object[0]), new Class[0]).filter(o -> o != null));
        }

        @Override
        public Try<T, X> close() {
            return this.andFinally(in -> this.invokeClose(in));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Try<T, X> andFinally(CheckedConsumer<V, X> finallyBlock) {
            Try input = Try.withCatch(() -> this.inputSupplier.get(), this.classes);
            Try result = null;
            try {
                result = input.flatMap(in -> Try.withCatch(() -> this.catchBlock.apply(in), this.classes));
            }
            finally {
                Try finalResult = result.flatMap(i -> Try.runWithCatch(() -> finallyBlock.accept(this.inputSupplier.get()), this.classes));
                if (finalResult instanceof Failure) {
                    return finalResult;
                }
            }
            return result;
        }

        @ConstructorProperties(value={"classes", "inputSupplier", "catchBlock"})
        public MyFinallyBlock(Class<X>[] classes, CheckedSupplier<V, X> inputSupplier, CheckedFunction<V, T, X> catchBlock) {
            this.classes = classes;
            this.inputSupplier = inputSupplier;
            this.catchBlock = catchBlock;
        }
    }

    public static class MyTryCatch<V, X extends Throwable>
    implements TryCatch<V, X> {
        private final Class<X>[] classes;
        private final CheckedSupplier<V, X> inputSupplier;

        @Override
        public <T> AndFinally<T, V, X> tryThis(CheckedFunction<V, T, X> catchBlock) {
            return new MyFinallyBlock<T, V, X>(this.classes, this.inputSupplier, catchBlock);
        }

        @Override
        public <T> Try<T, X> tryWithResources(CheckedFunction<V, T, X> catchBlock) {
            return new MyFinallyBlock<T, V, X>(this.classes, this.inputSupplier, catchBlock).close();
        }

        @ConstructorProperties(value={"classes", "inputSupplier"})
        public MyTryCatch(Class<X>[] classes, CheckedSupplier<V, X> inputSupplier) {
            this.classes = classes;
            this.inputSupplier = inputSupplier;
        }
    }

    public static class MyInit<X extends Throwable>
    implements Init<X> {
        private final Class<X>[] classes;

        @Override
        public <V> TryCatch<V, X> init(CheckedSupplier<V, X> input) {
            return new MyTryCatch<V, X>(this.classes, input);
        }

        @Override
        public Try<Void, X> run(CheckedRunnable<X> input) {
            return Try.runWithCatch(input, this.classes);
        }

        @Override
        public <V> Try<V, X> tryThis(CheckedSupplier<V, X> input) {
            return Try.withCatch(input, this.classes);
        }

        @ConstructorProperties(value={"classes"})
        public MyInit(Class<X>[] classes) {
            this.classes = classes;
        }
    }
}

