/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.types.Value;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;

@FunctionalInterface
public interface Trampoline<T>
extends Supplier<T>,
Value<T> {
    default public Trampoline<T> bounce() {
        return this;
    }

    default public T result() {
        return this.get();
    }

    @Override
    public T get();

    @Override
    default public Iterator<T> iterator() {
        return Arrays.asList(this.result()).iterator();
    }

    default public boolean complete() {
        return true;
    }

    public static <T> Trampoline<T> done(T result) {
        return () -> result;
    }

    public static <T> Trampoline<T> more(final Trampoline<Trampoline<T>> trampoline) {
        return new Trampoline<T>(){

            @Override
            public boolean complete() {
                return false;
            }

            @Override
            public Trampoline<T> bounce() {
                return (Trampoline)trampoline.result();
            }

            @Override
            public T get() {
                return this.trampoline(this);
            }

            T trampoline(Trampoline<T> trampoline2) {
                return Stream.iterate(trampoline2, Trampoline::bounce).filter(Trampoline::complete).findFirst().get().result();
            }
        };
    }
}

