/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Reader;
import com.aol.cyclops.control.Try;
import com.aol.cyclops.data.MutableInt;
import com.aol.cyclops.internal.invokedynamic.CheckedTriFunction;
import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.cyclops.util.function.Cacheable;
import com.aol.cyclops.util.function.Curry;
import com.aol.cyclops.util.function.CurryVariance;
import com.aol.cyclops.util.function.Memoize;
import com.aol.cyclops.util.function.PartialApplicator;
import com.aol.cyclops.util.function.QuadConsumer;
import com.aol.cyclops.util.function.TriConsumer;
import com.aol.cyclops.util.function.TriFunction;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooq.lambda.fi.util.function.CheckedBiConsumer;
import org.jooq.lambda.fi.util.function.CheckedBiFunction;
import org.jooq.lambda.fi.util.function.CheckedConsumer;
import org.jooq.lambda.fi.util.function.CheckedFunction;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;

public class FluentFunctions {
    public static <R> FluentSupplier<R> ofChecked(CheckedSupplier<R> supplier) {
        return FluentFunctions.of(ExceptionSoftener.softenSupplier(supplier));
    }

    public static <R> FluentSupplier<R> of(Supplier<R> supplier) {
        return new FluentSupplier<R>(supplier);
    }

    public static <T, R> FluentFunction<T, R> ofChecked(CheckedFunction<T, R> fn) {
        return FluentFunctions.of(ExceptionSoftener.softenFunction(fn));
    }

    public static <T, R> FluentFunction<T, R> of(Function<T, R> fn) {
        return new FluentFunction<T, R>(fn);
    }

    public static <T1, T2, R> FluentBiFunction<T1, T2, R> ofChecked(CheckedBiFunction<T1, T2, R> fn) {
        return FluentFunctions.of(ExceptionSoftener.softenBiFunction(fn));
    }

    public static <T1, T2, R> FluentBiFunction<T1, T2, R> of(BiFunction<T1, T2, R> fn) {
        return new FluentBiFunction<T1, T2, R>(fn);
    }

    public static <T1, T2, T3, R> FluentTriFunction<T1, T2, T3, R> ofChecked(CheckedTriFunction<T1, T2, T3, R> fn) {
        return new FluentTriFunction<T1, T2, T3, R>(FluentFunctions.softenTriFunction(fn));
    }

    public static <T1, T2, T3, R> FluentTriFunction<T1, T2, T3, R> of(TriFunction<T1, T2, T3, R> fn) {
        return new FluentTriFunction<T1, T2, T3, R>(fn);
    }

    public static <T> FluentFunction<T, T> expression(Consumer<? super T> action) {
        return FluentFunctions.of((T t) -> {
            action.accept(t);
            return t;
        });
    }

    public static <T> FluentFunction<T, T> checkedExpression(CheckedConsumer<T> action) {
        Consumer toUse = ExceptionSoftener.softenConsumer(action);
        return FluentFunctions.of((T t) -> {
            toUse.accept(t);
            return t;
        });
    }

    public static <T1, T2> FluentBiFunction<T1, T2, Tuple2<T1, T2>> expression(BiConsumer<? super T1, ? super T2> action) {
        return FluentFunctions.of((T1 t1, T2 t2) -> {
            action.accept((Object)t1, (Object)t2);
            return Tuple.tuple((Object)t1, (Object)t2);
        });
    }

    public static <T1, T2> FluentBiFunction<T1, T2, Tuple2<T1, T2>> checkedExpression(CheckedBiConsumer<T1, T2> action) {
        BiConsumer toUse = ExceptionSoftener.softenBiConsumer(action);
        return FluentFunctions.of((T1 t1, T2 t2) -> {
            toUse.accept(t1, t2);
            return Tuple.tuple((Object)t1, (Object)t2);
        });
    }

    private static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> softenTriFunction(CheckedTriFunction<T1, T2, T3, R> fn) {
        return (t1, t2, t3) -> {
            try {
                return fn.apply(t1, t2, t3);
            }
            catch (Throwable e) {
                throw ExceptionSoftener.throwSoftenedException(e);
            }
        };
    }

    public static class Advice3<T1, T2, T3, R> {
        public final T1 param1;
        public final T2 param2;
        public final T3 param3;
        private final TriFunction<T1, T2, T3, R> fn;

        public R proceed() {
            return this.fn.apply(this.param1, this.param2, this.param3);
        }

        public R proceed(T1 param1, T2 param2, T3 param3) {
            return this.fn.apply(param1, param2, param3);
        }

        public R proceed1(T1 param) {
            return this.fn.apply(param, this.param2, this.param3);
        }

        public R proceed2(T2 param) {
            return this.fn.apply(this.param1, param, this.param3);
        }

        public R proceed3(T3 param) {
            return this.fn.apply(this.param1, this.param2, param);
        }

        @ConstructorProperties(value={"param1", "param2", "param3", "fn"})
        public Advice3(T1 param1, T2 param2, T3 param3, TriFunction<T1, T2, T3, R> fn) {
            this.param1 = param1;
            this.param2 = param2;
            this.param3 = param3;
            this.fn = fn;
        }
    }

    public static class Advice2<T1, T2, R> {
        public final T1 param1;
        public final T2 param2;
        private final BiFunction<T1, T2, R> fn;

        public R proceed() {
            return this.fn.apply(this.param1, this.param2);
        }

        public R proceed(T1 param1, T2 param2) {
            return this.fn.apply(param1, param2);
        }

        public R proceed1(T1 param) {
            return this.fn.apply(param, this.param2);
        }

        public R proceed2(T2 param) {
            return this.fn.apply(this.param1, param);
        }

        @ConstructorProperties(value={"param1", "param2", "fn"})
        public Advice2(T1 param1, T2 param2, BiFunction<T1, T2, R> fn) {
            this.param1 = param1;
            this.param2 = param2;
            this.fn = fn;
        }
    }

    public static class Advice1<T, R> {
        public final T param;
        private final Function<T, R> fn;

        public R proceed() {
            return this.fn.apply(this.param);
        }

        public R proceed(T param) {
            return this.fn.apply(param);
        }

        @ConstructorProperties(value={"param", "fn"})
        public Advice1(T param, Function<T, R> fn) {
            this.param = param;
            this.fn = fn;
        }
    }

    public static class Advice0<R> {
        private final Supplier<R> fn;

        public R proceed() {
            return this.fn.get();
        }

        @ConstructorProperties(value={"fn"})
        public Advice0(Supplier<R> fn) {
            this.fn = fn;
        }
    }

    public static class FluentTriFunction<T1, T2, T3, R> {
        private final TriFunction<T1, T2, T3, R> fn;
        private final String name;

        public FluentTriFunction(TriFunction<T1, T2, T3, R> fn) {
            this.name = null;
            this.fn = fn;
        }

        public R apply(T1 t1, T2 t2, T3 t3) {
            return this.fn.apply(t1, t2, t3);
        }

        public FluentTriFunction<T1, T2, T3, R> before(TriConsumer<T1, T2, T3> action) {
            return this.withFn((t1, t2, t3) -> {
                action.accept(t1, t2, t3);
                return this.fn.apply(t1, t2, t3);
            });
        }

        public FluentTriFunction<T1, T2, T3, R> after(QuadConsumer<T1, T2, T3, R> action) {
            return this.withFn((t1, t2, t3) -> {
                R result = this.fn.apply(t1, t2, t3);
                action.accept(t1, t2, t3, result);
                return result;
            });
        }

        public FluentTriFunction<T1, T2, T3, R> around(Function<Advice3<T1, T2, T3, R>, R> around) {
            return this.withFn((t1, t2, t3) -> around.apply(new Advice3<Object, Object, Object, R>(t1, t2, t3, this.fn)));
        }

        public FluentBiFunction<T2, T3, R> partiallyApply(T1 param) {
            return new FluentBiFunction<T2, T3, R>(PartialApplicator.partial3(param, this.fn));
        }

        public FluentFunction<T3, R> partiallyApply(T1 param1, T2 param2) {
            return new FluentFunction<T3, R>(PartialApplicator.partial3(param1, param2, this.fn));
        }

        public FluentSupplier<R> partiallyApply(T1 param1, T2 param2, T3 param3) {
            return new FluentSupplier<R>(PartialApplicator.partial3(param1, param2, param3, this.fn));
        }

        public FluentFunction<T1, Function<T2, Function<T3, R>>> curry() {
            return new FluentFunction<T1, Function<T2, Function<T3, R>>>(Curry.curry3(this.fn));
        }

        public FluentTriFunction<T1, T2, T3, R> memoize() {
            return this.withFn(Memoize.memoizeTriFunction(this.fn));
        }

        public FluentTriFunction<T1, T2, T3, R> memoize(Cacheable<R> cache) {
            return this.withFn(Memoize.memoizeTriFunction(this.fn));
        }

        public FluentTriFunction<T1, T2, T3, R> name(String name) {
            return this.withName(name);
        }

        private String handleNameStart() {
            return this.name == null ? "(fluent-function-" : "(" + this.name + "-";
        }

        private String handleNameEnd() {
            return ")";
        }

        public FluentTriFunction<T1, T2, T3, R> log(Consumer<String> logger, Consumer<Throwable> error) {
            return FluentFunctions.of((t1, t2, t3) -> {
                try {
                    logger.accept(this.handleNameStart() + "Parameters[" + t1 + "," + t2 + "," + t3 + "]" + this.handleNameEnd());
                    R result = this.fn.apply(t1, t2, t3);
                    logger.accept(this.handleNameStart() + "Result[" + result + "]" + this.handleNameEnd());
                    return result;
                }
                catch (Throwable t) {
                    error.accept(t);
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentTriFunction<T1, T2, T3, R> println() {
            return this.log(s -> System.out.println((String)s), t -> t.printStackTrace());
        }

        public <X extends Throwable> FluentTriFunction<T1, T2, T3, R> recover(Class<X> type, TriFunction<T1, T2, T3, R> onError) {
            return FluentFunctions.of((t1, t2, t3) -> {
                try {
                    return this.fn.apply(t1, t2, t3);
                }
                catch (Throwable t) {
                    if (type.isAssignableFrom(t.getClass())) {
                        return onError.apply(t1, t2, t3);
                    }
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentTriFunction<T1, T2, T3, R> retry(int times, int backoffStartTime) {
            return FluentFunctions.of((t1, t2, t3) -> {
                int count = times;
                MutableInt sleep = MutableInt.of(backoffStartTime);
                Throwable exception = null;
                while (count-- > 0) {
                    try {
                        return this.fn.apply(t1, t2, t3);
                    }
                    catch (Throwable e) {
                        exception = e;
                        ExceptionSoftener.softenRunnable(() -> Thread.sleep(sleep.get().intValue()));
                        sleep.mutate(s -> s * 2);
                    }
                }
                throw ExceptionSoftener.throwSoftenedException(exception);
            });
        }

        public <R1> FluentTriFunction<T1, T2, T3, R1> matches(Function<Matchable.CheckValue1<R, R1>, Matchable.CheckValue1<R, R1>> case1, Supplier<? extends R1> otherwise) {
            return FluentFunctions.of((t1, t2, t3) -> Matchable.of(this.fn.apply(t1, t2, t3)).matches(case1, otherwise).get());
        }

        public ReactiveSeq<R> iterate(T1 seed1, T2 seed2, T3 seed3, Function<R, Tuple3<T1, T2, T3>> mapToType) {
            return ReactiveSeq.iterate(this.fn.apply(seed1, seed2, seed3), t -> {
                Tuple3 tuple = (Tuple3)mapToType.apply(t);
                return this.fn.apply(tuple.v1, tuple.v2, tuple.v3);
            });
        }

        public ReactiveSeq<R> generate(T1 input1, T2 input2, T3 input3) {
            return ReactiveSeq.generate(() -> this.fn.apply(input1, input2, input3));
        }

        public FluentTriFunction<Optional<T1>, Optional<T2>, Optional<T3>, Optional<R>> lift() {
            return new FluentTriFunction<Optional<T1>, Optional<T2>, Optional<T3>, Optional<R>>((opt1, opt2, opt3) -> opt1.flatMap(t1 -> opt2.flatMap(t2 -> opt3.map(t3 -> this.fn.apply(t1, t2, t3)))));
        }

        public <X extends Throwable> FluentTriFunction<T1, T2, T3, Try<R, X>> liftTry(Class<X> ... classes) {
            return FluentFunctions.of((t1, t2, t3) -> Try.withCatch(() -> this.fn.apply(t1, t2, t3), classes));
        }

        public FluentTriFunction<AnyM<T1>, AnyM<T2>, AnyM<T3>, AnyM<R>> liftM() {
            return FluentFunctions.of(AnyM.liftM3Cyclops(this.fn));
        }

        public FluentTriFunction<T1, T2, T3, CompletableFuture<R>> liftAsync(Executor ex) {
            return FluentFunctions.of((t1, t2, t3) -> CompletableFuture.supplyAsync(() -> this.fn.apply(t1, t2, t3), ex));
        }

        public CompletableFuture<FluentTriFunction<T1, T2, T3, R>> async(Executor ex) {
            return CompletableFuture.supplyAsync(() -> FluentFunctions.of(this.fn), ex);
        }

        public <R2> FluentTriFunction<T1, T2, T3, R2> andThen(Function<? super R, ? extends R2> after) {
            Objects.requireNonNull(after);
            return FluentFunctions.of((t1, t2, t3) -> after.apply((R)this.apply(t1, t2, t3)));
        }

        private FluentTriFunction<T1, T2, T3, R> withFn(TriFunction<T1, T2, T3, R> fn) {
            return this.fn == fn ? this : new FluentTriFunction<T1, T2, T3, R>(fn, this.name);
        }

        private FluentTriFunction<T1, T2, T3, R> withName(String name) {
            return this.name == name ? this : new FluentTriFunction<T1, T2, T3, R>(this.fn, name);
        }

        @ConstructorProperties(value={"fn", "name"})
        public FluentTriFunction(TriFunction<T1, T2, T3, R> fn, String name) {
            this.fn = fn;
            this.name = name;
        }
    }

    public static class FluentBiFunction<T1, T2, R>
    implements BiFunction<T1, T2, R> {
        BiFunction<T1, T2, R> fn;
        private final String name;

        public FluentBiFunction(BiFunction<T1, T2, R> fn) {
            this.name = null;
            this.fn = fn;
        }

        @Override
        public R apply(T1 t1, T2 t2) {
            return this.fn.apply(t1, t2);
        }

        public FluentBiFunction<T1, T2, R> before(BiConsumer<T1, T2> action) {
            return this.withFn((t1, t2) -> {
                action.accept(t1, t2);
                return this.fn.apply(t1, t2);
            });
        }

        public FluentBiFunction<T1, T2, R> after(TriConsumer<T1, T2, R> action) {
            return this.withFn((t1, t2) -> {
                R result = this.fn.apply(t1, t2);
                action.accept(t1, t2, result);
                return result;
            });
        }

        public FluentBiFunction<T1, T2, R> around(Function<Advice2<T1, T2, R>, R> around) {
            return this.withFn((t1, t2) -> around.apply(new Advice2<Object, Object, R>(t1, t2, this.fn)));
        }

        public FluentFunction<T2, R> partiallyApply(T1 param) {
            return new FluentFunction<T2, R>(PartialApplicator.partial2(param, this.fn));
        }

        public FluentSupplier<R> partiallyApply(T1 param1, T2 param2) {
            return new FluentSupplier<R>(PartialApplicator.partial2(param1, param2, this.fn));
        }

        public FluentFunction<T1, Function<T2, R>> curry() {
            return new FluentFunction<T1, Function<T2, R>>(CurryVariance.curry2(this.fn));
        }

        public FluentBiFunction<T1, T2, R> memoize() {
            return this.withFn(Memoize.memoizeBiFunction(this.fn));
        }

        public FluentBiFunction<T1, T2, R> memoize(Cacheable<R> cache) {
            return this.withFn(Memoize.memoizeBiFunction(this.fn));
        }

        public FluentBiFunction<T1, T2, R> name(String name) {
            return this.withName(name);
        }

        private String handleNameStart() {
            return this.name == null ? "(fluent-function-" : "(" + this.name + "-";
        }

        private String handleNameEnd() {
            return ")";
        }

        public FluentBiFunction<T1, T2, R> log(Consumer<String> logger, Consumer<Throwable> error) {
            return FluentFunctions.of((t1, t2) -> {
                try {
                    logger.accept(this.handleNameStart() + "Parameters[" + t1 + "," + t2 + "]" + this.handleNameEnd());
                    R result = this.fn.apply(t1, t2);
                    logger.accept(this.handleNameStart() + "Result[" + result + "]" + this.handleNameEnd());
                    return result;
                }
                catch (Throwable t) {
                    error.accept(t);
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentBiFunction<T1, T2, R> println() {
            return this.log(s -> System.out.println((String)s), t -> t.printStackTrace());
        }

        public <X extends Throwable> FluentBiFunction<T1, T2, R> recover(Class<X> type, BiFunction<T1, T2, R> onError) {
            return FluentFunctions.of((t1, t2) -> {
                try {
                    return this.fn.apply(t1, t2);
                }
                catch (Throwable t) {
                    if (type.isAssignableFrom(t.getClass())) {
                        return onError.apply(t1, t2);
                    }
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentBiFunction<T1, T2, R> retry(int times, int backoffStartTime) {
            return FluentFunctions.of((t1, t2) -> {
                int count = times;
                MutableInt sleep = MutableInt.of(backoffStartTime);
                Throwable exception = null;
                while (count-- > 0) {
                    try {
                        return this.fn.apply(t1, t2);
                    }
                    catch (Throwable e) {
                        exception = e;
                        ExceptionSoftener.softenRunnable(() -> Thread.sleep(sleep.get().intValue()));
                        sleep.mutate(s -> s * 2);
                    }
                }
                throw ExceptionSoftener.throwSoftenedException(exception);
            });
        }

        public <R1> FluentBiFunction<T1, T2, R1> matches(Function<Matchable.CheckValue1<R, R1>, Matchable.CheckValue1<R, R1>> case1, Supplier<? extends R1> otherwise) {
            return FluentFunctions.of((t1, t2) -> Matchable.of(this.fn.apply(t1, t2)).matches(case1, otherwise).get());
        }

        public ReactiveSeq<R> iterate(T1 seed1, T2 seed2, Function<R, Tuple2<T1, T2>> mapToTypeAndSplit) {
            return ReactiveSeq.iterate(this.fn.apply(seed1, seed2), t -> {
                Tuple2 tuple = (Tuple2)mapToTypeAndSplit.apply(t);
                return this.fn.apply(tuple.v1, tuple.v2);
            });
        }

        public ReactiveSeq<R> generate(T1 input1, T2 input2) {
            return ReactiveSeq.generate(() -> this.fn.apply(input1, input2));
        }

        public FluentBiFunction<Optional<T1>, Optional<T2>, Optional<R>> lift() {
            return new FluentBiFunction<Optional<T1>, Optional<T2>, Optional<R>>((opt1, opt2) -> opt1.flatMap(t1 -> opt2.map(t2 -> this.fn.apply(t1, t2))));
        }

        public <X extends Throwable> FluentBiFunction<T1, T2, Try<R, X>> liftTry(Class<X> ... classes) {
            return FluentFunctions.of((t1, t2) -> Try.withCatch(() -> this.fn.apply(t1, t2), classes));
        }

        public FluentBiFunction<AnyM<T1>, AnyM<T2>, AnyM<R>> liftM() {
            return FluentFunctions.of(AnyM.liftM2(this.fn));
        }

        public FluentBiFunction<T1, T2, CompletableFuture<R>> liftAsync(Executor ex) {
            return FluentFunctions.of((t1, t2) -> CompletableFuture.supplyAsync(() -> this.fn.apply(t1, t2), ex));
        }

        public CompletableFuture<FluentBiFunction<T1, T2, R>> async(Executor ex) {
            return CompletableFuture.supplyAsync(() -> FluentFunctions.of(this.fn), ex);
        }

        @Override
        public <V> FluentBiFunction<T1, T2, V> andThen(Function<? super R, ? extends V> after) {
            return FluentFunctions.of(BiFunction.super.andThen(after));
        }

        private FluentBiFunction<T1, T2, R> withFn(BiFunction<T1, T2, R> fn) {
            return this.fn == fn ? this : new FluentBiFunction<T1, T2, R>(fn, this.name);
        }

        private FluentBiFunction<T1, T2, R> withName(String name) {
            return this.name == name ? this : new FluentBiFunction<T1, T2, R>(this.fn, name);
        }

        @ConstructorProperties(value={"fn", "name"})
        public FluentBiFunction(BiFunction<T1, T2, R> fn, String name) {
            this.fn = fn;
            this.name = name;
        }
    }

    public static class FluentFunction<T, R>
    implements Function<T, R>,
    Reader<T, R> {
        private final Function<T, R> fn;
        private final String name;

        public FluentFunction(Function<T, R> fn) {
            this.name = null;
            this.fn = fn;
        }

        @Override
        public R apply(T t) {
            return this.fn.apply(t);
        }

        @Override
        public <R1> FluentFunction<T, R1> map(Function<? super R, ? extends R1> f2) {
            return FluentFunctions.of(this.fn.andThen(f2));
        }

        @Override
        public <R1> FluentFunction<T, R1> flatMap(Function<? super R, ? extends Reader<T, R1>> f) {
            return FluentFunctions.of(a -> ((Reader)f.apply((R)this.fn.apply(a))).apply(a));
        }

        public FluentFunction<T, R> before(Consumer<T> action) {
            return this.withFn(t -> {
                action.accept(t);
                return this.fn.apply(t);
            });
        }

        public FluentFunction<T, R> after(BiConsumer<T, R> action) {
            return this.withFn(t -> {
                R result = this.fn.apply(t);
                action.accept(t, result);
                return result;
            });
        }

        public FluentFunction<T, R> around(Function<Advice1<T, R>, R> around) {
            return this.withFn(t -> around.apply(new Advice1<Object, R>(t, this.fn)));
        }

        public FluentSupplier<R> partiallyApply(T param) {
            return new FluentSupplier<R>(PartialApplicator.partial(param, this.fn));
        }

        public FluentFunction<T, R> memoize() {
            return this.withFn(Memoize.memoizeFunction(this.fn));
        }

        public FluentFunction<T, R> memoize(Cacheable<R> cache) {
            return this.withFn(Memoize.memoizeFunction(this.fn));
        }

        public FluentFunction<T, R> name(String name) {
            return this.withName(name);
        }

        private String handleNameStart() {
            return this.name == null ? "(fluent-function-" : "(" + this.name + "-";
        }

        private String handleNameEnd() {
            return ")";
        }

        public FluentFunction<T, R> log(Consumer<String> logger, Consumer<Throwable> error) {
            return FluentFunctions.of(t1 -> {
                try {
                    logger.accept(this.handleNameStart() + "Parameter[" + t1 + "]" + this.handleNameEnd());
                    R result = this.fn.apply(t1);
                    logger.accept(this.handleNameStart() + "Result[" + result + "]" + this.handleNameEnd());
                    return result;
                }
                catch (Throwable t) {
                    error.accept(t);
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentFunction<T, R> println() {
            return this.log(s -> System.out.println((String)s), t -> t.printStackTrace());
        }

        public <X extends Throwable> FluentFunction<T, R> recover(Class<X> type, Function<T, R> onError) {
            return FluentFunctions.of(t1 -> {
                try {
                    return this.fn.apply(t1);
                }
                catch (Throwable t) {
                    if (type.isAssignableFrom(t.getClass())) {
                        return onError.apply(t1);
                    }
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentFunction<T, R> retry(int times, int backoffStartTime) {
            return FluentFunctions.of(t -> {
                int count = times;
                MutableInt sleep = MutableInt.of(backoffStartTime);
                Throwable exception = null;
                while (count-- > 0) {
                    try {
                        return this.fn.apply(t);
                    }
                    catch (Throwable e) {
                        exception = e;
                        ExceptionSoftener.softenRunnable(() -> Thread.sleep(sleep.get().intValue()));
                        sleep.mutate(s -> s * 2);
                    }
                }
                throw ExceptionSoftener.throwSoftenedException(exception);
            });
        }

        public <R1> FluentFunction<T, R1> matches(Function<Matchable.CheckValue1<R, R1>, Matchable.CheckValue1<R, R1>> case1, Supplier<? extends R1> otherwise) {
            return FluentFunctions.of(t -> Matchable.of(this.fn.apply(t)).matches(case1, otherwise).get());
        }

        public ReactiveSeq<R> iterate(T seed, Function<R, T> mapToType) {
            return ReactiveSeq.iterate(this.fn.apply(seed), t -> this.fn.compose(mapToType).apply(t));
        }

        public ReactiveSeq<R> generate(T input) {
            return ReactiveSeq.generate(() -> this.fn.apply(input));
        }

        public FluentFunction<Optional<T>, Optional<R>> lift() {
            return new FluentFunction<Optional<T>, Optional<R>>(opt -> opt.map((? super T t) -> this.fn.apply(t)));
        }

        public <X extends Throwable> FluentFunction<T, Try<R, X>> liftTry(Class<X> ... classes) {
            return FluentFunctions.of(t1 -> Try.withCatch(() -> this.fn.apply(t1), classes));
        }

        public FluentFunction<AnyM<T>, AnyM<R>> liftM() {
            return FluentFunctions.of(AnyM.liftM(this.fn));
        }

        public FluentFunction<T, CompletableFuture<R>> liftAsync(Executor ex) {
            return FluentFunctions.of(t -> CompletableFuture.supplyAsync(() -> this.fn.apply(t), ex));
        }

        public CompletableFuture<FluentFunction<T, R>> async(Executor ex) {
            return CompletableFuture.supplyAsync(() -> FluentFunctions.of(this.fn), ex);
        }

        @Override
        public <V> Function<V, R> compose(Function<? super V, ? extends T> before) {
            return FluentFunctions.of(Reader.super.compose(before));
        }

        @Override
        public <V> Function<T, V> andThen(Function<? super R, ? extends V> after) {
            return FluentFunctions.of(Reader.super.andThen(after));
        }

        private FluentFunction<T, R> withFn(Function<T, R> fn) {
            return this.fn == fn ? this : new FluentFunction<T, R>(fn, this.name);
        }

        private FluentFunction<T, R> withName(String name) {
            return this.name == name ? this : new FluentFunction<T, R>(this.fn, name);
        }

        @ConstructorProperties(value={"fn", "name"})
        public FluentFunction(Function<T, R> fn, String name) {
            this.fn = fn;
            this.name = name;
        }
    }

    public static class FluentSupplier<R>
    implements Supplier<R> {
        private final Supplier<R> fn;
        private final String name;

        public FluentSupplier(Supplier<R> fn) {
            this.name = null;
            this.fn = fn;
        }

        @Override
        public R get() {
            return this.fn.get();
        }

        public FluentSupplier<R> before(Runnable r) {
            return this.withFn(() -> {
                r.run();
                return this.fn.get();
            });
        }

        public FluentSupplier<R> after(Consumer<R> action) {
            return this.withFn(() -> {
                R result = this.fn.get();
                action.accept(result);
                return result;
            });
        }

        public FluentSupplier<R> around(Function<Advice0<R>, R> around) {
            return this.withFn(() -> around.apply(new Advice0<R>(this.fn)));
        }

        public FluentSupplier<R> memoize() {
            return this.withFn(Memoize.memoizeSupplier(this.fn));
        }

        public FluentSupplier<R> memoize(Cacheable<R> cache) {
            return this.withFn(Memoize.memoizeSupplier(this.fn, cache));
        }

        public FluentSupplier<R> name(String name) {
            return this.withName(name);
        }

        private String handleNameStart() {
            return this.name == null ? "(fluent-supplier-" : "(" + this.name + "-";
        }

        private String handleNameEnd() {
            return ")";
        }

        public FluentSupplier<R> println() {
            return this.log(s -> System.out.println((String)s), t -> t.printStackTrace());
        }

        public FluentSupplier<R> log(Consumer<String> logger, Consumer<Throwable> error) {
            return FluentFunctions.of(() -> {
                try {
                    R result = this.fn.get();
                    logger.accept(this.handleNameStart() + "Result[" + result + "]" + this.handleNameEnd());
                    return result;
                }
                catch (Throwable t) {
                    error.accept(t);
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public <X extends Throwable> FluentSupplier<R> recover(Class<X> type, Supplier<R> onError) {
            return FluentFunctions.of(() -> {
                try {
                    return this.fn.get();
                }
                catch (Throwable t) {
                    if (type.isAssignableFrom(t.getClass())) {
                        return onError.get();
                    }
                    throw ExceptionSoftener.throwSoftenedException(t);
                }
            });
        }

        public FluentSupplier<R> retry(int times, int backoffStartTime) {
            return FluentFunctions.of(() -> {
                int count = times;
                MutableInt sleep = MutableInt.of(backoffStartTime);
                Throwable exception = null;
                while (count-- > 0) {
                    try {
                        return this.fn.get();
                    }
                    catch (Throwable e) {
                        exception = e;
                        ExceptionSoftener.softenRunnable(() -> Thread.sleep(sleep.get().intValue()));
                        sleep.mutate(s -> s * 2);
                    }
                }
                throw ExceptionSoftener.throwSoftenedException(exception);
            });
        }

        public <R1> FluentSupplier<R1> matches(Function<Matchable.CheckValue1<R, R1>, Matchable.CheckValue1<R, R1>> case1, Supplier<? extends R1> otherwise) {
            return FluentFunctions.of(() -> Matchable.of(this.fn.get()).matches(case1, otherwise).get());
        }

        public ReactiveSeq<R> generate() {
            return ReactiveSeq.generate(this.fn);
        }

        public FluentSupplier<Optional<R>> lift() {
            return new FluentSupplier<Optional<R>>(() -> Optional.ofNullable(this.fn.get()));
        }

        public <X extends Throwable> FluentSupplier<Try<R, X>> liftTry(Class<X> ... classes) {
            return FluentFunctions.of(() -> Try.withCatch(() -> this.fn.get(), classes));
        }

        public FluentSupplier<AnyM<R>> liftM() {
            return new FluentSupplier<AnyM<R>>(() -> AnyM.ofNullable(this.fn.get()));
        }

        public FluentSupplier<CompletableFuture<R>> liftAsync(Executor ex) {
            return FluentFunctions.of(() -> CompletableFuture.supplyAsync(this.fn, ex));
        }

        public CompletableFuture<FluentSupplier<R>> async(Executor ex) {
            return CompletableFuture.supplyAsync(() -> FluentFunctions.of(this.fn), ex);
        }

        private FluentSupplier<R> withFn(Supplier<R> fn) {
            return this.fn == fn ? this : new FluentSupplier<R>(fn, this.name);
        }

        private FluentSupplier<R> withName(String name) {
            return this.name == name ? this : new FluentSupplier<R>(this.fn, name);
        }

        @ConstructorProperties(value={"fn", "name"})
        public FluentSupplier(Supplier<R> fn, String name) {
            this.fn = fn;
            this.name = name;
        }
    }
}

