/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.anyM.AnyMValue;
import com.aol.cyclops.types.applicative.Applicativable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface FeatureToggle<F>
extends Supplier<F>,
MonadicValue<F>,
Filterable<F>,
Functor<F>,
Applicativable<F>,
Matchable.ValueAndOptionalMatcher<F> {
    public boolean isEnabled();

    public boolean isDisabled();

    public static <T> FeatureToggle<T> narrow(FeatureToggle<? extends T> toggle) {
        return toggle;
    }

    @Override
    default public <U> FeatureToggle<U> cast(Class<? extends U> type) {
        return (FeatureToggle)Applicativable.super.cast(type);
    }

    @Override
    default public <R> FeatureToggle<R> trampoline(Function<? super F, ? extends Trampoline<? extends R>> mapper) {
        return (FeatureToggle)Applicativable.super.trampoline(mapper);
    }

    @Override
    default public <U> FeatureToggle<U> ofType(Class<? extends U> type) {
        return (FeatureToggle)Filterable.super.ofType(type);
    }

    @Override
    default public FeatureToggle<F> filterNot(Predicate<? super F> fn) {
        return (FeatureToggle)Filterable.super.filterNot(fn);
    }

    @Override
    default public FeatureToggle<F> notNull() {
        return (FeatureToggle)Filterable.super.notNull();
    }

    @Override
    default public <T> FeatureToggle<T> unit(T unit) {
        return FeatureToggle.enable(unit);
    }

    public <R> R visit(Function<? super F, ? extends R> var1, Function<? super F, ? extends R> var2);

    @Override
    default public <R> FeatureToggle<R> patternMatch(Function<Matchable.CheckValue1<F, R>, Matchable.CheckValue1<F, R>> case1, Supplier<? extends R> otherwise) {
        return (FeatureToggle)Applicativable.super.patternMatch(case1, otherwise);
    }

    @Override
    default public FeatureToggle<F> toFeatureToggle() {
        return this;
    }

    @Override
    public AnyMValue<F> anyM();

    public AnyM<F> anyMDisabled();

    public AnyM<F> anyMEnabled();

    @Override
    public F get();

    public static <F> Enabled<F> enable(F f) {
        return new Enabled<F>(f);
    }

    public static <F> Disabled<F> disable(F f) {
        return new Disabled<F>(f);
    }

    public static <F> FeatureToggle<F> from(FeatureToggle<F> from, F f) {
        if (from.isEnabled()) {
            return FeatureToggle.enable(f);
        }
        return FeatureToggle.disable(f);
    }

    @Override
    default public FeatureToggle<F> peek(Consumer<? super F> consumer) {
        if (this.isEnabled()) {
            consumer.accept(this.get());
        }
        return this;
    }

    default public <X> FeatureToggle<X> flatMap(Function<? super F, ? extends MonadicValue<? extends X>> map) {
        if (this.isDisabled()) {
            return this;
        }
        return FeatureToggle.narrow(map.apply(this.get()).toFeatureToggle());
    }

    @Override
    default public <X> FeatureToggle<X> map(Function<? super F, ? extends X> map) {
        if (this.isDisabled()) {
            return this;
        }
        return FeatureToggle.enable(map.apply(this.get()));
    }

    @Override
    default public FeatureToggle<F> filter(Predicate<? super F> p) {
        if (this.isDisabled()) {
            return this;
        }
        if (!p.test(this.get())) {
            return FeatureToggle.disable(this.get());
        }
        return this;
    }

    @Override
    default public void forEach(Consumer<? super F> consumer) {
        if (this.isDisabled()) {
            return;
        }
        consumer.accept(this.get());
    }

    default public Enabled<F> enable() {
        return new Enabled<F>(this.get());
    }

    default public Disabled<F> disable() {
        return new Disabled<F>(this.get());
    }

    default public FeatureToggle<F> flip() {
        if (this.isEnabled()) {
            return this.disable();
        }
        return this.enable();
    }

    default public Optional<F> optional() {
        return this.stream().findFirst();
    }

    @Override
    default public ReactiveSeq<F> stream() {
        if (this.isEnabled()) {
            return ReactiveSeq.of(new Object[]{this.get()});
        }
        return ReactiveSeq.of(new Object[0]);
    }

    @Override
    default public Iterator<F> iterator() {
        return Matchable.ValueAndOptionalMatcher.super.iterator();
    }

    public static final class Disabled<F>
    implements FeatureToggle<F> {
        private final F disabled;

        @Override
        public Enabled<F> enable() {
            return new Enabled<F>(this.disabled);
        }

        Disabled(F disabled) {
            this.disabled = disabled;
        }

        @Override
        public AnyMValue<F> anyM() {
            return AnyM.fromOptional(Optional.empty());
        }

        @Override
        public AnyM<F> anyMDisabled() {
            return AnyM.ofValue(this);
        }

        @Override
        public AnyM<F> anyMEnabled() {
            return this.anyM();
        }

        public static <F> Disabled<F> of(F f) {
            return new Disabled<F>(f);
        }

        public static <F> AnyM<F> anyMOf(F f) {
            return new Disabled<F>(f).anyM();
        }

        @Override
        public F get() {
            Optional.ofNullable(null).get();
            return null;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Disabled && Objects.equals(this.disabled, ((Disabled)obj).disabled);
        }

        public int hashCode() {
            return Objects.hashCode(this.disabled);
        }

        public String toString() {
            return String.format("Disabled(%s)", this.disabled);
        }

        @Override
        public final boolean isEnabled() {
            return false;
        }

        @Override
        public final boolean isDisabled() {
            return true;
        }

        @Override
        public <R> R visit(Function<? super F, ? extends R> enabled, Function<? super F, ? extends R> disabled) {
            return disabled.apply(this.get());
        }

        public F getDisabled() {
            return this.disabled;
        }
    }

    public static final class Enabled<F>
    implements FeatureToggle<F> {
        private final F enabled;

        @Override
        public AnyMValue<F> anyM() {
            return AnyM.ofValue(this);
        }

        @Override
        public AnyMValue<F> anyMDisabled() {
            return AnyM.ofValue(Optional.empty());
        }

        @Override
        public AnyMValue<F> anyMEnabled() {
            return this.anyM();
        }

        public static <F> Enabled<F> of(F f) {
            return new Enabled<F>(f);
        }

        public static <F> AnyM<F> anyMOf(F f) {
            return new Enabled<F>(f).anyM();
        }

        @Override
        public F get() {
            return this.enabled;
        }

        Enabled(F enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Enabled && Objects.equals(this.enabled, ((Enabled)obj).enabled);
        }

        public int hashCode() {
            return Objects.hashCode(this.enabled);
        }

        public String toString() {
            return String.format("Enabled(%s)", this.enabled);
        }

        @Override
        public final boolean isEnabled() {
            return true;
        }

        @Override
        public final boolean isDisabled() {
            return false;
        }

        @Override
        public <R> R visit(Function<? super F, ? extends R> enabled, Function<? super F, ? extends R> disabled) {
            return enabled.apply(this.get());
        }

        public F getEnabled() {
            return this.enabled;
        }
    }
}

