/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.control;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.Semigroup;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.For;
import com.aol.cyclops.control.Matchable;
import com.aol.cyclops.control.Maybe;
import com.aol.cyclops.control.Trampoline;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.persistent.PVectorX;
import com.aol.cyclops.data.collections.extensions.standard.DequeX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.MonadicValue;
import com.aol.cyclops.types.applicative.Applicativable;
import com.aol.cyclops.util.function.Memoize;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Eval<T>
extends Supplier<T>,
MonadicValue<T>,
Functor<T>,
Filterable<T>,
Applicativable<T>,
Matchable.ValueAndOptionalMatcher<T> {
    public static <T> Eval<T> fromIterable(Iterable<T> iterable) {
        Iterator it = iterable.iterator();
        return Eval.later(() -> it.hasNext() ? it.next() : null);
    }

    public static <T> Eval<T> now(T value) {
        return Eval.always(() -> value);
    }

    public static <T> Eval<T> later(Supplier<T> value) {
        return new Module.Later<Object>(in -> value.get());
    }

    public static <T> Eval<T> always(Supplier<T> value) {
        return new Module.Always<Object>(in -> value.get());
    }

    public static <T> Eval<ListX<T>> sequence(CollectionX<Eval<T>> evals) {
        return (Eval)AnyM.sequence(AnyM.listFromEval(evals)).unwrap();
    }

    public static <T, R> Eval<R> accumulate(CollectionX<Eval<T>> evals, Reducer<R> reducer) {
        return Eval.sequence(evals).map((T s) -> s.mapReduce(reducer));
    }

    public static <T, R> Eval<R> accumulate(CollectionX<Eval<T>> maybes, Function<? super T, R> mapper, Semigroup<R> reducer) {
        return Eval.sequence(maybes).map((T s) -> s.map(mapper).reduce(reducer.reducer()).get());
    }

    public static <T> Eval<T> accumulate(CollectionX<Eval<T>> maybes, Semigroup<T> reducer) {
        return Eval.sequence(maybes).map((T s) -> s.reduce(reducer.reducer()).get());
    }

    @Override
    public <T> Eval<T> unit(T var1);

    @Override
    public <R> Eval<R> map(Function<? super T, ? extends R> var1);

    public <R> Eval<R> flatMap(Function<? super T, ? extends Eval<? extends R>> var1);

    default public PVectorX<Function<Object, Object>> steps() {
        return PVectorX.of(__ -> this.get());
    }

    @Override
    default public <R> Eval<R> coflatMap(Function<? super MonadicValue<T>, R> mapper) {
        return (Eval)MonadicValue.super.coflatMap(mapper);
    }

    default public Eval<T> combine(Monoid<T> monoid, Eval<? extends T> v2) {
        return this.unit(For.Values.each2(this, t1 -> v2, (t1, t2) -> monoid.combiner().apply(t1, t2)).orElseGet(() -> this.orElseGet(() -> monoid.zero())));
    }

    @Override
    default public Eval<MonadicValue<T>> nest() {
        return (Eval)MonadicValue.super.nest();
    }

    @Override
    public T get();

    @Override
    default public <U> Maybe<U> ofType(Class<? extends U> type) {
        return (Maybe)Filterable.super.ofType(type);
    }

    @Override
    default public Maybe<T> filterNot(Predicate<? super T> fn) {
        return (Maybe)Filterable.super.filterNot(fn);
    }

    @Override
    default public Maybe<T> notNull() {
        return (Maybe)Filterable.super.notNull();
    }

    @Override
    default public Maybe<T> filter(Predicate<? super T> pred) {
        return this.toMaybe().filter((Predicate)pred);
    }

    @Override
    default public <U> Eval<U> cast(Class<? extends U> type) {
        return (Eval)Applicativable.super.cast(type);
    }

    @Override
    default public Eval<T> peek(Consumer<? super T> c) {
        return (Eval)Applicativable.super.peek(c);
    }

    @Override
    default public <R> Eval<R> trampoline(Function<? super T, ? extends Trampoline<? extends R>> mapper) {
        return (Eval)Applicativable.super.trampoline(mapper);
    }

    default public Eval<CompletableFuture<T>> asyncNow(Executor ex) {
        return Eval.now(this.toCompletableFutureAsync(ex));
    }

    default public Eval<CompletableFuture<T>> asyncNow() {
        return Eval.now(this.toCompletableFuture());
    }

    default public Eval<CompletableFuture<T>> asyncLater(Executor ex) {
        return Eval.later(() -> this.toCompletableFutureAsync(ex));
    }

    default public Eval<CompletableFuture<T>> asyncLater() {
        return Eval.later(() -> this.toCompletableFutureAsync());
    }

    default public Eval<CompletableFuture<T>> asyncAlways(Executor ex) {
        return Eval.always(() -> this.toCompletableFutureAsync(ex));
    }

    default public Eval<CompletableFuture<T>> asyncAlways() {
        return Eval.always(() -> this.toCompletableFutureAsync());
    }

    public static <R> Eval<R> narrow(Eval<? extends R> broad) {
        return broad;
    }

    public static class Module {

        private static class Rec<T> {
            final PVectorX<Function<Object, Object>> fns;
            private static final Object VOID = new Object();

            Rec(PVectorX<Function<Object, Object>> s) {
                this.fns = s;
            }

            private static Function<Object, Object> raw(Function<?, ?> fn) {
                return fn;
            }

            public PVectorX<Function<Object, Object>> steps() {
                return this.fns;
            }

            T apply() {
                Object input = VOID;
                for (Function function : this.fns) {
                    DequeX<Function> newFns = DequeX.of(function);
                    while (newFns.size() > 0) {
                        Function next = (Function)newFns.pop();
                        if (next instanceof RecFunction) {
                            newFns.plusAll((Collection)((List)((RecFunction)next).apply(VOID)));
                            continue;
                        }
                        input = next.apply(input);
                    }
                }
                return (T)input;
            }

            public T get() {
                return this.apply();
            }

            static interface RecFunction
            extends Function<Object, Object> {
            }
        }

        public static class Always<T>
        extends Rec<T>
        implements Eval<T> {
            Always(Function<Object, ? extends T> s) {
                super(PVectorX.of(Rec.raw(s)));
            }

            Always(PVectorX<Function<Object, Object>> s) {
                super(s);
            }

            @Override
            public <R> Eval<R> map(Function<? super T, ? extends R> mapper) {
                return new Always<T>((PVectorX<Function<Object, Object>>)this.fns.plus(Rec.raw(mapper)));
            }

            @Override
            public <R> Eval<R> flatMap(Function<? super T, ? extends Eval<? extends R>> mapper) {
                Rec.RecFunction s = __ -> ((Eval)mapper.apply((T)this.apply())).steps();
                return new Always<T>(PVectorX.of(s));
            }

            @Override
            public T get() {
                return super.get();
            }

            @Override
            public <T> Eval<T> unit(T unit) {
                return Eval.always(() -> unit);
            }

            @Override
            public Eval<T> toEvalAlways() {
                return this;
            }

            public int hashCode() {
                return this.get().hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Eval)) {
                    return false;
                }
                return Objects.equals(this.get(), ((Eval)obj).get());
            }

            public String toString() {
                return this.mkString();
            }
        }

        public static class Later<T>
        extends Rec<T>
        implements Eval<T> {
            Later(Function<Object, ? extends T> s) {
                super(PVectorX.of(Rec.raw(Memoize.memoizeFunction(s))));
            }

            Later(PVectorX<Function<Object, Object>> s) {
                super(s);
            }

            @Override
            public <R> Eval<R> map(Function<? super T, ? extends R> mapper) {
                return new Later<T>((PVectorX<Function<Object, Object>>)this.fns.plus((Object)Rec.raw(Memoize.memoizeFunction(mapper))));
            }

            @Override
            public <R> Eval<R> flatMap(Function<? super T, ? extends Eval<? extends R>> mapper) {
                Rec.RecFunction s = __ -> ((Eval)mapper.apply((T)super.apply())).steps();
                return new Later<T>(PVectorX.of(s));
            }

            @Override
            public T get() {
                return super.get();
            }

            @Override
            public <T> Eval<T> unit(T unit) {
                return Eval.later(() -> unit);
            }

            @Override
            public Eval<T> toEvalLater() {
                return this;
            }

            public int hashCode() {
                return this.get().hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Eval)) {
                    return false;
                }
                return Objects.equals(this.get(), ((Eval)obj).get());
            }

            public String toString() {
                return this.mkString();
            }
        }
    }
}

