/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.data.collections.extensions.persistent.PBagX;
import com.aol.cyclops.data.collections.extensions.persistent.PMapX;
import com.aol.cyclops.data.collections.extensions.persistent.POrderedSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PQueueX;
import com.aol.cyclops.data.collections.extensions.persistent.PSetX;
import com.aol.cyclops.data.collections.extensions.persistent.PStackX;
import com.aol.cyclops.data.collections.extensions.persistent.PVectorX;
import com.aol.cyclops.types.mixins.TupleWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pcollections.AmortizedPQueue;
import org.pcollections.ConsPStack;
import org.pcollections.HashTreePBag;
import org.pcollections.HashTreePMap;
import org.pcollections.HashTreePSet;
import org.pcollections.OrderedPSet;
import org.pcollections.PBag;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PQueue;
import org.pcollections.PSet;
import org.pcollections.PStack;
import org.pcollections.PVector;
import org.pcollections.TreePVector;

public class Reducers {
    private static <T> PQueue<T> queueOf(T ... values) {
        AmortizedPQueue result = AmortizedPQueue.empty();
        for (T value : values) {
            result = result.plus(value);
        }
        return result;
    }

    public static <T> Reducer<PQueueX<T>> toPQueueX() {
        return Reducer.of(PQueueX.empty(), a -> b -> a.plusAll((Collection)b), x -> PQueueX.singleton(x));
    }

    public static <T> Reducer<POrderedSetX<T>> toPOrderedSetX() {
        return Reducer.of(POrderedSetX.empty(), a -> b -> a.plusAll((Collection)b), x -> POrderedSetX.singleton(x));
    }

    public static <T> Reducer<PSetX<T>> toPSetX() {
        return Reducer.of(PSetX.empty(), a -> b -> a.plusAll((Collection)b), x -> PSetX.singleton(x));
    }

    public static <T> Reducer<PStackX<T>> toPStackX() {
        return Reducer.of(PStackX.empty(), a -> b -> a.plusAll((Collection)b), x -> PStackX.singleton(x));
    }

    public static <T> Reducer<PVectorX<T>> toPVectorX() {
        return Reducer.of(PVectorX.empty(), a -> b -> a.plusAll((Collection)b), x -> PVectorX.singleton(x));
    }

    public static <T> Reducer<PBagX<T>> toPBagX() {
        return Reducer.of(PBagX.empty(), a -> b -> a.plusAll((Collection)b), x -> PBagX.singleton(x));
    }

    private static <T> PQueue<T> queueSingleton(T value) {
        AmortizedPQueue result = AmortizedPQueue.empty();
        result = result.plus(value);
        return result;
    }

    public static <T> Reducer<PQueue<T>> toPQueue() {
        return Reducer.of(AmortizedPQueue.empty(), a -> b -> a.plusAll((Collection)b), x -> Reducers.queueSingleton(x));
    }

    public static <T> Reducer<POrderedSet<T>> toPOrderedSet() {
        return Reducer.of(OrderedPSet.empty(), a -> b -> a.plusAll((Collection)b), x -> OrderedPSet.singleton((Object)x));
    }

    public static <T> Reducer<PBag<T>> toPBag() {
        return Reducer.of(HashTreePBag.empty(), a -> b -> a.plusAll((Collection)b), x -> HashTreePBag.singleton((Object)x));
    }

    public static <T> Reducer<PSet<T>> toPSet() {
        return Reducer.of(HashTreePSet.empty(), a -> b -> a.plusAll((Collection)b), x -> HashTreePSet.singleton((Object)x));
    }

    public static <T> Reducer<PVector<T>> toPVector() {
        return Reducer.of(TreePVector.empty(), a -> b -> a.plusAll((Collection)b), x -> TreePVector.singleton((Object)x));
    }

    public static <T> Reducer<PStack<T>> toPStack() {
        return Reducer.of(ConsPStack.empty(), a -> b -> a.plusAll(a.size(), (Collection)b), x -> ConsPStack.singleton((Object)x));
    }

    public static <T> Reducer<PStack<T>> toPStackReversed() {
        return Reducer.of(ConsPStack.empty(), a -> b -> a.plusAll((Collection)b), x -> ConsPStack.singleton((Object)x));
    }

    public static <K, V> Reducer<PMap<K, V>> toPMap() {
        return Reducer.of(HashTreePMap.empty(), a -> b -> a.plusAll((Map)b), in -> {
            List<Object> w = ((TupleWrapper)() -> in).values();
            return HashTreePMap.singleton((Object)w.get(0), (Object)w.get(1));
        });
    }

    public static <K, V> Reducer<PMapX<K, V>> toPMapX() {
        return Reducer.of(PMapX.empty(), a -> b -> a.plusAll((Map)b), in -> {
            List<Object> w = ((TupleWrapper)() -> in).values();
            return PMapX.singleton(w.get(0), w.get(1));
        });
    }

    public static Monoid<String> toString(String joiner) {
        return Monoid.of("", (a, b) -> a + joiner + b);
    }

    public static Monoid<Integer> toTotalInt() {
        return Monoid.of(Integer.valueOf(0), a -> b -> a + b);
    }

    public static Reducer<Integer> toCountInt() {
        return Reducer.of(Integer.valueOf(0), a -> b -> a + 1, x -> 1);
    }

    public static Monoid<Double> toTotalDouble() {
        return Monoid.of(Double.valueOf(0.0), (a, b) -> a + b);
    }

    public static Reducer<Double> toCountDouble() {
        return Reducer.of(Double.valueOf(0.0), a -> b -> a + 1.0, x -> Double.valueOf("" + x));
    }
}

