/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.rest.jackson;

import com.aol.cyclops.util.ExceptionSoftener;
import com.aol.micro.server.jackson.CoreJacksonConfigurator;
import com.aol.micro.server.jackson.JacksonMapperConfigurator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtil {
    private static ObjectMapper mapper = null;
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static volatile List<JacksonMapperConfigurator> jacksonConfigurers = Arrays.asList(new CoreJacksonConfigurator(JsonInclude.Include.NON_NULL));

    public static void setJacksonConfigurers(List<JacksonMapperConfigurator> jc) {
        jacksonConfigurers = jc;
        mapper = null;
        JacksonUtil.getMapper();
    }

    private static synchronized ObjectMapper createMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            Optional.ofNullable(jacksonConfigurers).ifPresent(list -> list.forEach(a -> a.accept(mapper)));
        }
        return mapper;
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            return JacksonUtil.createMapper();
        }
        return mapper;
    }

    public static String serializeToJsonFailSilently(Object data) {
        try {
            return JacksonUtil.serializeToJson(data);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String serializeToJson(Object data) {
        String jsonString = "";
        if (data == null) {
            return jsonString;
        }
        try {
            jsonString = JacksonUtil.getMapper().writeValueAsString(data);
        }
        catch (Exception ex) {
            ExceptionSoftener.throwSoftenedException((Throwable)ex);
        }
        return jsonString;
    }

    public static <T> T convertFromJson(String jsonString, Class<T> type) {
        try {
            return (T)JacksonUtil.getMapper().readValue(jsonString, type);
        }
        catch (Exception ex) {
            ExceptionSoftener.throwSoftenedException((Throwable)ex);
            return null;
        }
    }

    public static <T> T convertFromJson(String jsonString, JavaType type) {
        try {
            return (T)JacksonUtil.getMapper().readValue(jsonString, type);
        }
        catch (Exception ex) {
            ExceptionSoftener.throwSoftenedException((Throwable)ex);
            return null;
        }
    }

    public static Object serializeToJsonLogFailure(Object value) {
        try {
            return JacksonUtil.serializeToJson(value);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return value.toString();
        }
    }
}

