/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.trycatch;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.trycatch.Failure;
import com.aol.cyclops.trycatch.Success;
import com.aol.cyclops.value.ValueObject;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface Try<T, X extends Throwable>
extends Supplier<T>,
ValueObject,
Streamable<T> {
    public AnyM<T> anyM();

    public AnyM<X> anyMFailure();

    public AnyM<T> anyMSuccess();

    @Override
    public T get();

    public void throwException();

    public T orElse(T var1);

    public T orElseGet(Supplier<T> var1);

    public <R> Try<R, X> map(Function<T, R> var1);

    public <R> Try<R, X> flatMap(Function<T, Try<R, X>> var1);

    public Optional<T> filter(Predicate<T> var1);

    public Try<T, X> onFail(Consumer<X> var1);

    public Try<T, X> onFail(Class<? extends X> var1, Consumer<X> var2);

    public Success<T, X> recover(Function<X, T> var1);

    public Success<T, X> recoverWith(Function<X, Success<T, X>> var1);

    public Try<T, X> recoverFor(Class<? extends X> var1, Function<X, T> var2);

    public Try<T, X> recoverWithFor(Class<? extends X> var1, Function<X, Success<T, X>> var2);

    public Try<T, X> flatten();

    public Optional<T> toOptional();

    public Stream<T> stream();

    public Optional<X> toFailedOptional();

    public Stream<X> toFailedStream();

    public boolean isSuccess();

    public boolean isFailure();

    public void foreach(Consumer<T> var1);

    public void foreachFailed(Consumer<X> var1);

    default public Try<T, X> peek(Consumer<T> consumer) {
        this.foreach(consumer);
        return this;
    }

    default public Try<T, X> peekFailed(Consumer<X> consumer) {
        this.foreachFailed(consumer);
        return this;
    }

    @SafeVarargs
    public static <T, X extends Throwable> Try<T, X> of(T value, Class<? extends Throwable> ... classes) {
        return new Success(value, classes);
    }

    @SafeVarargs
    public static <T, X extends Throwable> Try<T, X> withCatch(CheckedSupplier<T, X> cf, Class<? extends X> ... classes) {
        Objects.requireNonNull(cf);
        try {
            return Success.of(cf.get());
        }
        catch (Throwable t) {
            if (classes.length == 0) {
                return Failure.of(t);
            }
            Optional<Class> error = Stream.of(classes).filter((? super T c) -> c.isAssignableFrom(t.getClass())).findFirst();
            if (error.isPresent()) {
                return Failure.of(t);
            }
            throw ExceptionSoftener.throwSoftenedException((Throwable)t);
        }
    }

    @SafeVarargs
    public static <X extends Throwable> Try<Void, X> runWithCatch(CheckedRunnable cf, Class<? extends X> ... classes) {
        Objects.requireNonNull(cf);
        try {
            cf.run();
            return Success.of(null);
        }
        catch (Throwable t) {
            if (classes.length == 0) {
                return Failure.of(t);
            }
            Optional<Class> error = Stream.of(classes).filter((? super T c) -> c.isAssignableFrom(t.getClass())).findFirst();
            if (error.isPresent()) {
                return Failure.of(t);
            }
            throw ExceptionSoftener.throwSoftenedException((Throwable)t);
        }
    }

    @SafeVarargs
    public static <X extends Throwable> Init<X> catchExceptions(Class<? extends X> ... classes) {
        return new MyInit<X>(classes);
    }

    public static interface CheckedRunnable<X extends Throwable> {
        public void run() throws X;
    }

    public static interface CheckedConsumer<T, X extends Throwable> {
        public void accept(T var1) throws X;
    }

    public static interface CheckedSupplier<T, X extends Throwable> {
        public T get() throws X;
    }

    public static interface CheckedFunction<T, R, X extends Throwable> {
        public R apply(T var1) throws X;
    }

    public static interface AndFinally<T, V, X extends Throwable> {
        public Try<T, X> andFinally(CheckedConsumer<V, X> var1);

        public Try<T, X> close();
    }

    public static interface TryCatch<V, X extends Throwable> {
        public <T> Try<T, X> tryWithResources(CheckedFunction<V, T, X> var1);

        public <T> AndFinally<T, V, X> tryThis(CheckedFunction<V, T, X> var1);
    }

    public static interface Init<X extends Throwable> {
        public <V> TryCatch<V, X> init(CheckedSupplier<V, X> var1);

        public Try<Void, X> run(CheckedRunnable<X> var1);

        public <V> Try<V, X> tryThis(CheckedSupplier<V, X> var1);
    }

    public static class MyFinallyBlock<T, V, X extends Throwable>
    implements AndFinally<T, V, X> {
        private final Class<X>[] classes;
        private final CheckedSupplier<V, X> inputSupplier;
        private final CheckedFunction<V, T, X> catchBlock;

        private void invokeClose(Object in) {
            if (in instanceof Iterable) {
                this.invokeClose((Iterable)in);
            }
            this.invokeClose((Closeable)in);
        }

        private void invokeClose(Iterable<Closeable> in) {
            for (Closeable next : in) {
                this.invokeClose(next);
            }
        }

        private void invokeClose(Closeable in) {
            Try.withCatch(() -> in.getClass().getMethod("close", new Class[0]), new Class[0]).filter(m -> m != null).flatMap(m -> Try.withCatch(() -> m.invoke((Object)in, new Object[0]), new Class[0]).filter(o -> o != null));
        }

        @Override
        public Try<T, X> close() {
            return this.andFinally(in -> this.invokeClose(in));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Try<T, X> andFinally(CheckedConsumer<V, X> finallyBlock) {
            Try input = Try.withCatch(() -> this.inputSupplier.get(), this.classes);
            Try result = null;
            try {
                result = input.flatMap(in -> Try.withCatch(() -> this.catchBlock.apply(in), this.classes));
            }
            finally {
                Try finalResult = result.flatMap(i -> Try.runWithCatch(() -> finallyBlock.accept(input.get()), this.classes));
                if (finalResult instanceof Failure) {
                    return finalResult;
                }
            }
            return result;
        }

        @ConstructorProperties(value={"classes", "inputSupplier", "catchBlock"})
        public MyFinallyBlock(Class<X>[] classes, CheckedSupplier<V, X> inputSupplier, CheckedFunction<V, T, X> catchBlock) {
            this.classes = classes;
            this.inputSupplier = inputSupplier;
            this.catchBlock = catchBlock;
        }
    }

    public static class MyTryCatch<V, X extends Throwable>
    implements TryCatch<V, X> {
        private final Class<X>[] classes;
        private final CheckedSupplier<V, X> inputSupplier;

        @Override
        public <T> AndFinally<T, V, X> tryThis(CheckedFunction<V, T, X> catchBlock) {
            return new MyFinallyBlock<T, V, X>(this.classes, this.inputSupplier, catchBlock);
        }

        @Override
        public <T> Try<T, X> tryWithResources(CheckedFunction<V, T, X> catchBlock) {
            return new MyFinallyBlock<T, V, X>(this.classes, this.inputSupplier, catchBlock).close();
        }

        @ConstructorProperties(value={"classes", "inputSupplier"})
        public MyTryCatch(Class<X>[] classes, CheckedSupplier<V, X> inputSupplier) {
            this.classes = classes;
            this.inputSupplier = inputSupplier;
        }
    }

    public static class MyInit<X extends Throwable>
    implements Init<X> {
        private final Class<X>[] classes;

        @Override
        public <V> TryCatch<V, X> init(CheckedSupplier<V, X> input) {
            return new MyTryCatch<V, X>(this.classes, input);
        }

        @Override
        public Try<Void, X> run(CheckedRunnable<X> input) {
            return Try.runWithCatch(input, this.classes);
        }

        @Override
        public <V> Try<V, X> tryThis(CheckedSupplier<V, X> input) {
            return Try.withCatch(input, this.classes);
        }

        @ConstructorProperties(value={"classes"})
        public MyInit(Class<X>[] classes) {
            this.classes = classes;
        }
    }
}

