/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.trycatch;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.trycatch.Failure;
import com.aol.cyclops.trycatch.Try;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Success<T, X extends Throwable>
implements Try<T, X> {
    private final T value;
    private final Class<? extends Throwable>[] classes;

    public <R extends Iterable<?>> R unapply() {
        return (R)Arrays.asList(this.value);
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public AnyM<T> anyM() {
        return AsAnyM.notTypeSafeAnyM((Object)this);
    }

    @Override
    public AnyM<X> anyMFailure() {
        return AsAnyM.notTypeSafeAnyM(Optional.empty());
    }

    @Override
    public AnyM<T> anyMSuccess() {
        return this.anyM();
    }

    public static <T, X extends Throwable> Success<T, X> of(T value) {
        return new Success<T, X>(value, new Class[0]);
    }

    public static <T, X extends Throwable> AnyM<T> anyMOf(T value, Class<? extends Throwable>[] classes) {
        return new Success<T, X>(value, classes).anyM();
    }

    public static <T, X extends Throwable> AnyM<T> anyMOf(T value) {
        return new Success<T, X>(value, new Class[0]).anyM();
    }

    public static <T, X extends Throwable> Success<T, X> of(T value, Class<? extends Throwable>[] classes) {
        return new Success<T, X>(value, classes);
    }

    @Override
    public <R> Try<R, X> map(Function<T, R> fn) {
        return this.safeApply(() -> Success.of(fn.apply(this.get())));
    }

    private <R> R safeApply(Supplier<R> s) {
        try {
            return s.get();
        }
        catch (Throwable t) {
            return (R)Failure.of(this.orThrow(Stream.of(this.classes).filter((? super T c) -> c.isAssignableFrom(t.getClass())).map((? super T c) -> t).findFirst(), t));
        }
    }

    private Throwable orThrow(Optional<Throwable> findFirst, Throwable t) {
        if (findFirst.isPresent()) {
            return findFirst.get();
        }
        ExceptionSoftener.throwSoftenedException((Throwable)t);
        return null;
    }

    @Override
    public <R> Try<R, X> flatMap(Function<T, Try<R, X>> fn) {
        return this.safeApply(() -> (Try)fn.apply(this.get()));
    }

    @Override
    public Optional<T> filter(Predicate<T> p) {
        if (p.test(this.value)) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    @Override
    public Success<T, X> recover(Function<X, T> fn) {
        return this;
    }

    @Override
    public Success<T, X> recoverWith(Function<X, Success<T, X>> fn) {
        return this;
    }

    @Override
    public Success<T, X> recoverFor(Class<? extends X> t, Function<X, T> fn) {
        return this;
    }

    @Override
    public Success<T, X> recoverWithFor(Class<? extends X> t, Function<X, Success<T, X>> fn) {
        return this;
    }

    @Override
    public Try<T, X> flatten() {
        if (this.value instanceof Try) {
            return ((Try)this.value).flatten();
        }
        return this;
    }

    @Override
    public T orElse(T value) {
        return this.get();
    }

    @Override
    public T orElseGet(Supplier<T> value) {
        return this.get();
    }

    @Override
    public Optional<T> toOptional() {
        return Optional.of(this.value);
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.value);
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    @Override
    public void foreach(Consumer<T> consumer) {
        consumer.accept(this.value);
    }

    @Override
    public Try<T, X> onFail(Consumer<X> consumer) {
        return this;
    }

    @Override
    public Try<T, X> onFail(Class<? extends X> t, Consumer<X> consumer) {
        return this;
    }

    @Override
    public void throwException() {
    }

    @Override
    public Optional<X> toFailedOptional() {
        return Optional.empty();
    }

    @Override
    public Stream<X> toFailedStream() {
        return Stream.of(new Throwable[0]);
    }

    @Override
    public void foreachFailed(Consumer<X> consumer) {
    }

    @ConstructorProperties(value={"value", "classes"})
    public Success(T value, Class<? extends Throwable>[] classes) {
        this.value = value;
        this.classes = classes;
    }

    public String toString() {
        return "Success(value=" + this.value + ", classes=" + Arrays.deepToString(this.classes) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Success)) {
            return false;
        }
        Success other = (Success)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return Arrays.deepEquals(this.classes, other.classes);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Success;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 0 : $value.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.classes);
        return result;
    }
}

