/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.sequence.streamable;

import com.aol.cyclops.invokedynamic.InvokeDynamic;
import com.aol.cyclops.objects.AsDecomposable;
import com.aol.cyclops.sequence.ReversedIterator;
import com.aol.cyclops.sequence.SeqUtils;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.streamable.ConvertableToSequenceM;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface ToStream<T>
extends Iterable<T>,
ConvertableToSequenceM<T> {
    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Object getStreamable() {
        return this;
    }

    default public SequenceM<T> reveresedSequenceM() {
        return SequenceM.fromStream(this.reveresedStream());
    }

    @Override
    default public SequenceM<T> sequenceM() {
        return SequenceM.fromStream(this.stream());
    }

    default public Stream<T> reveresedStream() {
        Object streamable = this.getStreamable();
        if (streamable instanceof List) {
            return StreamSupport.stream(new ReversedIterator((List)streamable).spliterator(), false);
        }
        if (streamable instanceof Object[]) {
            List<Object> arrayList = Arrays.asList((Object[])streamable);
            return StreamSupport.stream(new ReversedIterator<Object>(arrayList).spliterator(), false);
        }
        return SeqUtils.reverse(this.stream());
    }

    default public boolean isEmpty() {
        return this.sequenceM().isEmpty();
    }

    default public Stream<T> stream() {
        Object streamable = this.getStreamable();
        if (streamable instanceof Stream) {
            return (Stream)streamable;
        }
        if (streamable instanceof Iterable) {
            return StreamSupport.stream(((Iterable)streamable).spliterator(), false);
        }
        return new InvokeDynamic().stream(streamable).orElseGet(() -> StreamSupport.stream(AsDecomposable.asDecomposable(streamable).unapply().spliterator(), false));
    }
}

