/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.spliterators;

import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;

public class ClosingSpliterator<T>
implements Spliterator<T> {
    private long estimate;
    private final Queue<T> queue;
    private final AtomicBoolean open;

    public ClosingSpliterator(long estimate, Queue queue, AtomicBoolean open) {
        this.estimate = estimate;
        this.open = open;
        this.queue = queue;
    }

    @Override
    public long estimateSize() {
        return this.estimate;
    }

    @Override
    public int characteristics() {
        return 1024;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (!this.open.get() && this.queue.size() == 0) {
            return false;
        }
        while (this.open.get()) {
            long nanos = 1L;
            T value = this.queue.poll();
            if (value != null) {
                action.accept(this.nullSafe(value));
                return true;
            }
            LockSupport.parkNanos(nanos);
            long l = nanos * 2L;
        }
        return false;
    }

    private T nullSafe(T value) {
        return value;
    }

    @Override
    public Spliterator<T> trySplit() {
        return this;
    }
}

