/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.sequence.streamable.Streamable;
import com.aol.cyclops.streams.StreamUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public final class WindowByTimeAndSizeOperator<T> {
    private final Stream<T> stream;

    public Stream<Streamable<T>> windowBySizeAndTime(final int size, long time, TimeUnit t) {
        final Iterator it = this.stream.iterator();
        final long toRun = t.toNanos(time);
        return StreamUtils.stream(new Iterator<Streamable<T>>(){
            long start = System.nanoTime();

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Streamable<T> next() {
                ArrayList list = new ArrayList();
                while (list.size() == 0 && it.hasNext()) {
                    while (System.nanoTime() - this.start < toRun && it.hasNext() && list.size() < size) {
                        list.add(it.next());
                    }
                    this.start = System.nanoTime();
                }
                return Streamable.fromIterable(list);
            }
        });
    }

    @ConstructorProperties(value={"stream"})
    public WindowByTimeAndSizeOperator(Stream<T> stream) {
        this.stream = stream;
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowByTimeAndSizeOperator)) {
            return false;
        }
        WindowByTimeAndSizeOperator other = (WindowByTimeAndSizeOperator)o;
        Stream<T> this$stream = this.getStream();
        Stream<T> other$stream = other.getStream();
        return !(this$stream == null ? other$stream != null : !this$stream.equals(other$stream));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<T> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        return result;
    }

    public String toString() {
        return "WindowByTimeAndSizeOperator(stream=" + this.getStream() + ")";
    }
}

