/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.operators;

import com.aol.cyclops.streams.StreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class BatchBySizeOperator<T, C extends Collection<T>> {
    private final Stream<T> stream;
    private final Supplier<C> factory;

    public BatchBySizeOperator(Stream<T> stream) {
        this.stream = stream;
        this.factory = () -> new ArrayList();
    }

    public BatchBySizeOperator(Stream<T> stream2, Supplier<C> factory2) {
        this.stream = stream2;
        this.factory = factory2;
    }

    public Stream<C> batchBySize(final int groupSize) {
        if (groupSize < 1) {
            throw new IllegalArgumentException("Batch size must be 1 or more");
        }
        final Iterator it = this.stream.iterator();
        return StreamUtils.stream(new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public C next() {
                Collection list = (Collection)BatchBySizeOperator.this.factory.get();
                for (int i = 0; i < groupSize; ++i) {
                    if (!it.hasNext()) continue;
                    list.add(it.next());
                }
                return list;
            }
        });
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public Supplier<C> getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchBySizeOperator)) {
            return false;
        }
        BatchBySizeOperator other = (BatchBySizeOperator)o;
        Stream<T> this$stream = this.getStream();
        Stream<T> other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        Supplier<C> this$factory = this.getFactory();
        Supplier<C> other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream<T> $stream = this.getStream();
        result = result * 59 + ($stream == null ? 0 : $stream.hashCode());
        Supplier<C> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "BatchBySizeOperator(stream=" + this.getStream() + ", factory=" + this.getFactory() + ")";
    }
}

