/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.future;

import com.aol.cyclops.sequence.future.LongOperators;
import com.aol.cyclops.streams.HasExec;
import com.aol.cyclops.streams.HasStream;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToLongFunction;
import java.util.stream.LongStream;

public interface LongOperatorsMixin<T>
extends LongOperators<T>,
HasStream<T>,
HasExec {
    default public CompletableFuture<Long> sumLong(ToLongFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).sum(), this.getExec());
    }

    default public CompletableFuture<OptionalLong> maxLong(ToLongFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).max(), this.getExec());
    }

    default public CompletableFuture<OptionalLong> minLong(ToLongFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).min(), this.getExec());
    }

    default public CompletableFuture<OptionalDouble> averageLong(ToLongFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).average(), this.getExec());
    }

    default public CompletableFuture<LongSummaryStatistics> summaryStatisticsLong(ToLongFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToLong(t -> LongStream.of(fn.applyAsLong(t))).summaryStatistics(), this.getExec());
    }
}

