/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.sequence.HotStream;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.streams.StreamUtils;
import com.aol.cyclops.streams.spliterators.ClosingSpliterator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import uk.co.real_logic.agrona.concurrent.OneToOneConcurrentArrayQueue;

public class HotStreamImpl<T>
implements HotStream<T> {
    private final Stream<T> stream;
    private final AtomicReferenceArray<Queue<T>> connections = new AtomicReferenceArray(10);
    private final AtomicBoolean open = new AtomicBoolean(true);
    private volatile int connected = 0;

    public HotStreamImpl(Stream<T> stream) {
        this.stream = stream;
    }

    public HotStream<T> init(Executor exec) {
        CompletableFuture.runAsync(() -> {
            this.stream.forEach(a -> {
                int local = this.connected;
                for (int i = 0; i < local; ++i) {
                    this.connections.get(i).offer(a);
                }
            });
            this.open.set(false);
            System.out.println("finished!");
        }, exec);
        return this;
    }

    public SequenceM<T> connect() {
        return this.connect((Queue<T>)new OneToOneConcurrentArrayQueue(256));
    }

    public SequenceM<T> connect(Queue<T> queue) {
        this.connections.getAndSet(this.connected, queue);
        ++this.connected;
        return StreamUtils.sequenceM(StreamSupport.stream(new ClosingSpliterator(Long.MAX_VALUE, queue, this.open), false), Optional.empty());
    }

    public <R extends Stream<T>> R connectTo(Queue<T> queue, Function<SequenceM<T>, R> to) {
        return (R)((Stream)to.apply(this.connect(queue)));
    }
}

