/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher.builders;

import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.SeqUtils;
import com.aol.cyclops.sequence.SequenceM;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.jooq.lambda.Seq;

public class ADTPredicateBuilder<T> {
    private final Class<T> type;

    Predicate toPredicate() {
        return t -> Optional.of(t).map(v -> this.type.isAssignableFrom(v.getClass())).orElse(false);
    }

    public <V> Predicate hasValues(V ... values) {
        SequenceM predicates = SequenceM.of((Object[])values).map(nextValue -> this.convertToPredicate(nextValue));
        return t -> this.toPredicate().test(t) && SeqUtils.seq(Extractors.decompose().apply(t)).zip((Seq)predicates, (a, b) -> Two.tuple(a, b)).map(tuple -> ((Predicate)tuple.v2).test(tuple.v1)).allMatch(v -> v == true);
    }

    public <V> Predicate hasValuesWhere(Predicate<V> ... values) {
        SequenceM predicates = SequenceM.of((Object[])values).map(nextValue -> this.convertToPredicate(nextValue));
        return t -> this.toPredicate().test(t) && SeqUtils.seq(Extractors.decompose().apply(t)).zip((Seq)predicates, (a, b) -> Two.tuple(a, b)).map(tuple -> ((Predicate)tuple.v2).test(tuple.v1)).allMatch(v -> v == true);
    }

    public <V> Predicate hasValuesMatching(Matcher<V> ... values) {
        SequenceM predicates = SequenceM.of((Object[])values).map(nextValue -> this.convertToPredicate(nextValue));
        return t -> this.toPredicate().test(t) && SeqUtils.seq(Extractors.decompose().apply(t)).zip((Seq)predicates, (a, b) -> Two.tuple(a, b)).map(tuple -> ((Predicate)tuple.v2).test(tuple.v1)).allMatch(v -> v == true);
    }

    private Predicate convertToPredicate(Object o) {
        if (o instanceof Predicate) {
            return (Predicate)o;
        }
        if (o instanceof Matcher) {
            return test -> ((Matcher)o).matches(test);
        }
        return test -> Objects.equals(test, o);
    }

    @ConstructorProperties(value={"type"})
    public ADTPredicateBuilder(Class<T> type) {
        this.type = type;
    }
}

