/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher.builders;

import com.aol.cyclops.matcher.Extractors;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.SeqUtils;
import com.nurkiewicz.lazyseq.LazySeq;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.hamcrest.Matcher;

public class ADTPredicateBuilder<T> {
    private final Class<T> type;

    Predicate toPredicate() {
        return t -> Optional.of(t).map(v -> this.type.isAssignableFrom(v.getClass())).orElse(false);
    }

    public <V> Predicate with(V ... values) {
        LazySeq predicates = LazySeq.of((Object[])values).map(nextValue -> this.convertToPredicate(nextValue));
        return t -> this.toPredicate().test(t) && SeqUtils.seq(Extractors.decompose().apply(t)).zip(predicates, (a, b) -> Two.tuple(a, b)).map(tuple -> ((Predicate)tuple.v2).test(tuple.v1)).allMatch(v -> v == true);
    }

    private Predicate convertToPredicate(Object o) {
        if (o instanceof Predicate) {
            return (Predicate)o;
        }
        if (o instanceof Matcher) {
            return test -> ((Matcher)o).matches(test);
        }
        return test -> Objects.equals(test, o);
    }

    @ConstructorProperties(value={"type"})
    public ADTPredicateBuilder(Class<T> type) {
        this.type = type;
    }
}

