/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher.builders;

import com.aol.cyclops.matcher.Action;
import com.aol.cyclops.matcher.Extractor;
import com.aol.cyclops.matcher.TypedFunction;
import com.aol.cyclops.matcher.builders.CaseBeingBuilt;
import com.aol.cyclops.matcher.builders.CollectionStep;
import com.aol.cyclops.matcher.builders.MatchingInstance;
import com.aol.cyclops.matcher.builders.PatternMatcher;
import com.aol.cyclops.matcher.builders.Step;
import java.beans.ConstructorProperties;
import java.util.function.Predicate;
import org.hamcrest.Matcher;

public class CaseBuilder {

    public static class InMatchOfBuilder<V, X> {
        private final Matcher<V> match;
        private final PatternMatcher patternMatcher;
        private final CaseBeingBuilt cse;

        public <R, X> CollectionStep<R, X> thenExtract(Extractor<? extends V, R> extractor) {
            return new InMatchOfThenExtract(extractor);
        }

        public <T, X> MatchingInstance<T, X> thenApply(TypedFunction<V, X> a) {
            return this.addCase(this.patternMatcher.inMatchOf(this.match, a));
        }

        public <T, X> MatchingInstance<T, X> thenConsume(Action<V> a) {
            return this.addCase(this.patternMatcher.matchOf(this.match, a));
        }

        private <T, X> MatchingInstance<T, X> addCase(PatternMatcher o) {
            return new MatchingInstance(this.cse.withPatternMatcher(o));
        }

        @ConstructorProperties(value={"match", "patternMatcher", "cse"})
        public InMatchOfBuilder(Matcher<V> match, PatternMatcher patternMatcher, CaseBeingBuilt cse) {
            this.match = match;
            this.patternMatcher = patternMatcher;
            this.cse = cse;
        }

        public class InMatchOfThenExtract<V, X, R>
        implements CollectionStep<V, X> {
            private final Extractor<? extends V, R> extractor;

            @Override
            public <X> MatchingInstance<V, X> thenApply(TypedFunction<V, X> t) {
                return this.addCase(InMatchOfBuilder.this.patternMatcher.inMatchOfThenExtract(InMatchOfBuilder.this.match, t, this.extractor));
            }

            private <T, R> MatchingInstance<T, R> addCase(PatternMatcher o) {
                return new MatchingInstance(InMatchOfBuilder.this.cse.withPatternMatcher(o));
            }

            @ConstructorProperties(value={"extractor"})
            public InMatchOfThenExtract(Extractor<? extends V, R> extractor) {
                this.extractor = extractor;
            }
        }
    }

    public static class InCaseOfBuilderExtractor<T, R, X> {
        private final Extractor<T, R> extractor;
        private final PatternMatcher patternMatcher;
        private final CaseBeingBuilt cse;

        public <V> CollectionStep<V, X> isTrue(Predicate<V> match) {
            return new InCaseOfStep<V>(match);
        }

        public <V> CollectionStep<V, X> isMatch(Matcher<V> match) {
            return new InMatchOf<V>(match);
        }

        public <V> MatchingInstance<T, X> isType(TypedFunction<V, X> a) {
            return this.addCase(this.patternMatcher.inCaseOfType(this.extractor, a));
        }

        public <V> CollectionStep<V, X> isValue(V value) {
            return new InCaseOfValueStep(value);
        }

        private <T, R> MatchingInstance<T, R> addCase(PatternMatcher o) {
            return new MatchingInstance(this.cse.withPatternMatcher(o));
        }

        @ConstructorProperties(value={"extractor", "patternMatcher", "cse"})
        public InCaseOfBuilderExtractor(Extractor<T, R> extractor, PatternMatcher patternMatcher, CaseBeingBuilt cse) {
            this.extractor = extractor;
            this.patternMatcher = patternMatcher;
            this.cse = cse;
        }

        public class InCaseOfValueStep<V, X>
        implements CollectionStep<V, X> {
            private V value;

            @Override
            public <X> MatchingInstance<V, X> thenApply(TypedFunction<V, X> t) {
                return InCaseOfBuilderExtractor.this.addCase(InCaseOfBuilderExtractor.this.patternMatcher.inCaseOfValue(this.value, InCaseOfBuilderExtractor.this.extractor, t));
            }

            @ConstructorProperties(value={"value"})
            public InCaseOfValueStep(V value) {
                this.value = value;
            }
        }

        public class InMatchOf<V>
        implements CollectionStep<V, X> {
            private final Matcher<V> match;

            @Override
            public <X> MatchingInstance<V, X> thenApply(TypedFunction<V, X> t) {
                return InCaseOfBuilderExtractor.this.addCase(InCaseOfBuilderExtractor.this.patternMatcher.inMatchOf(InCaseOfBuilderExtractor.this.extractor, this.match, t));
            }

            @ConstructorProperties(value={"match"})
            public InMatchOf(Matcher<V> match) {
                this.match = match;
            }
        }

        public class InCaseOfStep<V>
        implements CollectionStep<V, X> {
            private final Predicate<V> match;

            @Override
            public <X> MatchingInstance<V, X> thenApply(TypedFunction<V, X> t) {
                return InCaseOfBuilderExtractor.this.addCase(InCaseOfBuilderExtractor.this.patternMatcher.inCaseOf(InCaseOfBuilderExtractor.this.extractor, this.match, t));
            }

            @ConstructorProperties(value={"match"})
            public InCaseOfStep(Predicate<V> match) {
                this.match = match;
            }
        }
    }

    public static class InCaseOfBuilder<V> {
        private final Predicate<V> match;
        private final PatternMatcher matcher;
        private final CaseBeingBuilt cse;

        public <R, X> Step<R, X> thenExtract(Extractor<V, R> extractor) {
            return new InCaseOfThenExtractStep(this.cse, this.matcher, this.match, extractor);
        }

        public <T, X> MatchingInstance<T, X> thenApply(TypedFunction<V, X> a) {
            return this.addCase(this.matcher.inCaseOf(this.match, a));
        }

        public <T, X> MatchingInstance<T, X> thenConsume(Action<V> a) {
            return this.addCase(this.matcher.caseOf(this.match, a));
        }

        private <T, X> MatchingInstance<T, X> addCase(PatternMatcher o) {
            return new MatchingInstance(this.cse.withPatternMatcher(o));
        }

        @ConstructorProperties(value={"match", "matcher", "cse"})
        public InCaseOfBuilder(Predicate<V> match, PatternMatcher matcher, CaseBeingBuilt cse) {
            this.match = match;
            this.matcher = matcher;
            this.cse = cse;
        }
    }

    public static class InCaseOfThenExtractStep<T, X, R>
    implements Step<R, X> {
        private final CaseBeingBuilt cse;
        private final PatternMatcher matcher;
        private final Predicate<T> match;
        private final Extractor<T, R> extractor;

        @Override
        public <X> MatchingInstance<R, X> thenApply(TypedFunction<R, X> t) {
            return this.addCase(this.matcher.inCaseOfThenExtract(this.match, t, this.extractor));
        }

        private <T, X> MatchingInstance<T, X> addCase(PatternMatcher o) {
            return new MatchingInstance(this.cse.withPatternMatcher(o));
        }

        @ConstructorProperties(value={"cse", "matcher", "match", "extractor"})
        public InCaseOfThenExtractStep(CaseBeingBuilt cse, PatternMatcher matcher, Predicate<T> match, Extractor<T, R> extractor) {
            this.cse = cse;
            this.matcher = matcher;
            this.match = match;
            this.extractor = extractor;
        }
    }

    public static class ValueStep<V, X>
    implements Step<V, X> {
        private final CaseBeingBuilt cse;
        private final PatternMatcher matcher;
        private final V value;

        @Override
        public <X> MatchingInstance<V, X> thenApply(TypedFunction<V, X> t) {
            return this.addCase(this.matcher.inCaseOfValue(this.value, t));
        }

        private <T, X> MatchingInstance<T, X> addCase(PatternMatcher o) {
            return new MatchingInstance(this.cse.withPatternMatcher(o));
        }

        @ConstructorProperties(value={"cse", "matcher", "value"})
        public ValueStep(CaseBeingBuilt cse, PatternMatcher matcher, V value) {
            this.cse = cse;
            this.matcher = matcher;
            this.value = value;
        }
    }
}

