/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher.builders;

import com.aol.cyclops.matcher.ActionWithReturn;
import com.aol.cyclops.matcher.Extractor;
import com.aol.cyclops.matcher.Predicates;
import com.aol.cyclops.matcher.Two;
import com.aol.cyclops.matcher.builders.CaseBeingBuilt;
import com.aol.cyclops.matcher.builders.CaseBuilder;
import com.aol.cyclops.matcher.builders.ExtractionStep;
import com.aol.cyclops.matcher.builders.MatchingInstance;
import com.aol.cyclops.matcher.builders.PatternMatcher;
import com.aol.cyclops.matcher.builders.Step;
import com.nurkiewicz.lazyseq.LazySeq;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;

public class IterableCase<X>
extends CaseBeingBuilt {
    private final PatternMatcher patternMatcher;

    @SafeVarargs
    public final <V> CaseBuilder.InCaseOfManyStep2<V> allTrue(Predicate<V> ... predicates) {
        return new CaseBuilder.InCaseOfManyStep2<V>(predicates, this.patternMatcher, this);
    }

    public final <R, V, V1, T, X> ExtractionStep<T, R, X> bothTrue(final Predicate<V> pred1, final Predicate<V1> pred2) {
        return new ExtractionStep<T, R, X>(){

            @Override
            public <T, R> Step<R, X> thenExtract(final Extractor<T, R> extractor) {
                return new Step<R, X>(){

                    @Override
                    public <X> MatchingInstance<R, X> thenApply(ActionWithReturn<R, X> t) {
                        return IterableCase.this.addCase(IterableCase.this.patternMatcher.inCaseOfPredicates(Two.tuple(pred1, pred2), t, extractor));
                    }
                };
            }
        };
    }

    public final <R, V, V1, V2, T, X> ExtractionStep<T, R, X> threeTrue(Predicate<V> pred1, Predicate<V1> pred2, Predicate<V2> pred3) {
        return this.allTrueNoType(pred1, pred2, pred3);
    }

    @SafeVarargs
    public final <R, V, T, X> ExtractionStep<T, R, X> allTrueNoType(final Predicate<? extends Object> ... predicates) {
        return new ExtractionStep<T, R, X>(){

            @Override
            public <T, R> Step<R, X> thenExtract(final Extractor<T, R> extractor) {
                return new Step<R, X>(){

                    @Override
                    public <X> MatchingInstance<R, X> thenApply(ActionWithReturn<R, X> t) {
                        return IterableCase.this.addCase(IterableCase.this.patternMatcher.inCaseOfStream(Stream.of(predicates), t, extractor));
                    }
                };
            }
        };
    }

    @SafeVarargs
    public final <R, V, T> ExtractionStep<T, R, X> allHoldNoType(Object ... predicates) {
        return this.allTrueNoType(this.convert(predicates));
    }

    private Predicate[] convert(Object[] predicates) {
        return Stream.of(predicates).map(this::convertToPredicate).collect(Collectors.toList()).toArray(new Predicate[0]);
    }

    @SafeVarargs
    public final <R, V, T, X> CaseBuilder.InMatchOfManyStep2<R, V, T, X> allMatch(Matcher<V> ... predicates) {
        return new CaseBuilder.InMatchOfManyStep2(predicates, this.patternMatcher, this);
    }

    public final <T, R, V, V1> ExtractionStep<T, R, X> bothMatch(final Matcher<V> pred1, final Matcher<V1> pred2) {
        return new ExtractionStep<T, R, X>(){

            @Override
            public <T, R> Step<R, X> thenExtract(final Extractor<T, R> extractor) {
                return new Step<R, X>(){

                    @Override
                    public <X> MatchingInstance<R, X> thenApply(ActionWithReturn<R, X> t) {
                        return IterableCase.this.addCase(IterableCase.this.patternMatcher.inMatchOfMatchers(Two.tuple(pred1, pred2), t, extractor));
                    }
                };
            }
        };
    }

    @SafeVarargs
    public final <R, V, T, X> ExtractionStep<T, R, X> allMatchNoType(final Matcher ... predicates) {
        return new ExtractionStep<T, R, X>(){

            @Override
            public <T, R> Step<R, X> thenExtract(final Extractor<T, R> extractor) {
                return new Step<R, X>(){

                    @Override
                    public <X> MatchingInstance<R, X> thenApply(ActionWithReturn<R, X> t) {
                        return IterableCase.this.addCase(IterableCase.this.patternMatcher.inMatchOfSeq(Stream.of(predicates), t, extractor));
                    }
                };
            }
        };
    }

    @SafeVarargs
    public final <V, T, X> Step<List<V>, X> allValues(V ... values) {
        final Predicate[] predicates = LazySeq.of((Object[])values).map(nextValue -> this.buildPredicate(nextValue)).toList().toArray(new Predicate[0]);
        return new Step<List<V>, X>(){

            @Override
            public <X> MatchingInstance<List<V>, X> thenApply(ActionWithReturn<List<V>, X> t) {
                return IterableCase.this.addCase(IterableCase.this.patternMatcher.inCaseOfMany(t, predicates));
            }
        };
    }

    private <T, R> MatchingInstance<T, R> addCase(PatternMatcher o) {
        return new MatchingInstance(this.withPatternMatcher(o));
    }

    private <V> Predicate<Object> buildPredicate(V nextValue) {
        if (Predicates.ANY() == nextValue) {
            return Predicates.ANY();
        }
        return Predicates.p(test -> Objects.equals(test, nextValue));
    }

    IterableCase(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    @Override
    PatternMatcher getPatternMatcher() {
        return this.patternMatcher;
    }

    @Override
    IterableCase<X> withPatternMatcher(PatternMatcher patternMatcher) {
        return this.patternMatcher == patternMatcher ? this : new IterableCase<X>(patternMatcher);
    }
}

