/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.ActionWithReturn;
import com.aol.cyclops.matcher.Matchable;
import com.aol.cyclops.matcher.builders.CheckValues;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MatchableTest {
    private <I, T> CheckValues<Object, T> cases(CheckValues<I, T> c) {
        return c.with((Object[])new Integer[]{1, 2, 3}).then((ActionWithReturn & Serializable)i -> "hello").with((Object[])new Integer[]{4, 5, 6}).then((ActionWithReturn & Serializable)i -> "goodbye");
    }

    @Test
    public void test() {
        Assert.assertThat((Object)new MyCase(1, 2, 3).match(this::cases), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    public void test2() {
        Assert.assertThat((Object)new MyCase(4, 5, 6).match(this::cases), (Matcher)Matchers.equalTo((Object)"goodbye"));
    }

    @Test
    public void test3() {
        Assert.assertThat((Object)new MyCase(4, 2, 3).match(this::cases, "default"), (Matcher)Matchers.equalTo((Object)"default"));
    }

    @Test
    public void test_() {
        Assert.assertThat((Object)new MyCase(4, 5, 6)._match(c -> c.isType((ActionWithReturn & Serializable)ce -> "hello").with((Object[])new Integer[]{1, 2, 3}), "goodbye"), (Matcher)Matchers.equalTo((Object)"goodbye"));
    }

    @Test
    public void test_2() {
        Assert.assertThat((Object)new MyCase(4, 5, 6)._match(c -> c.isType((ActionWithReturn & Serializable)ce -> "hello").with((Object[])new Integer[]{4, 5, 6}), "goodbye"), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    @Test
    public void testMatch() {
        Assert.assertThat((Object)new MyCase(4, 5, 6).matchType(c -> c.isType((ActionWithReturn & Serializable)ce -> "hello")), (Matcher)Matchers.equalTo((Object)"hello"));
    }

    static final class MyCase
    implements Matchable {
        private final int a;
        private final int b;
        private final int c;

        @ConstructorProperties(value={"a", "b", "c"})
        public MyCase(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public int getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public int getC() {
            return this.c;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MyCase)) {
                return false;
            }
            MyCase other = (MyCase)o;
            if (this.getA() != other.getA()) {
                return false;
            }
            if (this.getB() != other.getB()) {
                return false;
            }
            return this.getC() == other.getC();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getA();
            result = result * 59 + this.getB();
            result = result * 59 + this.getC();
            return result;
        }

        public String toString() {
            return "MatchableTest.MyCase(a=" + this.getA() + ", b=" + this.getB() + ", c=" + this.getC() + ")";
        }
    }
}

