/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.lambda.api.Decomposable;
import com.aol.cyclops.matcher.Case;
import com.aol.cyclops.matcher.Cases;
import com.aol.cyclops.matcher.Two;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.pcollections.PStack;

public class CasesTest {
    int found;

    @Test
    public void ofPStack() {
        Cases cases = Cases.ofList(Arrays.asList(Case.of(input -> true, input -> "hello")));
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void ofVarargs() {
        Cases cases = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")});
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testZip() {
        Stream<Predicate> predicates = Stream.of(i -> true, i -> false);
        Stream<Function> functions = Stream.of(i -> i + 2, i -> i * 100);
        Cases cases = Cases.zip(predicates, functions);
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(cases.match((Object)100).get(), (Matcher)Matchers.is((Object)102));
    }

    @Test
    public void testUnzip() {
        Cases cases = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")});
        Two unzipped = cases.unzip();
        Assert.assertTrue((boolean)((Stream)unzipped.v1).map(p -> p.test(10)).allMatch(v -> v));
        Assert.assertTrue((boolean)((Stream)unzipped.v2).map(fn -> fn.apply(10)).allMatch(v -> "hello".equals(v)));
    }

    @Test
    public void testForEach() {
        this.found = 0;
        Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")}).forEach(cse -> ++this.found);
        Assert.assertTrue((this.found == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSequential() {
        HashSet threads = new HashSet();
        Case case1 = Case.of(input -> true, input -> {
            threads.add(Thread.currentThread().getId());
            return "hello";
        });
        Cases.of((Case[])new Case[]{case1, case1, case1, case1}).sequential().match((Object)10);
        Assert.assertThat((Object)threads.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testParallel() {
        HashSet threads = new HashSet();
        Case case1 = Case.of(input -> true, input -> {
            threads.add(Thread.currentThread().getId());
            return "hello";
        });
        Cases.of((Case[])new Case[]{case1, case1, case1, case1}).parallel().match((Object)10);
        Assert.assertThat((Object)threads.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void testMerge() {
        Cases cases1 = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")});
        Cases cases2 = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")});
        Cases cases3 = cases1.merge(cases2);
        Assert.assertThat((Object)cases3.size(), (Matcher)Matchers.is((Object)(cases1.size() + cases2.size())));
    }

    @Test
    public void testFilter() {
        Cases cases = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> false, input -> "second")}).filter(p -> p.getPredicate().test(10));
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testFilterPredicate() {
        Cases cases = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> false, input -> "second")}).filterPredicate(p -> p.test(10));
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testFilterFunction() {
        Cases cases = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> false, input -> "second")}).filterFunction(fn -> fn.apply(10).equals("second"));
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testMapPredicate() {
        List results = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> false, input -> "second")}).mapPredicate(p -> input -> true).matchMany((Object)10).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testMapFunction() {
        List results = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> true, input -> "second")}).mapFunction(fn -> input -> "prefix_" + fn.apply(input)).matchMany((Object)10).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertTrue((boolean)results.stream().allMatch(s -> s.startsWith("prefix_")));
        Assert.assertTrue((boolean)results.stream().anyMatch(s -> s.startsWith("prefix_hello")));
        Assert.assertTrue((boolean)results.stream().anyMatch(s -> s.startsWith("prefix_second")));
    }

    @Test
    public void testMap() {
        List results = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> false, input -> "second")}).map(cse -> Case.of(t -> true, input -> "prefix_" + cse.getAction().apply(input))).matchMany((Object)10).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertTrue((boolean)results.stream().allMatch(s -> s.startsWith("prefix_")));
        Assert.assertTrue((boolean)results.stream().anyMatch(s -> s.startsWith("prefix_hello")));
        Assert.assertTrue((boolean)results.stream().anyMatch(s -> s.startsWith("prefix_second")));
    }

    @Test
    public void flatMap() {
        Case cse = Case.of(input -> input instanceof Person, input -> ((Person)input).getAge());
        Assert.assertThat(Cases.of((Case[])new Case[]{cse}).flatMap(c -> Cases.ofList(Arrays.asList(c.andThen(Case.of(age -> age < 18, s -> "minor")), c.andThen(Case.of(age -> age >= 18, s -> "adult"))))).match((Object)new Person("bob", 21)).get(), (Matcher)Matchers.is((Object)"adult"));
    }

    @Test
    public void testFlatMapAll() {
        Cases cases = Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello"), Case.of(input -> false, input -> "second")}).flatMapAll(input -> Cases.ofPStack((PStack)input.plus((Object)Case.of(in -> true, in -> "new"))));
        Assert.assertThat((Object)cases.size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testAppend() {
        Cases cases1 = Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 11 == input, input -> "world")});
        Case caze = Case.of(input -> 11 == input, input -> "hello");
        Cases cases3 = cases1.append(1, caze);
        Assert.assertThat((Object)cases3.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat(cases3.match((Object)11).get(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testAsUnwrappedFunction() {
        Assert.assertThat(Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")}).asUnwrappedFunction().apply(10), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testAsStreamFunction() {
        Assert.assertThat(((Stream)Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")}).asStreamFunction().apply(10)).findFirst().get(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testApply() {
        Assert.assertThat(Cases.of((Case[])new Case[]{Case.of(input -> true, input -> "hello")}).apply((Object)10).get(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testMatchManyFromStream() {
        List results = Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 11 == input, input -> "world")}).matchManyFromStream(Stream.of(1, 10, 11)).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"hello"));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"world"));
    }

    @Test
    public void testMatchManyFromStreamAsync() {
        List results = ((Stream)Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 11 == input, input -> "world")}).matchManyFromStreamAsync((Executor)ForkJoinPool.commonPool(), Stream.of(1, 10, 11)).join()).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"hello"));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"world"));
    }

    @Test
    public void testMatchMany() {
        List results = Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 11 == input, input -> "world"), Case.of(input -> 10 == input, input -> "woo!")}).matchMany((Object)10).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"hello"));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"woo!"));
    }

    @Test
    public void testMatchManyAsync() {
        List results = ((Stream)Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 11 == input, input -> "world"), Case.of(input -> 10 == input, input -> "woo!")}).matchManyAsync((Executor)ForkJoinPool.commonPool(), (Object)10).join()).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"hello"));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"woo!"));
    }

    @Test
    public void testMatchFromStream() {
        List results = Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 10 == input, input -> "ignored"), Case.of(input -> 11 == input, input -> "world")}).matchFromStream(Stream.of(1, 11, 10)).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"hello"));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"world"));
    }

    @Test
    public void testMatchFromStreamAsync() {
        List results = ((Stream)Cases.of((Case[])new Case[]{Case.of(input -> 10 == input, input -> "hello"), Case.of(input -> 10 == input, input -> "ignored"), Case.of(input -> 11 == input, input -> "world")}).matchFromStreamAsync((Executor)ForkJoinPool.commonPool(), Stream.of(1, 11, 10)).join()).collect(Collectors.toList());
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"hello"));
        Assert.assertThat(results, (Matcher)Matchers.hasItem((Object)"world"));
    }

    @Test
    public void testMatchObjectArray() {
        Assert.assertThat(Cases.of((Case[])new Case[]{Case.of(input -> input.size() == 3, input -> "hello"), Case.of(input -> input.size() == 2, input -> "ignored"), Case.of(input -> input.size() == 1, input -> "world")}).match(new Object[]{1, 2, 3}).get(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testMatchAsync() {
        Assert.assertThat(((Optional)Cases.of((Case[])new Case[]{Case.of(input -> input.size() == 3, input -> "hello"), Case.of(input -> input.size() == 2, input -> "ignored"), Case.of(input -> input.size() == 1, input -> "world")}).matchAsync((Executor)ForkJoinPool.commonPool(), new Object[]{1, 2, 3}).join()).get(), (Matcher)Matchers.is((Object)"hello"));
    }

    @Test
    public void testUnapply() {
        Assert.assertThat(Cases.of((Case[])new Case[]{Case.of(input -> input.size() == 3, input -> "hello"), Case.of(input -> input.size() == 2, input -> "ignored"), Case.of(input -> input.size() == 1, input -> "world")}).unapply((Decomposable)new MyClass(1, "hello")).get(), (Matcher)Matchers.is((Object)"ignored"));
    }

    static class MyClass
    implements Decomposable {
        int value;
        String name;

        @ConstructorProperties(value={"value", "name"})
        public MyClass(int value, String name) {
            this.value = value;
            this.name = name;
        }
    }

    static class Person {
        String name;
        int age;

        @ConstructorProperties(value={"name", "age"})
        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }
    }
}

