/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.matcher;

import com.aol.cyclops.matcher.ActionWithReturn;
import com.aol.cyclops.matcher.builders.Matching;
import com.aol.cyclops.matcher.builders.PatternMatcher;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MatchManyTest {
    int found = 0;

    @Test
    public void matchManyFromStream() {
        this.found = 0;
        List<Object> data = new PatternMatcher().inCaseOfType((ActionWithReturn & Serializable)s -> s.trim()).inCaseOfType((ActionWithReturn & Serializable)i -> i + 100).inCaseOfValue((Object)100, (ActionWithReturn & Serializable)i -> "jackpot").matchManyFromStream(Stream.of(Integer.valueOf(100), 200, 300, 100, " hello ")).collect(Collectors.toList());
        Assert.assertThat(data, (Matcher)Matchers.hasItem((Object)"jackpot"));
        Assert.assertThat(data, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(data, (Matcher)Matchers.hasItem((Object)"hello"));
        data.forEach(next -> {
            if ("jackpot".equals(next)) {
                ++this.found;
            }
        });
        ++this.found;
    }

    @Test
    public void matchMany() {
        List data = new PatternMatcher().inCaseOfType((ActionWithReturn & Serializable)s -> s.trim()).inCaseOfType((ActionWithReturn & Serializable)i -> i + 100).inCaseOfValue((Object)100, (ActionWithReturn & Serializable)i -> "jackpot").matchMany((Object)100).collect(Collectors.toList());
        Assert.assertThat((Object)data.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat(data, (Matcher)Matchers.hasItem((Object)"jackpot"));
        Assert.assertThat(data, (Matcher)Matchers.hasItem((Object)200));
    }

    @Test
    public void optionalFlatMap() {
        System.out.println(Optional.of(100).flatMap(Matching.when().isValue((Object)100).thenApply((ActionWithReturn & Serializable)i -> i + 10)).get());
    }

    @Test
    public void unwrapped() {
        Integer num = (Integer)Stream.of(Integer.valueOf(1)).map(Matching.when().isValue((Object)1).thenApply((ActionWithReturn & Serializable)i -> i + 10).asUnwrappedFunction()).findFirst().get();
        Assert.assertThat((Object)num, (Matcher)Matchers.is((Object)11));
    }

    @Test(expected=NoSuchElementException.class)
    public void unwrappedMissing() {
        Integer num = (Integer)Stream.of(Integer.valueOf(10)).map(Matching.when().isValue((Object)1).thenApply((ActionWithReturn & Serializable)i -> i + 10).asUnwrappedFunction()).findFirst().get();
        Assert.fail((String)"unreachable");
    }

    @Test
    public void streamMap() {
        Integer num = (Integer)Stream.of(Integer.valueOf(1)).map(Matching.when().isValue((Object)1).thenApply((ActionWithReturn & Serializable)i -> i + 10).asUnwrappedFunction()).findFirst().get();
        Assert.assertThat((Object)num, (Matcher)Matchers.is((Object)11));
    }

    @Test
    public void stream() {
        Integer num = (Integer)Stream.of(Integer.valueOf(1)).flatMap(Matching.when().isValue((Object)1).thenApply((ActionWithReturn & Serializable)i -> i + 10).asStreamFunction()).findFirst().get();
        Assert.assertThat((Object)num, (Matcher)Matchers.is((Object)11));
    }

    @Test(expected=NoSuchElementException.class)
    public void streamdMissing() {
        Integer num = (Integer)Stream.of(Integer.valueOf(10)).flatMap(Matching.when().isValue((Object)1).thenApply((ActionWithReturn & Serializable)i -> i + 10).asStreamFunction()).findFirst().get();
        Assert.fail((String)"unreachable");
    }

    @Test
    public void matchFromStream() {
    }
}

