/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads.transformers;

import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.SequenceM;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.lambda.function.Function1;

public class ListT<T> {
    final AnyM<List<T>> run;

    private ListT(AnyM<List<T>> run) {
        this.run = run;
    }

    public AnyM<List<T>> unwrap() {
        return this.run;
    }

    public ListT<T> peek(Consumer<T> peek) {
        return this.map(a -> {
            peek.accept(a);
            return a;
        });
    }

    public ListT<T> filter(Predicate<T> test) {
        return ListT.of(this.run.map(stream -> SequenceM.fromList((List)stream).filter(test).toList()));
    }

    public <B> ListT<B> map(Function<T, B> f) {
        return ListT.of(this.run.map(o -> SequenceM.fromList((List)o).map(f).toList()));
    }

    public <B> ListT<B> flatMap(Function1<T, ListT<B>> f) {
        return ListT.of(this.run.map(stream -> SequenceM.fromList((List)stream).flatMap(a -> ((ListT)function1.apply((Object)a)).run.asSequence()).flatMap(a -> a.stream()).toList()));
    }

    public static <U, R> Function<ListT<U>, ListT<R>> lift(Function<U, R> fn) {
        return optTu -> optTu.map(input -> fn.apply(input));
    }

    public static <U1, U2, R> BiFunction<ListT<U1>, ListT<U2>, ListT<R>> lift2(BiFunction<U1, U2, R> fn) {
        return (optTu1, optTu2) -> optTu1.flatMap(input1 -> optTu2.map(input2 -> fn.apply(input1, input2)));
    }

    public static <A> ListT<A> fromAnyM(AnyM<A> anyM) {
        return ListT.of(anyM.map(xva$0 -> Arrays.asList(xva$0)));
    }

    public static <A> ListT<A> of(AnyM<List<A>> monads) {
        return new ListT<A>(monads);
    }

    public static <A> ListT<A> fromStream(AnyM<Stream<A>> monads) {
        return ListT.of(monads.map(s -> s.collect(Collectors.toList())));
    }

    public String toString() {
        return this.run.toString();
    }
}

