/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.comprehensions.comprehenders.MaterializedList;
import com.aol.cyclops.internal.Monad;
import com.aol.cyclops.lambda.monads.AnyMForComprehensionFactory;
import com.aol.cyclops.lambda.monads.ComprehenderSelector;
import com.aol.cyclops.monad.AnyM;
import com.aol.cyclops.sequence.Monoid;
import com.aol.cyclops.sequence.SequenceM;
import com.aol.cyclops.sequence.streamable.Streamable;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AnyMImpl<T>
implements AnyM<T> {
    private final Monad<Object, T> monad;
    private final Class initialType;

    public final <R> R unwrap() {
        return (R)new ComprehenderSelector().selectComprehender(this.initialType).unwrap(this.monad.unwrap());
    }

    public final <R, A> R collect(Collector<? super T, A, R> collector) {
        Monad<Object, T> o = this.monad;
        if (o instanceof Stream) {
            return ((Stream)((Object)o)).collect(collector);
        }
        return (R)this.toSequence().collect(collector);
    }

    public final Monad monad() {
        return this.monad;
    }

    public final AnyM<T> filter(Predicate<? super T> fn) {
        return this.monad.filter((Predicate)fn).anyM();
    }

    public final <R> AnyM<R> map(Function<? super T, ? extends R> fn) {
        return this.monad.map((Function)fn).anyM();
    }

    public final AnyM<T> peek(Consumer<? super T> c) {
        return this.monad.peek((Consumer)c).anyM();
    }

    public final <R> AnyM<R> bind(Function<? super T, ?> fn) {
        return this.monad.bind(fn).anyM();
    }

    public final <R> AnyM<R> liftAndBind(Function<? super T, ?> fn) {
        return this.monad.liftAndBind(fn).anyM();
    }

    public final AnyM<Character> flatMapCharSequence(Function<? super T, CharSequence> fn) {
        try {
            return this.monad.liftAndBind(fn).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    private <T> T takeFirst(Object o) {
        if (o instanceof MaterializedList) {
            if (((List)o).size() == 0) {
                throw new GotoAsEmpty();
            }
            return (T)((List)o).get(0);
        }
        return (T)o;
    }

    public final AnyM<String> flatMapFile(Function<? super T, File> fn) {
        try {
            return this.monad.liftAndBind(fn).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final AnyM<String> flatMapURL(Function<? super T, URL> fn) {
        try {
            return this.monad.liftAndBind(fn).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final AnyM<String> flatMapBufferedReader(Function<? super T, BufferedReader> fn) {
        try {
            return this.monad.liftAndBind(fn).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final <T1> AnyM<T1> flatten() {
        return this.monad.flatten().anyM();
    }

    public final AnyM<List<T>> aggregate(AnyM<T> next) {
        return this.unit(Stream.concat(this.stream(), next.stream()).collect(Collectors.toList()));
    }

    public final <R> AnyM<List<R>> aggregateUntyped(AnyM<?> next) {
        return this.monad.aggregate((Monad)next.monad()).anyM();
    }

    public void forEach(Consumer<? super T> action) {
        this.asSequence().forEach(action);
    }

    public final <R> AnyM<R> flatMap(Function<? super T, AnyM<? extends R>> fn) {
        try {
            return this.monad.flatMap((? super T in) -> ((AnyM)fn.apply(in)).unwrap()).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final <R> AnyM<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        try {
            return this.monad.flatMap((? super T in) -> (BaseStream)fn.apply(in)).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final <R> AnyM<R> flatMapStreamable(Function<? super T, Streamable<R>> fn) {
        try {
            return this.monad.flatMap((? super T in) -> (Streamable)fn.apply(in)).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final <R> AnyM<R> flatMapCollection(Function<? super T, Collection<? extends R>> fn) {
        try {
            return this.monad.flatMap((? super T in) -> (Collection)fn.apply(in)).anyM().map(this::takeFirst);
        }
        catch (GotoAsEmpty e) {
            return this.empty();
        }
    }

    public final <R> AnyM<R> flatMapOptional(Function<? super T, Optional<? extends R>> fn) {
        return this.monad.flatMap((? super T in) -> (Optional)fn.apply(in)).anyM();
    }

    public final <R> AnyM<R> flatMapCompletableFuture(Function<? super T, CompletableFuture<? extends R>> fn) {
        return this.monad.flatMap((? super T in) -> (CompletableFuture)fn.apply(in)).anyM();
    }

    public final <R> AnyM<R> flatMapSequenceM(Function<? super T, SequenceM<? extends R>> fn) {
        return this.monad.flatMap((? super T in) -> ((SequenceM)fn.apply(in)).unwrap()).anyM();
    }

    public final <NT> SequenceM<NT> toSequence(Function<T, Stream<NT>> fn) {
        return this.monad.flatMapToStream(fn).sequence();
    }

    public final <T> SequenceM<T> toSequence() {
        return this.monad.streamedMonad().sequence();
    }

    public final SequenceM<T> asSequence() {
        return this.monad.sequence();
    }

    public final <R> AnyM<R> applyM(AnyM<Function<? super T, ? extends R>> fn) {
        return this.monad.applyM((Monad)fn.monad()).anyM();
    }

    public <T> AnyM<T> unit(T value) {
        return AnyM.ofMonad((Object)this.monad.unit(value));
    }

    public <T> AnyM<T> empty() {
        return (AnyMImpl)this.unit(null).filter(t -> false);
    }

    public final AnyM<List<T>> replicateM(int times) {
        return this.monad.replicateM(times).anyM();
    }

    public final AnyM<T> reduceMOptional(Monoid<Optional<T>> reducer) {
        return this.monad.reduceM(reducer).anyM();
    }

    public final AnyM<T> reduceMStream(Monoid<Stream<T>> reducer) {
        return this.monad.reduceM(reducer).anyM();
    }

    public final AnyM<T> reduceMStreamable(Monoid<Streamable<T>> reducer) {
        return this.monad.reduceM(reducer).anyM();
    }

    public final AnyM<T> reduceMIterable(Monoid<Iterable<T>> reducer) {
        return this.monad.reduceM(reducer).anyM();
    }

    public final AnyM<T> reduceMCompletableFuture(Monoid<CompletableFuture<T>> reducer) {
        return this.monad.reduceM(reducer).anyM();
    }

    public final AnyM<T> reduceM(Monoid<AnyM<T>> reducer) {
        return this.monad.reduceM(Monoid.of((Object)((AnyM)reducer.zero()).unwrap(), (a, b) -> (AnyM)reducer.combiner().apply(AnyM.ofMonad((Object)a), AnyM.ofMonad((Object)b)))).anyM();
    }

    public SequenceM<T> stream() {
        if (this.monad.unwrap() instanceof Stream) {
            return this.asSequence();
        }
        return this.toSequence();
    }

    public String toString() {
        return String.format("AnyM(%s)", this.monad);
    }

    public List<T> toList() {
        if (this.monad.unwrap() instanceof Stream) {
            return this.asSequence().toList();
        }
        return this.toSequence().toList();
    }

    public Set<T> toSet() {
        if (this.monad.unwrap() instanceof Stream) {
            return this.asSequence().toSet();
        }
        return this.toSequence().toSet();
    }

    public Iterator<T> iterator() {
        return null;
    }

    public <R> AnyM<R> applyMStream(Stream<Function<? super T, ? extends R>> fn) {
        return this.applyM(AnyM.fromStream(fn));
    }

    public <R> AnyM<R> applyMOptional(Optional<Function<? super T, ? extends R>> fn) {
        return this.applyM(AnyM.fromOptional(fn));
    }

    public <R> AnyM<R> applyMCompletableFuture(CompletableFuture<Function<? super T, ? extends R>> fn) {
        return this.applyM(AnyM.fromCompletableFuture(fn));
    }

    public <R1, R> AnyM<R> forEach2(Function<? super T, ? extends AnyM<R1>> monad, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        if (AnyMForComprehensionFactory.instance == null) {
            System.err.println("ERROR : Unable to use AnyM for-comprehensions without cyclops-for-comprehensions on the classpath");
        }
        return AnyMForComprehensionFactory.instance.forEach2(this, monad, yieldingFunction);
    }

    public <R1, R> AnyM<R> forEach2(Function<? super T, ? extends AnyM<R1>> monad, Function<? super T, Function<? super R1, Boolean>> filterFunction, Function<? super T, Function<? super R1, ? extends R>> yieldingFunction) {
        if (AnyMForComprehensionFactory.instance == null) {
            System.err.println("ERROR : Unable to use AnyM for-comprehensions without cyclops-for-comprehensions on the classpath");
        }
        return AnyMForComprehensionFactory.instance.forEach2(this, monad, filterFunction, yieldingFunction);
    }

    public <R1, R2, R> AnyM<R> forEach3(Function<? super T, ? extends AnyM<R1>> monad1, Function<? super T, Function<? super R1, ? extends AnyM<R2>>> monad2, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        if (AnyMForComprehensionFactory.instance == null) {
            System.err.println("ERROR : Unable to use AnyM for-comprehensions without cyclops-for-comprehensions on the classpath");
        }
        return AnyMForComprehensionFactory.instance.forEach3(this, monad1, monad2, yieldingFunction);
    }

    public <R1, R2, R> AnyM<R> forEach3(Function<? super T, ? extends AnyM<R1>> monad1, Function<? super T, Function<? super R1, ? extends AnyM<R2>>> monad2, Function<? super T, Function<? super R1, Function<? super R2, Boolean>>> filterFunction, Function<? super T, Function<? super R1, Function<? super R2, ? extends R>>> yieldingFunction) {
        if (AnyMForComprehensionFactory.instance == null) {
            System.err.println("ERROR : Unable to use AnyM for-comprehensions without cyclops-for-comprehensions on the classpath");
        }
        return AnyMForComprehensionFactory.instance.forEach3(this, monad1, monad2, filterFunction, yieldingFunction);
    }

    @ConstructorProperties(value={"monad", "initialType"})
    protected AnyMImpl(Monad<Object, T> monad, Class initialType) {
        this.monad = monad;
        this.initialType = initialType;
    }

    private static class GotoAsEmpty
    extends RuntimeException {
        private GotoAsEmpty() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

