/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams;

import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.lambda.api.AsStreamable;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.lambda.utils.Mutable;
import com.aol.cyclops.streams.HeadAndTail;
import com.aol.cyclops.streams.Pair;
import com.aol.cyclops.streams.ReversedIterator;
import com.nurkiewicz.lazyseq.LazySeq;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;

public class StreamUtils {
    public static final <T> Stream<T> optionalToStream(Optional<T> optional) {
        if (optional.isPresent()) {
            return Stream.of(optional.get());
        }
        return Stream.of(new Object[0]);
    }

    public static final <T> Stream<T> completableFutureToStream(CompletableFuture<T> future) {
        return Stream.of(future.join());
    }

    public static final <T> Stream<T> cycle(Stream<T> stream, Monoid<T> m, int times) {
        return StreamUtils.cycle(times, AsStreamable.asStreamable(m.reduce(stream)));
    }

    public static final <T> HeadAndTail<T> headAndTail(Stream<T> stream) {
        Iterator it = stream.iterator();
        return new HeadAndTail(it.next(), AsAnyM.anyM(StreamUtils.stream(it)).asSequence());
    }

    public static final <T> Optional<HeadAndTail<T>> headAndTailOptional(Stream<T> stream) {
        Iterator it = stream.iterator();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(new HeadAndTail(it.next(), AsAnyM.anyM(StreamUtils.stream(it)).asSequence()));
    }

    public static <U> Stream<U> skipUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return StreamUtils.skipWhile(stream, predicate.negate());
    }

    public static <U> Stream<U> skipWhile(Stream<U> stream, final Predicate<? super U> predicate) {
        final Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<U>(){
            U next;
            boolean nextSet = false;
            boolean init = false;

            @Override
            public boolean hasNext() {
                if (this.init) {
                    return it.hasNext();
                }
                try {
                    while (it.hasNext()) {
                        this.next = it.next();
                        this.nextSet = true;
                        if (predicate.test(this.next)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.init = true;
                }
            }

            @Override
            public U next() {
                if (!this.init) {
                    this.hasNext();
                }
                if (this.nextSet) {
                    this.nextSet = false;
                    return this.next;
                }
                return it.next();
            }
        });
    }

    public static <U> Stream<U> limitWhile(Stream<U> stream, final Predicate<? super U> predicate) {
        final Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<U>(){
            U next;
            boolean nextSet = false;
            boolean stillGoing = true;

            @Override
            public boolean hasNext() {
                if (!this.stillGoing) {
                    return false;
                }
                if (this.nextSet) {
                    return this.stillGoing;
                }
                if (it.hasNext()) {
                    this.next = it.next();
                    this.nextSet = true;
                    if (!predicate.test(this.next)) {
                        this.stillGoing = false;
                    }
                } else {
                    this.stillGoing = false;
                }
                return this.stillGoing;
            }

            @Override
            public U next() {
                if (this.nextSet) {
                    this.nextSet = false;
                    return this.next;
                }
                Object local = it.next();
                if (this.stillGoing) {
                    this.stillGoing = !predicate.test(local);
                }
                return local;
            }
        });
    }

    public static <U> Stream<U> limitUntil(Stream<U> stream, Predicate<? super U> predicate) {
        return StreamUtils.limitWhile(stream, predicate.negate());
    }

    public static <U> Stream<U> reverse(Stream<U> stream) {
        return StreamUtils.reversedStream(stream.collect(Collectors.toList()));
    }

    public static <U> Stream<U> reversedStream(List<U> list) {
        return new ReversedIterator<U>(list).stream();
    }

    public static <U> Stream<U> cycle(Stream<U> s) {
        return StreamUtils.cycle(AsStreamable.asStreamable(s));
    }

    public static <U> Stream<U> cycle(Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).flatMap(Function.identity());
    }

    public static <U> Stream<U> cycle(int times, Streamable<U> s) {
        return Stream.iterate(s.stream(), s1 -> s.stream()).limit(times).flatMap(Function.identity());
    }

    public static <U> Stream<U> stream(Iterable<U> it) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    public static <U> Stream<U> stream(Spliterator<U> it) {
        return StreamSupport.stream(it, false);
    }

    public static <U> Stream<U> stream(Iterator<U> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    public static <U> Stream<U> concat(Object o, Stream<U> stream) {
        Stream<Object> first = null;
        first = o instanceof Stream ? (Stream<U>)o : (o instanceof Iterable ? StreamUtils.stream((Iterable)o) : (o instanceof Streamable ? ((Streamable)o).stream() : Stream.of(o)));
        return Stream.concat(first, stream);
    }

    public static <K, V> Stream<Map.Entry<K, V>> stream(Map<K, V> it) {
        return it.entrySet().stream();
    }

    public static <R> List<R> reduce(Stream<R> stream, final Iterable<Monoid<R>> reducers) {
        Monoid m = new Monoid(){

            public List zero() {
                return StreamUtils.stream(reducers).map(r -> r.zero()).collect(Collectors.toList());
            }

            public BiFunction<List, List, List> combiner() {
                return (c1, c2) -> {
                    ArrayList l = new ArrayList();
                    int i = 0;
                    for (Monoid next : reducers) {
                        l.add(next.combiner().apply(c1.get(i), c2.get(0)));
                        ++i;
                    }
                    return l;
                };
            }

            public Stream mapToType(Stream stream) {
                return stream.map(value -> Arrays.asList(value));
            }
        };
        return (List)m.mapReduce(stream);
    }

    public static <R> List<R> reduce(Stream<R> stream, Stream<Monoid<R>> reducers) {
        return StreamUtils.reduce(stream, reducers.collect(Collectors.toList()));
    }

    public static <T, A, R> List<R> collect(Stream<T> stream, Stream<Collector> collectors) {
        return StreamUtils.collect(stream, AsStreamable.asStreamable(collectors));
    }

    public static <T, A, R> List<R> collect(Stream<T> stream, Iterable<Collector> collectors) {
        return StreamUtils.collect(stream, AsStreamable.asStreamable(collectors));
    }

    public static <T> List collect(Stream<T> stream, Streamable<Collector> collectors) {
        Supplier<Object> supplier = () -> collectors.stream().map(c -> c.supplier().get()).collect(Collectors.toList());
        BiConsumer<Object, Object> accumulator = (acc, next) -> LazySeq.of(collectors.stream().iterator()).zip(LazySeq.of((Iterable)((List)acc)), (a, b) -> new Pair<Collector, Object>((Collector)a, b)).forEach(t -> ((Collector)t._1()).accumulator().accept(t._2(), next));
        BinaryOperator combiner = (t1, t2) -> {
            Iterator t1It = ((Iterable)t1).iterator();
            Iterator t2It = ((Iterable)t2).iterator();
            return collectors.stream().map(c -> c.combiner().apply(t1It.next(), t2It.next())).collect(Collectors.toList());
        };
        Function<Object, Object> finisher = t1 -> {
            Iterator t1It = ((Iterable)t1).iterator();
            return collectors.stream().map(c -> c.finisher().apply(t1It.next())).collect(Collectors.toList());
        };
        Collector<Object, Object, Object> col = Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
        return (List)stream.collect(col);
    }

    public static final <T> Stream<T> cycleWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamUtils.limitWhile(StreamUtils.cycle(stream), predicate);
    }

    public static final <T> Stream<T> cycleUntil(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamUtils.limitUntil(StreamUtils.cycle(stream), predicate);
    }

    public static final <T, S, R> Stream<R> zip(Stream<T> stream, SequenceM<? extends S> second, final BiFunction<? super T, ? super S, ? extends R> zipper) {
        final Iterator left = stream.iterator();
        final Iterator right = second.stream().iterator();
        return StreamUtils.stream(new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return left.hasNext() && right.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(left.next(), right.next());
            }
        });
    }

    public static final <T, S, R> Stream<R> zip(Stream<T> stream, AnyM<? extends S> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return StreamUtils.zip(stream, second.toSequence(), zipper);
    }

    public static final <T, S, R> Stream<R> zipStream(Stream<T> stream, BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, final BiFunction<? super T, ? super S, ? extends R> zipper) {
        final Iterator left = stream.iterator();
        final Iterator<? extends S> right = second.iterator();
        return StreamUtils.stream(new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return left.hasNext() && right.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(left.next(), right.next());
            }
        });
    }

    public static final <T> Stream<List<T>> sliding(Stream<T> stream, final int windowSize, final int increment) {
        final Iterator it = stream.iterator();
        final Mutable<ConsPStack> list = Mutable.of(ConsPStack.empty());
        return StreamUtils.stream(new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public List<T> next() {
                int i;
                for (i = 0; i < increment && ((PStack)list.get()).size() > 0; ++i) {
                    list.mutate(var -> var.minus(0));
                }
                i = 0;
                while (((PStack)list.get()).size() < windowSize && it.hasNext()) {
                    if (it.hasNext()) {
                        list.mutate(var -> var.plus(Math.max(0, var.size()), it.next()));
                    }
                    ++i;
                }
                return (List)list.get();
            }
        });
    }

    public static final <T> Stream<List<T>> sliding(Stream<T> stream, int windowSize) {
        return StreamUtils.sliding(stream, windowSize, 1);
    }

    public static final <T> Stream<List<T>> grouped(Stream<T> stream, final int groupSize) {
        final Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public List<T> next() {
                ArrayList list = new ArrayList();
                for (int i = 0; i < groupSize; ++i) {
                    if (!it.hasNext()) continue;
                    list.add(it.next());
                }
                return list;
            }
        });
    }

    public static final <T> Stream<T> scanLeft(Stream<T> stream, final Monoid<T> monoid) {
        final Iterator it = stream.iterator();
        return StreamUtils.stream(new Iterator<T>(){
            boolean init = false;
            T next = monoid.zero();

            @Override
            public boolean hasNext() {
                if (!this.init) {
                    return true;
                }
                return it.hasNext();
            }

            @Override
            public T next() {
                if (!this.init) {
                    this.init = true;
                    return monoid.zero();
                }
                this.next = monoid.combiner().apply(this.next, it.next());
                return this.next;
            }
        });
    }

    public static <T> LazySeq<T> steamToLazySeq(Stream<T> stream) {
        return LazySeq.of(stream.iterator());
    }

    public static <T> boolean xMatch(Stream<T> stream, int num, Predicate<? super T> c) {
        return stream.filter(t -> c.test(t)).collect(Collectors.counting()) == (long)num;
    }

    public static final <T> boolean noneMatch(Stream<T> stream, Predicate<? super T> c) {
        return stream.allMatch(c.negate());
    }

    public static final <T> String join(Stream<T> stream) {
        return stream.map(t -> t.toString()).collect(Collectors.joining());
    }

    public static final <T> String join(Stream<T> stream, String sep) {
        return stream.map(t -> t.toString()).collect(Collectors.joining(sep));
    }

    public static final <T> String join(Stream<T> stream, String sep, String start, String end) {
        return stream.map(t -> t.toString()).collect(Collectors.joining(sep, start, end));
    }

    public static final <T, C extends Comparable<? super C>> Optional<T> minBy(Stream<T> stream, Function<T, C> f) {
        Optional<Pair> o = stream.map(in -> new Pair(f.apply(in), in)).min(Comparator.comparing(n -> (Comparable)n._1(), Comparator.naturalOrder()));
        return o.map(p -> p._2());
    }

    public static final <T> Optional<T> min(Stream<T> stream, Comparator<? super T> comparator) {
        return stream.collect(Collectors.minBy(comparator));
    }

    public static final <T, C extends Comparable<? super C>> Optional<T> maxBy(Stream<T> stream, Function<T, C> f) {
        Optional<Pair> o = stream.map(in -> new Pair(f.apply(in), in)).max(Comparator.comparing(n -> (Comparable)n._1(), Comparator.naturalOrder()));
        return o.map(p -> p._2());
    }

    public static final <T> Optional<T> max(Stream<T> stream, Comparator<? super T> comparator) {
        return stream.collect(Collectors.maxBy(comparator));
    }

    public static final <T, R> R mapReduce(Stream<T> stream, Monoid<R> reducer) {
        return reducer.mapReduce(stream);
    }

    public static final <T, R> R mapReduce(Stream<T> stream, Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return reducer.reduce(stream.map(mapper));
    }

    public static final <T> T foldLeft(Stream<T> stream, Monoid<T> reducer) {
        return reducer.reduce(stream);
    }

    public static final <T> T foldLeftMapToType(Stream<T> stream, Monoid<T> reducer) {
        return reducer.mapReduce(stream);
    }

    public static final <T> T foldRight(Stream<T> stream, Monoid<T> reducer) {
        return reducer.reduce(StreamUtils.reverse(stream));
    }

    public static final <T> T foldRightMapToType(Stream<T> stream, Monoid<T> reducer) {
        return reducer.mapReduce(StreamUtils.reverse(stream));
    }

    public static final <T> Streamable<T> toStreamable(Stream<T> stream) {
        return AsStreamable.asStreamable(stream);
    }

    public static final <T> Set<T> toSet(Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static final <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static final <T> boolean startsWith(Stream<T> stream, Iterable<T> iterable) {
        return StreamUtils.startsWith(stream, iterable.iterator());
    }

    public static final <T> boolean startsWith(Stream<T> stream, Iterator<T> iterator) {
        Iterator it = stream.iterator();
        while (iterator.hasNext()) {
            if (!it.hasNext()) {
                return false;
            }
            if (Objects.equals(it.next(), iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> AnyM<T> anyM(Stream<T> monad) {
        return AsAnyM.anyM(monad);
    }

    public static <T> SequenceM<T> sequenceM(Stream<T> monad) {
        return AsAnyM.anyM(monad).asSequence();
    }

    public static <T> Stream<T> intersperse(Stream<T> stream, T value) {
        return stream.flatMap(t -> Stream.of(value, t)).skip(1L);
    }

    public static <T, U> Stream<U> ofType(Stream<T> stream, Class<U> type) {
        return stream.filter(type::isInstance).map(t -> t);
    }

    public static <T, U> Stream<U> cast(Stream<T> stream, Class<U> type) {
        return stream.map(type::cast);
    }

    public static final <T, R> Stream<R> flatMapSequenceM(Stream<T> stream, Function<? super T, SequenceM<? extends R>> fn) {
        return ((SequenceM)AsAnyM.anyM(stream).asSequence().flatMap(fn)).stream();
    }

    public static final <T, R> Stream<R> flatMapAnyM(Stream<T> stream, Function<? super T, AnyM<? extends R>> fn) {
        return AsAnyM.anyM(stream).asSequence().flatMapAnyM(fn).stream();
    }

    public static final <T, R> Stream<R> flatMapCollection(Stream<T> stream, Function<? super T, Collection<? extends R>> fn) {
        return AsAnyM.anyM(stream).asSequence().flatMapCollection(fn).stream();
    }

    public static final <T, R> Stream<R> flatMapStream(Stream<T> stream, Function<? super T, BaseStream<? extends R, ?>> fn) {
        return AsAnyM.anyM(stream).asSequence().flatMapStream(fn).stream();
    }

    public static final <T, R> Stream<R> flatMapOptional(Stream<T> stream, Function<? super T, Optional<? extends R>> fn) {
        return AsAnyM.anyM(stream).asSequence().flatMapOptional(fn).stream();
    }

    public static final <T, R> Stream<R> flatMapCompletableFuture(Stream<T> stream, Function<? super T, CompletableFuture<? extends R>> fn) {
        return AsAnyM.anyM(stream).asSequence().flatMapCompletableFuture(fn).stream();
    }

    public static final <T, R> Stream<R> flatMapLazySeq(Stream<T> stream, Function<? super T, LazySeq<? extends R>> fn) {
        return AsAnyM.anyM(stream).asSequence().flatMapLazySeq(fn).stream();
    }

    public static final <T> Stream<Character> liftAndBindCharSequence(Stream<T> stream, Function<? super T, CharSequence> fn) {
        return AsAnyM.anyM(stream).asSequence().liftAndBindCharSequence(fn).stream();
    }

    public static final <T> Stream<String> liftAndBindFile(Stream<T> stream, Function<? super T, File> fn) {
        return AsAnyM.anyM(stream).asSequence().liftAndBindFile(fn).stream();
    }

    public static final <T> Stream<String> liftAndBindURL(Stream<T> stream, Function<? super T, URL> fn) {
        return AsAnyM.anyM(stream).asSequence().liftAndBindURL(fn).stream();
    }

    public static final <T> Stream<String> liftAndBindBufferedReader(Stream<T> stream, Function<? super T, BufferedReader> fn) {
        return AsAnyM.anyM(stream).asSequence().liftAndBindBufferedReader(fn).stream();
    }

    public static final <A> Collection<A> toLazyCollection(Stream<A> stream) {
        return StreamUtils.toLazyCollection(stream.iterator());
    }

    public static final <A> Collection<A> toLazyCollection(Iterator<A> iterator) {
        return StreamUtils.toLazyCollection(iterator, false);
    }

    public static final <A> Collection<A> toConcurrentLazyCollection(Stream<A> stream) {
        return StreamUtils.toConcurrentLazyCollection(stream.iterator());
    }

    public static final <A> Collection<A> toConcurrentLazyCollection(Iterator<A> iterator) {
        return StreamUtils.toLazyCollection(iterator, true);
    }

    private static final <A> Collection<A> toLazyCollection(final Iterator<A> iterator, final boolean concurrent) {
        return new AbstractCollection<A>(){
            List<A> data = new ArrayList();
            volatile boolean complete = false;
            Object lock = new Object();
            ReentrantLock rlock = new ReentrantLock();

            @Override
            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof Collection)) {
                    return false;
                }
                Collection c = (Collection)o;
                Iterator it1 = this.iterator();
                Iterator it2 = c.iterator();
                while (it1.hasNext()) {
                    if (!it2.hasNext()) {
                        return false;
                    }
                    if (Objects.equals(it1.next(), it2.next())) continue;
                    return false;
                }
                return !it2.hasNext();
            }

            @Override
            public int hashCode() {
                Iterator it1 = this.iterator();
                ArrayList arrayList = new ArrayList();
                while (it1.hasNext()) {
                    arrayList.add(it1.next());
                }
                return Objects.hashCode(arrayList.toArray());
            }

            @Override
            public Iterator<A> iterator() {
                if (this.complete) {
                    return this.data.iterator();
                }
                return new Iterator<A>(){
                    int current = -1;

                    @Override
                    public boolean hasNext() {
                        if (concurrent) {
                            rlock.lock();
                        }
                        try {
                            if (this.current == data.size() - 1 && !complete) {
                                boolean result = iterator.hasNext();
                                complete = !result;
                                boolean bl = result;
                                return bl;
                            }
                            if (this.current + 1 < data.size()) {
                                boolean bl = true;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            if (concurrent) {
                                rlock.unlock();
                            }
                        }
                    }

                    @Override
                    public A next() {
                        if (concurrent) {
                            rlock.lock();
                        }
                        try {
                            if (this.current < data.size() && !complete) {
                                if (iterator.hasNext()) {
                                    data.add(iterator.next());
                                }
                                Object a = data.get(++this.current);
                                return a;
                            }
                            ++this.current;
                            Object a = data.get(this.current);
                            return a;
                        }
                        finally {
                            if (concurrent) {
                                rlock.unlock();
                            }
                        }
                    }
                };
            }

            @Override
            public int size() {
                if (this.complete) {
                    return this.data.size();
                }
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    it.next();
                }
                return this.data.size();
            }
        };
    }

    public static final <A> Pair<Iterator<A>, Iterator<A>> toBufferingDuplicator(Iterator<A> iterator) {
        return StreamUtils.toBufferingDuplicator(iterator, Long.MAX_VALUE);
    }

    public static final <A> Pair<Iterator<A>, Iterator<A>> toBufferingDuplicator(Iterator<A> iterator, long pos) {
        LinkedList bufferTo = new LinkedList();
        LinkedList bufferFrom = new LinkedList();
        return new Pair<Iterator<A>, Iterator<A>>(new DuplicatingIterator(bufferTo, bufferFrom, iterator, Long.MAX_VALUE, 0L), new DuplicatingIterator(bufferFrom, bufferTo, iterator, pos, 0L));
    }

    public static final <A> List<Iterator<A>> toBufferingCopier(Iterator<A> iterator, int copies) {
        ArrayList<Iterator<A>> result = new ArrayList<Iterator<A>>();
        LinkedList leaderboard = new LinkedList();
        LinkedList buffer = new LinkedList();
        for (int i = 0; i < copies; ++i) {
            result.add(new CopyingIterator<A>(iterator, leaderboard, buffer, copies));
        }
        return result;
    }

    static class CopyingIterator<T>
    implements Iterator<T> {
        LinkedList<T> buffer;
        Iterator<T> it;
        List<CopyingIterator<T>> leaderboard = new LinkedList<CopyingIterator<T>>();
        boolean added = false;
        int total = 0;
        int counter = 0;

        @Override
        public boolean hasNext() {
            if (this.isLeader()) {
                return this.it.hasNext();
            }
            if (this.isLast()) {
                return this.buffer.size() > 0 || this.it.hasNext();
            }
            if (this.it.hasNext()) {
                return true;
            }
            return this.counter < this.buffer.size();
        }

        private boolean isLeader() {
            return this.leaderboard.size() == 0 || this == this.leaderboard.get(0);
        }

        private boolean isLast() {
            return this.leaderboard.size() == this.total && this == this.leaderboard.get(this.leaderboard.size() - 1);
        }

        @Override
        public T next() {
            if (!this.added) {
                this.leaderboard.add(this);
                this.added = true;
            }
            if (this.isLeader()) {
                return this.handleLeader();
            }
            if (this.isLast()) {
                if (this.buffer.size() > 0) {
                    return this.buffer.poll();
                }
                return this.it.next();
            }
            if (this.counter < this.buffer.size()) {
                return this.buffer.get(this.counter++);
            }
            return this.handleLeader();
        }

        private T handleLeader() {
            T next = this.it.next();
            this.buffer.offer(next);
            return next;
        }

        public CopyingIterator(Iterator<T> it, List<CopyingIterator<T>> leaderboard, LinkedList<T> buffer, int total) {
            this.it = it;
            this.leaderboard = leaderboard;
            this.buffer = buffer;
            this.total = total;
        }
    }

    static class DuplicatingIterator<T>
    implements Iterator<T> {
        LinkedList<T> bufferTo;
        LinkedList<T> bufferFrom;
        Iterator<T> it;
        long otherLimit = Long.MAX_VALUE;
        long counter = 0L;

        @Override
        public boolean hasNext() {
            return this.bufferFrom.size() > 0 || this.it.hasNext();
        }

        @Override
        public T next() {
            try {
                if (this.bufferFrom.size() > 0) {
                    T t = this.bufferFrom.remove(0);
                    return t;
                }
                T next = this.it.next();
                if (this.counter < this.otherLimit) {
                    this.bufferTo.add(next);
                }
                T t = next;
                return t;
            }
            finally {
                ++this.counter;
            }
        }

        @ConstructorProperties(value={"bufferTo", "bufferFrom", "it", "otherLimit", "counter"})
        public DuplicatingIterator(LinkedList<T> bufferTo, LinkedList<T> bufferFrom, Iterator<T> it, long otherLimit, long counter) {
            this.bufferTo = bufferTo;
            this.bufferFrom = bufferFrom;
            this.it = it;
            this.otherLimit = otherLimit;
            this.counter = counter;
        }
    }
}

