/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.lambda.monads.SequenceM;
import com.aol.cyclops.streams.Pair;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BaseSequentialTest {
    SequenceM<Integer> empty;
    SequenceM<Integer> nonEmpty;

    <U> SequenceM<U> of(U ... array) {
        return SequenceM.of((Object[])array);
    }

    @Before
    public void setup() {
        this.empty = this.of(new Integer[0]);
        this.nonEmpty = this.of(1);
    }

    Integer value2() {
        return 5;
    }

    @Test
    public void batchBySize() {
        System.out.println(this.of(1, 2, 3, 4, 5, 6).grouped(3).collect(Collectors.toList()));
        Assert.assertThat((Object)((List)this.of(1, 2, 3, 4, 5, 6).grouped(3).collect(Collectors.toList())).size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void prepend() {
        List result = (List)this.of(1, 2, 3).prepend((Object[])new Integer[]{100, 200, 300}).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("100!!", "200!!", "300!!", "1!!", "2!!", "3!!")));
    }

    @Test
    public void append() {
        List result = (List)this.of(1, 2, 3).append((Object[])new Integer[]{100, 200, 300}).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "2!!", "3!!", "100!!", "200!!", "300!!")));
    }

    @Test
    public void concatStreams() {
        List result = (List)this.of(1, 2, 3).appendStream(this.of(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "2!!", "3!!", "100!!", "200!!", "300!!")));
    }

    @Test
    public void prependStreams() {
        List result = (List)this.of(1, 2, 3).prependStream(this.of(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("100!!", "200!!", "300!!", "1!!", "2!!", "3!!")));
    }

    @Test
    public void insertAt() {
        List result = (List)this.of(1, 2, 3).insertAt(1, (Object[])new Integer[]{100, 200, 300}).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "100!!", "200!!", "300!!", "2!!", "3!!")));
    }

    @Test
    public void insertAtStream() {
        List result = (List)this.of(1, 2, 3).insertStreamAt(1, this.of(100, 200, 300)).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "100!!", "200!!", "300!!", "2!!", "3!!")));
    }

    @Test
    public void deleteBetween() {
        List result = (List)this.of(1, 2, 3, 4, 5, 6).deleteBetween(2, 4).map(it -> it + "!!").collect(Collectors.toList());
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("1!!", "2!!", "5!!", "6!!")));
    }

    @Test
    public void zip() {
        List list = (List)this.of(1, 2, 3, 4, 5, 6).zip(this.of(100, 200, 300, 400)).peek(it -> System.out.println(it)).collect(Collectors.toList());
        List right = list.stream().map(t -> (Integer)t.v2).collect(Collectors.toList());
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)100));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)300));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)400));
        List left = list.stream().map(t -> (Integer)t.v1).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4), (Matcher)Matchers.equalTo(left));
    }

    @Test
    public void zip2of() {
        List list = (List)this.of(1, 2, 3, 4, 5, 6).zip(this.of(100, 200, 300, 400)).peek(it -> System.out.println(it)).collect(Collectors.toList());
        List right = list.stream().map(t -> (Integer)t.v2).collect(Collectors.toList());
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)100));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)200));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)300));
        Assert.assertThat(right, (Matcher)Matchers.hasItem((Object)400));
        List left = list.stream().map(t -> (Integer)t.v1).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(1, 2, 3, 4, 5, 6), (Matcher)Matchers.hasItem(left.get(0)));
    }

    @Test
    public void zipInOrder() {
        List list = (List)this.of(1, 2, 3, 4, 5, 6).limit(6L).zip((Stream)this.of(100, 200, 300, 400).limit(4L)).collect(Collectors.toList());
        Assert.assertThat((Object)((Pair)list.get((int)0)).v1, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Pair)list.get((int)0)).v2, (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)((Pair)list.get((int)1)).v1, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Pair)list.get((int)1)).v2, (Matcher)Matchers.is((Object)200));
        Assert.assertThat((Object)((Pair)list.get((int)2)).v1, (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)((Pair)list.get((int)2)).v2, (Matcher)Matchers.is((Object)300));
        Assert.assertThat((Object)((Pair)list.get((int)3)).v1, (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)((Pair)list.get((int)3)).v2, (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void zipEmpty() throws Exception {
        SequenceM zipped = this.empty.zip(this.of(new Integer[0]), (a, b) -> a + b);
        Assert.assertTrue((boolean)((List)zipped.collect(Collectors.toList())).isEmpty());
    }

    @Test
    public void shouldReturnEmptySeqWhenZipEmptyWithNonEmpty() throws Exception {
        SequenceM zipped = this.empty.zip(this.nonEmpty, (a, b) -> a + b);
        Assert.assertTrue((boolean)((List)zipped.collect(Collectors.toList())).isEmpty());
    }

    @Test
    public void shouldReturnEmptySeqWhenZipNonEmptyWithEmpty() throws Exception {
        SequenceM zipped = this.nonEmpty.zip(this.empty, (a, b) -> a + b);
        Assert.assertTrue((boolean)((List)zipped.collect(Collectors.toList())).isEmpty());
    }

    @Test
    public void shouldZipTwoFiniteSequencesOfSameSize() throws Exception {
        SequenceM<String> first = this.of("A", "B", "C");
        SequenceM<Integer> second = this.of(1, 2, 3);
        SequenceM zipped = first.zip(second, (a, b) -> a + b);
        Assert.assertThat((Object)zipped.collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList("A1", "B2", "C3")));
    }

    @Test
    public void shouldTrimSecondFixedSeqIfLonger() throws Exception {
        SequenceM<String> first = this.of("A", "B", "C");
        SequenceM<Integer> second = this.of(1, 2, 3, 4);
        SequenceM zipped = first.zip(second, (a, b) -> a + b);
        Assert.assertThat((Object)zipped.collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList("A1", "B2", "C3")));
    }

    @Test
    public void shouldTrimFirstFixedSeqIfLonger() throws Exception {
        SequenceM<String> first = this.of("A", "B", "C", "D");
        SequenceM<Integer> second = this.of(1, 2, 3);
        SequenceM zipped = first.zip(second, (a, b) -> a + b);
        Assert.assertThat((Object)zipped.collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList("A1", "B2", "C3")));
    }

    @Test
    public void limitWhileTest() {
        List list = (List)this.of(1, 2, 3, 4, 5, 6).limitWhile(it -> it < 4).peek(it -> System.out.println(it)).collect(Collectors.toList());
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)1));
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)2));
        Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)3));
    }

    @Test
    public void testScanLeftStringConcat() {
        Assert.assertThat((Object)this.of("a", "b", "c").scanLeft((Object)"", String::concat).toList(), (Matcher)Matchers.is(Arrays.asList("", "a", "ab", "abc")));
    }

    @Test
    public void testScanLeftSum() {
        Assert.assertThat((Object)this.of("a", "ab", "abc").map(str -> str.length()).scanLeft((Object)0, (u, t) -> u + t).toList(), (Matcher)Matchers.is(Arrays.asList(0, 1, 3, 6)));
    }

    @Test
    public void testScanRightStringConcat() {
        Assert.assertThat((Object)this.of("a", "b", "c").scanRight((Object)"", String::concat).toList(), (Matcher)Matchers.is(Arrays.asList("", "c", "bc", "abc")));
    }

    @Test
    public void testScanRightSum() {
        Assert.assertThat((Object)this.of("a", "ab", "abc").map(str -> str.length()).scanRight((Object)0, (t, u) -> u + t).toList(), (Matcher)Matchers.is(Arrays.asList(0, 3, 5, 6)));
    }

    @Test
    public void testReverse() {
        Assert.assertThat((Object)this.of(1, 2, 3).reverse().toList(), (Matcher)Matchers.is(Arrays.asList(3, 2, 1)));
    }

    @Test
    public void testShuffle() {
        Supplier<SequenceM> s = () -> this.of(1, 2, 3);
        Assert.assertEquals((long)3L, (long)s.get().shuffle().toList().size());
        Assert.assertThat((Object)s.get().shuffle().toList(), (Matcher)Matchers.hasItems((Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void testCycle() {
        Assert.assertEquals(Arrays.asList(1, 2, 1, 2, 1, 2), (Object)this.of(1, 2).cycle().limit(6L).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 1, 2, 3), (Object)this.of(1, 2, 3).cycle().limit(6L).toList());
    }

    @Test
    public void testIterable() {
        List list = (List)this.of(1, 2, 3).toCollection(LinkedList::new);
        for (Integer i : this.of(1, 2, 3)) {
            Assert.assertThat((Object)list, (Matcher)Matchers.hasItem((Object)i));
        }
    }

    @Test
    public void testDuplicate() {
        Pair copies = this.of(1, 2, 3, 4, 5, 6).duplicate();
        Assert.assertTrue((boolean)((SequenceM)copies.v1).anyMatch(i -> i == 2));
        Assert.assertTrue((boolean)((SequenceM)copies.v2).anyMatch(i -> i == 2));
    }

    @Test
    public void testGroupByEager() {
        Map map1 = this.of(1, 2, 3, 4).groupBy(i -> i % 2);
        Assert.assertEquals(Arrays.asList(2, 4), map1.get(0));
        Assert.assertEquals(Arrays.asList(1, 3), map1.get(1));
        Assert.assertEquals((long)2L, (long)map1.size());
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"123", (Object)this.of(1, 2, 3).join());
        Assert.assertEquals((Object)"1, 2, 3", (Object)this.of(1, 2, 3).join(", "));
        Assert.assertEquals((Object)"^1|2|3$", (Object)this.of(1, 2, 3).join("|", "^", "$"));
    }

    @Test
    @Ignore
    public void testOptional() {
        Assert.assertEquals(Arrays.asList(1), (Object)this.of(Optional.of(1)).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.of(Optional.empty()).toList());
    }

    @Test
    public void testZipDifferingLength() {
        List list = this.of(1, 2).zip(this.of("a", "b", "c", "d")).toList();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((Pair)list.get((int)0)).v1));
        Assert.assertTrue((String)("" + (String)((Pair)list.get((int)1)).v2), (boolean)Arrays.asList(1, 2).contains(((Pair)list.get((int)1)).v1));
        Assert.assertTrue((boolean)Arrays.asList("a", "b", "c", "d").contains(((Pair)list.get((int)0)).v2));
        Assert.assertTrue((boolean)Arrays.asList("a", "b", "c", "d").contains(((Pair)list.get((int)1)).v2));
    }

    @Test
    public void testZipWithIndex() {
        Assert.assertEquals(Arrays.asList(new Pair((Object)"a", (Object)0L), new Pair((Object)"b", (Object)1L)), (Object)this.of("a", "b").zipWithIndex().toList());
        Assert.assertEquals(Arrays.asList(new Pair((Object)"a", (Object)0L), new Pair((Object)"b", (Object)1L), new Pair((Object)"c", (Object)2L)), (Object)this.of("a", "b", "c").zipWithIndex().toList());
    }

    @Test
    public void testSkipWhile() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)s.get().skipWhile(i -> false).toList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().skipWhile(i -> i % 3 != 0).toList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().skipWhile(i -> i < 3).toList());
        Assert.assertEquals(Arrays.asList(4, 5), (Object)s.get().skipWhile(i -> i < 4).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().skipWhile(i -> true).toList());
    }

    @Test
    public void testSkipUntil() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().skipUntil(i -> false).toList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().skipUntil(i -> i % 3 == 0).toList());
        Assert.assertEquals(Arrays.asList(3, 4, 5), (Object)s.get().skipUntil(i -> i == 3).toList());
        Assert.assertEquals(Arrays.asList(4, 5), (Object)s.get().skipUntil(i -> i == 4).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)s.get().skipUntil(i -> true).toList());
    }

    @Test
    public void testSkipUntilWithNulls() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, null, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(1, 2, null, 3, 4, 5), (Object)s.get().skipUntil(i -> true).toList());
    }

    @Test
    public void testLimitWhile() {
        Supplier<SequenceM> s = () -> SequenceM.of((Object[])new Integer[]{1, 2, 3, 4, 5});
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)s.get().limitWhile(i -> false).toList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)s.get().limitWhile(i -> i % 3 != 0).toList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)s.get().limitWhile(i -> i < 3).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)s.get().limitWhile(i -> i < 4).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)s.get().limitWhile(i -> true).toList());
    }

    @Test
    public void testLimitUntil() {
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)this.of(1, 2, 3, 4, 5).limitUntil(i -> false).toList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)this.of(1, 2, 3, 4, 5).limitUntil(i -> i % 3 == 0).toList());
        Assert.assertEquals(Arrays.asList(1, 2), (Object)this.of(1, 2, 3, 4, 5).limitUntil(i -> i == 3).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)this.of(1, 2, 3, 4, 5).limitUntil(i -> i == 4).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.of(1, 2, 3, 4, 5).limitUntil(i -> true).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)this.of(1, 2, 3, 4, 5).limitUntil(i -> true).toList());
    }

    @Test
    public void testLimitUntilWithNulls() {
        Assert.assertThat((Object)this.of(1, 2, null, 3, 4, 5).limitUntil(i -> false).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, null, 3, 4, 5)));
    }

    @Test
    public void testPartition() {
        Supplier<SequenceM> s = () -> this.of(1, 2, 3, 4, 5, 6);
        Assert.assertEquals(Arrays.asList(1, 3, 5), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$197(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList());
        Assert.assertEquals(Arrays.asList(2, 4, 6), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$198(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList());
        Assert.assertEquals(Arrays.asList(2, 4, 6), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$199(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList());
        Assert.assertEquals(Arrays.asList(1, 3, 5), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$200(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$201(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList());
        Assert.assertEquals(Arrays.asList(4, 5, 6), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$202(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$203(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$204(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)s.get().partition((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$205(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v1).toList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)((SequenceM)s.get().splitBy((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$testPartition$206(java.lang.Integer ), (Ljava/lang/Integer;)Z)()).v2).toList());
    }

    @Test
    public void testSplitAt() {
        Supplier<SequenceM> s;
        int i;
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(4, 5, 6), (Object)((SequenceM)s.get().splitAt((int)3).v2).toList());
        }
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)((SequenceM)s.get().splitAt((int)3).v1).toList());
        }
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)((SequenceM)s.get().splitAt((int)6).v1).toList());
        }
        for (i = 0; i < 20; ++i) {
            s = () -> this.of(1, 2, 3, 4, 5, 6);
            Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)((SequenceM)s.get().splitAt((int)7).v1).toList());
        }
    }

    @Test
    public void testSplitAtHead() {
        Assert.assertEquals(Optional.empty(), (Object)this.of(new Object[0]).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)this.of(new Object[0]).splitAtHead().v2).toList());
        Assert.assertEquals(Optional.of(1), (Object)this.of(new Integer[]{Integer.valueOf((int)1)}).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1)}).splitAtHead().v2).toList());
        Assert.assertEquals(Optional.of(1), (Object)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2)}).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(2), (Object)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2)}).splitAtHead().v2).toList());
        Assert.assertEquals(Optional.of(1), (Object)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v1);
        Assert.assertEquals(Optional.of(2), (Object)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v1);
        Assert.assertEquals(Optional.of(3), (Object)((SequenceM)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v2).splitAtHead().v1);
        Assert.assertEquals(Arrays.asList(2, 3), (Object)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).toList());
        Assert.assertEquals(Arrays.asList(3), (Object)((SequenceM)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v2).toList());
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)((SequenceM)((SequenceM)((SequenceM)this.of(new Integer[]{Integer.valueOf((int)1), Integer.valueOf((int)2), Integer.valueOf((int)3)}).splitAtHead().v2).splitAtHead().v2).splitAtHead().v2).toList());
    }

    @Test
    public void testMinByMaxBy() {
        Supplier<SequenceM> s = () -> this.of(1, 2, 3, 4, 5, 6);
        Assert.assertEquals((long)1L, (long)((Integer)s.get().maxBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)s.get().minBy(t -> Math.abs(t - 5)).get()).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)s.get().maxBy(t -> "" + t).get()).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)s.get().minBy(t -> "" + t).get()).intValue());
    }

    @Test
    public void testUnzip() {
        Supplier<SequenceM> s = () -> this.of(new Pair((Object)1, (Object)"a"), new Pair((Object)2, (Object)"b"), new Pair((Object)3, (Object)"c"));
        Pair u1 = SequenceM.unzip((SequenceM)s.get());
        Assert.assertThat((Object)((SequenceM)u1.v1).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
        Assert.assertThat((Object)((SequenceM)u1.v2).toList(), (Matcher)Matchers.equalTo(Arrays.asList("a", "b", "c")));
    }

    @Test
    public void testFoldLeft() {
        Supplier<SequenceM> s = () -> this.of("a", "b", "c");
        Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("a"));
        Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("b"));
        Assert.assertTrue((boolean)((String)s.get().foldLeft((Object)"", String::concat)).contains("c"));
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldLeft((Object)0, (u, t) -> u + t)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
        Assert.assertEquals((Object)"-a-b-c", (Object)((StringBuilder)s.get().map(str -> new StringBuilder((String)str)).foldLeft((Object)new StringBuilder(), (u, t) -> u.append("-").append((CharSequence)t))).toString());
    }

    @Test
    public void testFoldRight() {
        Supplier<SequenceM> s = () -> this.of("a", "b", "c");
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).equals("cba"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("b"));
        Assert.assertTrue((boolean)((String)s.get().foldRight((Object)"", String::concat)).contains("c"));
        Assert.assertEquals((long)3L, (long)((Integer)s.get().map(str -> str.length()).foldRight((Object)0, (t, u) -> u + t)).intValue());
    }

    @Test
    public void flattenEmpty() throws Exception {
        Assert.assertTrue((boolean)this.of(new Integer[0]).flatMap(i -> Arrays.asList(i, -i.intValue()).stream()).toList().isEmpty());
    }

    @Test
    public void flatten() throws Exception {
        Assert.assertThat((Object)this.of(1, 2).flatMap(i -> Arrays.asList(i, -i.intValue()).stream()).toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, -1, 2, -2)));
    }

    @Test
    public void flattenEmptyStream() throws Exception {
        Assert.assertThat((Object)this.of(1, 2, 3, 4, 5, 5, 6, 8, 9, 10).flatMap(this::flatMapFun).limit(10L).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(2, 3, 4, 5, 6, 7, 0, 0, 0, 0)));
    }

    private Stream<Integer> flatMapFun(int i) {
        if (i <= 0) {
            return Arrays.asList(new Integer[0]).stream();
        }
        switch (i) {
            case 1: {
                return Arrays.asList(2).stream();
            }
            case 2: {
                return Arrays.asList(3, 4).stream();
            }
            case 3: {
                return Arrays.asList(5, 6, 7).stream();
            }
        }
        return Arrays.asList(0, 0).stream();
    }

    private static /* synthetic */ boolean lambda$testPartition$206(Integer i) {
        return false;
    }

    private static /* synthetic */ boolean lambda$testPartition$205(Integer i) {
        return false;
    }

    private static /* synthetic */ boolean lambda$testPartition$204(Integer i) {
        return true;
    }

    private static /* synthetic */ boolean lambda$testPartition$203(Integer i) {
        return true;
    }

    private static /* synthetic */ boolean lambda$testPartition$202(Integer i) {
        return i <= 3;
    }

    private static /* synthetic */ boolean lambda$testPartition$201(Integer i) {
        return i <= 3;
    }

    private static /* synthetic */ boolean lambda$testPartition$200(Integer i) {
        return i % 2 == 0;
    }

    private static /* synthetic */ boolean lambda$testPartition$199(Integer i) {
        return i % 2 == 0;
    }

    private static /* synthetic */ boolean lambda$testPartition$198(Integer i) {
        return i % 2 != 0;
    }

    private static /* synthetic */ boolean lambda$testPartition$197(Integer i) {
        return i % 2 != 0;
    }
}

