/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.lambda.monads;

import com.aol.cyclops.internal.AsGenericMonad;
import com.aol.cyclops.internal.Monad;
import com.aol.cyclops.lambda.api.AsAnyM;
import com.aol.cyclops.lambda.api.AsAnyMList;
import com.aol.cyclops.lambda.api.Monoid;
import com.aol.cyclops.lambda.api.Reducers;
import com.aol.cyclops.lambda.api.Streamable;
import com.aol.cyclops.lambda.monads.AnyM;
import com.aol.cyclops.lambda.monads.AnyMonads;
import com.aol.cyclops.lambda.monads.MonadWrapper;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class MonadTest {
    Optional<Integer> value = Optional.of(42);
    Monad<Optional<Integer>, Integer> monadicValue = AsGenericMonad.monad(this.value);
    Function<Optional<Integer>, Monad<Optional<Integer>, Integer>> monadOf = input -> AsGenericMonad.monad((Optional)input);
    Function<Optional<Integer>, Monad<Optional<Integer>, Integer>> f = input -> AsGenericMonad.monad(Optional.of((Integer)input.get() * 5));
    Function<Optional<Integer>, Monad<Optional<Integer>, Integer>> g = input -> AsGenericMonad.monad(Optional.of((Integer)input.get() * 50));
    int count;

    @Test
    public void satisfiesLaw1LeftIdentity() {
        Assert.assertThat((Object)AsGenericMonad.monad(this.value).monadFlatMap(this.f), (Matcher)Matchers.equalTo(this.f.apply(this.value)));
    }

    @Test
    public void satisfiesLaw2RightIdentity() {
        Assert.assertThat((Object)this.monadicValue.monadFlatMap(this.monadOf), (Matcher)Matchers.equalTo(this.monadicValue));
    }

    @Test
    public void satisfiesLaw3Associativity() {
        Assert.assertThat((Object)this.monadicValue.monadFlatMap(this.f).monadFlatMap(this.g), (Matcher)Matchers.equalTo((Object)this.monadicValue.monadFlatMap(input -> this.f.apply((Optional<Integer>)input).monadFlatMap(this.g))));
    }

    @Test
    public void test() {
        List list = ((Stream)MonadWrapper.of(Stream.of(Arrays.asList(1, 3))).flatMap(Collection::stream).unwrap()).map(i -> i * 2).peek(System.out::println).collect(Collectors.toList());
        Assert.assertThat(Arrays.asList(2, 6), (Matcher)Matchers.equalTo(list));
    }

    @Test
    public void testMixed() {
        List list = MonadWrapper.of(Stream.of(Arrays.asList(1, 3), null)).bind(Optional::ofNullable).map(i -> i.size()).peek(System.out::println).sequence().toList();
        Assert.assertThat(Arrays.asList(2), (Matcher)Matchers.equalTo((Object)list));
    }

    @Test
    public void testCycleWhile() {
        this.count = 0;
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).sequence().cycleWhile(next -> this.count++ < 6).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycle() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).sequence().cycle(3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2, 1, 2, 2, 1, 2, 2)));
    }

    @Test
    public void testCycleReduce() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).sequence().cycle(Reducers.toCountInt(), 3).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(3, 3, 3)));
    }

    @Test
    public void testCycleMonad() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2)).sequence().cycle(Optional.class, 2).collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(Optional.of(1), Optional.of(2), Optional.of(1), Optional.of(2))));
    }

    @Test
    public void testJoin() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).map(b -> Stream.of(b)).flatten().sequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2)));
    }

    @Test
    public void testJoin2() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(Arrays.asList(1, 2), Arrays.asList(2))).flatten().sequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 2)));
    }

    @Test
    public void testToSet() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 2)).sequence().toSet().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testToList() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 3)).sequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testCollect() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 3)).sequence().collect(Collectors.toList()), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testToListFlatten() {
        Assert.assertThat((Object)MonadWrapper.of(Stream.of(1, 2, 3, null)).bind(Optional::ofNullable).sequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void testToListOptional() {
        Assert.assertThat((Object)MonadWrapper.of(Optional.of(1)).sequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1)));
    }

    @Test
    public void testFold() {
        Supplier<Monad> s = () -> AsGenericMonad.asMonad(Stream.of("a", "b", "c"));
        Assert.assertThat((Object)"cba", (Matcher)Matchers.equalTo((Object)s.get().sequence().foldRight(Reducers.toString((String)""))));
        Assert.assertThat((Object)"abc", (Matcher)Matchers.equalTo((Object)s.get().sequence().foldLeft(Reducers.toString((String)""))));
        Assert.assertThat((Object)3, (Matcher)Matchers.equalTo((Object)s.get().map(i -> "" + i.length()).sequence().foldRightMapToType(Reducers.toCountInt())));
        Assert.assertThat((Object)3, (Matcher)Matchers.equalTo((Object)s.get().map(i -> "" + i.length()).sequence().foldLeftMapToType(Reducers.toCountInt())));
    }

    @Test
    public void testLift() {
        List result = AsGenericMonad.asMonad(Stream.of("input.file")).map(this.getClass().getClassLoader()::getResource).peek(System.out::println).map(URL::getFile).liftAndBind(File::new).sequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList("hello", "world")));
    }

    @Test
    public void testSequence() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        AnyM futureList = AnyMonads.sequence((Collection)AsAnyMList.completableFutureToAnyMList(futures));
        List collected = (List)((CompletableFuture)futureList.unwrap()).join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat(list.get(next), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void testSequenceList() {
        AnyM futureList = AnyMonads.sequence((Collection)AsAnyMList.collectionToAnyMList(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4))));
        Assert.assertThat((Object)futureList.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    public void testSequenceStream() {
        AnyM result = AnyMonads.sequence((Collection)AsAnyMList.streamToAnyMList(Arrays.asList(Stream.of(1, 2), Stream.of(3, 4))));
        Assert.assertThat((Object)result.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4)));
    }

    @Test
    public void testSequenceOptional() {
        AnyM futureList = AnyMonads.sequence((Collection)AsAnyMList.optionalToAnyMList(Arrays.asList(Optional.of(7), Optional.of(8), Optional.of(9))));
        Assert.assertThat((Object)futureList.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(7, 8, 9)));
    }

    @Test
    public void testTraverse() {
        List list = IntStream.range(0, 100).boxed().collect(Collectors.toList());
        List futures = list.stream().map(x -> CompletableFuture.supplyAsync(() -> x)).collect(Collectors.toList());
        AnyM futureList = AnyMonads.traverse((Collection)AsAnyMList.completableFutureToAnyMList(futures), i -> "hello" + i);
        List collected = (List)((CompletableFuture)futureList.unwrap()).join();
        Assert.assertThat((Object)collected.size(), (Matcher)Matchers.equalTo((Object)list.size()));
        for (Integer next : list) {
            Assert.assertThat((Object)("hello" + list.get(next)), (Matcher)Matchers.equalTo(collected.get(next)));
        }
    }

    @Test
    public void zipStream() {
        Stream zipped = AsGenericMonad.monad(Stream.of(1, 2, 3)).sequence().zip(Stream.of(2, 3, 4), (a, b) -> Arrays.asList(a, b)).stream();
        List zip = (List)zipped.collect(Collectors.toList()).get(1);
        Assert.assertThat(zip.get(0), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat(zip.get(1), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void distinctOptional() {
        List list = (List)AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 2, 2, 5, 6))).streamedMonad().sequence().distinct().collect(Collectors.toList());
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void aggregate() {
        List result = AsGenericMonad.monad(Stream.of(1, 2, 3, 4)).aggregate(AsGenericMonad.monad(Optional.of(5))).sequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void aggregate2() {
        List result = AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 3, 4))).aggregate(AsGenericMonad.monad(CompletableFuture.completedFuture(5))).anyM().toSequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void aggregate3() {
        List result = AsGenericMonad.monad(Optional.of(Arrays.asList(1, 2, 3, 4))).aggregate(AsGenericMonad.monad(CompletableFuture.supplyAsync(() -> Arrays.asList(5, 6)))).anyM().toSequence().toList();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo(Arrays.asList(1, 2, 3, 4, 5, 6)));
    }

    @Test
    public void testApplyM() {
        AnyM applied = AsGenericMonad.monad(Stream.of(1, 2, 3)).applyM(AsGenericMonad.monad((Streamable)Streamable.of((Object[])new Function[]{a -> a + 1, a -> a * 2}))).anyM();
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 2, 3, 4, 4, 6)));
    }

    @Test
    public void testApplyMOptional() {
        AnyM applied = AsGenericMonad.monad(Optional.of(2)).applyM(AsGenericMonad.monad(Optional.of(a -> a + 1))).anyM();
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3)));
    }

    @Test
    public void testApplyMOptionalEmpty() {
        AnyM applied = AsGenericMonad.monad(Optional.of(2)).applyM(AsGenericMonad.monad(Optional.empty())).anyM();
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testApplyMEmptyOptional() {
        AnyM empty = AsGenericMonad.monad(Optional.empty()).anyM();
        AnyM applied = empty.applyM(AsAnyM.anyM(Optional.of(a -> a + 1)));
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void testSimpleFilter() {
        AnyM applied = AsGenericMonad.monad(Stream.of(1, 2, 3)).simpleFilter(AsGenericMonad.monad((Streamable)Streamable.of((Object[])new Predicate[]{a -> a > 5, a -> a < 3}))).anyM();
        Assert.assertThat((Object)applied.map(s -> s.collect(Collectors.toList())).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(new Object[0]))));
    }

    @Test
    public void testSimpleFilterOptional() {
        AnyM applied = AsGenericMonad.monad(Optional.of(2)).simpleFilter(AsGenericMonad.monad((Streamable)Streamable.of((Object[])new Predicate[]{a -> a > 5, a -> a < 3}))).anyM();
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2)));
    }

    @Test
    public void testReplicateM() {
        AnyM applied = AsGenericMonad.monad(Optional.of(2)).replicateM(5).anyM();
        Assert.assertThat((Object)applied.unwrap(), (Matcher)Matchers.equalTo(Optional.of(Arrays.asList(2, 2, 2, 2, 2))));
    }

    @Test
    public void testReplicateMStream() {
        AnyM applied = AsGenericMonad.monad(Stream.of(2, 3, 4)).replicateM(5).anyM();
        Assert.assertThat((Object)applied.toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4, 2, 3, 4)));
    }

    @Test
    public void testSorted() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).anyM().asSequence().sorted().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4, 6, 7)));
    }

    @Test
    public void testSortedCompartor() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().sorted((a, b) -> b - a).toList(), (Matcher)Matchers.equalTo(Arrays.asList(7, 6, 4, 3)));
    }

    @Test
    public void testSkip() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().skip(2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipUntil() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().skipUntil(i -> i == 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testSkipWhile() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().sorted().skipWhile(i -> i < 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(6, 7)));
    }

    @Test
    public void testLimit() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().limit(2).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void testLimitUntil() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().limitUntil(i -> i == 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(4, 3)));
    }

    @Test
    public void testLimitWhile() {
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(4, 3, 6, 7)).sequence().sorted().limitWhile(i -> i < 6).toList(), (Matcher)Matchers.equalTo(Arrays.asList(3, 4)));
    }

    @Test
    public void testLiftMSimplex() {
        Function lifted = AnyMonads.liftM(a -> a + 3);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo((Object)6));
    }

    @Test
    public void testReduceM() {
        Monoid optionalAdd = Monoid.of(Optional.of(0), (a, b) -> Optional.of((Integer)a.get() + (Integer)b.get()));
        Assert.assertThat((Object)AsGenericMonad.monad(Stream.of(2, 8, 3, 1)).reduceM(optionalAdd).unwrap(), (Matcher)Matchers.equalTo(Optional.of(14)));
    }

    @Test
    public void testLiftM2Simplex() {
        BiFunction lifted = AnyMonads.liftM2((a, b) -> a + b);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)), AsAnyM.anyM(Optional.of(4)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo((Object)7));
    }

    @Test
    public void testLiftM2SimplexNull() {
        BiFunction lifted = AnyMonads.liftM2((a, b) -> a + b);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)), AsAnyM.anyM(Optional.ofNullable(null)));
        Assert.assertThat((Object)((Optional)result.unwrap()).isPresent(), (Matcher)Matchers.equalTo((Object)false));
    }

    private Integer add(Integer a, Integer b) {
        return a + b;
    }

    @Test
    public void testLiftM2Mixed() {
        BiFunction lifted = AnyMonads.liftM2(this::add);
        AnyM result = (AnyM)lifted.apply(AsAnyM.anyM(Optional.of(3)), AsAnyM.anyM(Stream.of(4, 6, 7)));
        Assert.assertThat(((Optional)result.unwrap()).get(), (Matcher)Matchers.equalTo(Arrays.asList(7, 9, 10)));
    }
}

